/*-------------------------------------------------------------------------*/
/*  J3W ver 6.42  3D Animation Kit                                         */
/*  j3dproc.h     10/22/2000                                               */
/*  Copyright (C) 1995 - 2000  Jun Mizutani <mizutani.jun@nifty.ne.jp>     */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_j3dproc_h)
#define _j3dproc_h

#include  "jrlcode.h"
#include  "spaceh3d.h"
#include  "hobj3d.h"

const int RQ   =  1 ;
const int RL   =  2 ;
const int RX   =  3 ;
const int RY   =  4 ;
const int RZ   =  5 ;
const int RH   =  6 ;
const int RP   =  7 ;
const int RB   =  8 ;
const int R1   =  9 ;
const int R2   = 10 ;
const int R3   = 11 ;
const int R4   = 12 ;
const int R5   = 13 ;
const int R6   = 14 ;

const int f_ZERO  = 1 ;
const int f_MINUS = 2 ;

const int M_STOP   = 0x7FFFFFFF ;
const int M_THROW  = 0x7FFFFFFE ;
const int PROC_ALL = 0x7FFF;

#ifdef WS
#ifdef WIN32
#ifdef GetObject
#undef GetObject
#endif //GetObject
#ifdef GetMessage
#undef GetMessage
#endif //GetMessage
#endif //WIN32
#else //WS
typedef short WORD;
#endif //WS

class TJob;
class TProcess {
    long pc;
    long sp;
    long fl;
    long bp;
    long aMessage;
    cCode     *pCode;
    TJob      *pJob;
    TSpaceH3D *pSpace;
    THObj3D   *pObj;
    int  ObjNo;
    long Reg[16];
    long * DataMem;
    long maxDataMem;
    long rest_time;
    long rest_param;
    long total_time;
    long total_x, total_y, total_z;
    long total_h, total_p, total_b;
    long inst_grp;
    long inst_type;
    long reg1, reg2;
    short param16;
    Quaternion qa, qb, dq;
    int  fnew;
    int  fwait;

    void GetOperand();
    long AdjustParam(long &delta, long &r_param);
#ifdef WS
    long MoveInst(short inst_type, long  param);
#else //WS
    long MoveInst(WORD inst_type, long  param);
#endif //WS
    int CheckError(int err);
    int execute(long &delta);
    void RelativePos2(THObj3D *pobj1,
                     long &x,long &y,long &z,long &h,long &p,long &b);
  public:
    TProcess(TJob* jp, int maxData, int StartPos,
                         cCode* code_ptr, TSpaceH3D* p_space,
                         const long *_reg, const int on);
    ~TProcess();
    int GetID() { return  Reg[RQ]; }
    int GetObjNo(){ return ObjNo; }
    THObj3D *GetObject() { return  pObj;}
    long  GetMessage() { return  aMessage;}
    void  SetMessage(long msg){ aMessage = msg;}
    int   Run(long delta);
    void  set_new(int n){ fnew = n; };
    int   get_new() {return fnew; };
};

#endif

