//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSDXKEYBOARD_H
#define WSDXKEYBOARD_H

#include <X11/Xlib.h>
#include <WScom.h>
#include <WSCroot.h>
#include <WSkeysym.h>
#include <WSCstring.h>
#include <WSClistData.h>
#include <WSDkeyboard.h>

#ifdef KINPUT2
#include <X11/Intrinsic.h>
#endif

class WSDxkeyboard :public WSDkeyboard{

  protected:
#ifdef KINPUT2
  WSDdev* _dev_for_kn;
  short _x_kn;
  short _y_kn;
  short _font_kn;
  short _fg_kn;
  short _bg_kn;
  Atom _atom1;
  Atom _atom2;

  void    setDevForKI(WSDdev*);
  WSDdev* getDevForKI();
  static void _kanji_input(Widget,Atom,Atom,int,WSCulong,WSCuchar*,XtPointer);
  static void _kanji_start_end(Widget,Atom,int,XtPointer,Window);
  void   kiKanjiStart();
  void   kiKanjiEnd();

#else  //XIM

  WSDdev* _dev_for_xim;
  void     setDevForXIM(WSDdev*);
  WSDdev* getDevForXIM();

  XIM   _xim;
  XIC   _xic;
  XIC _create_xic(Window,XVaNestedList,XVaNestedList);

static void _status_start(XIC,XPointer,XIMStatusDrawCallbackStruct );
static void _status_done(XIC,XPointer,XIMStatusDrawCallbackStruct );
static void _status_draw(XIC,XPointer,XIMStatusDrawCallbackStruct );
  WSCbool _xim_init;
  XIC  _get_xic(Window);
  static void _im_instantiate(Display*,XPointer,XPointer);
  static void _im_destroy(XIM,XPointer,XPointer);
#endif

    static void _device_move_handler(WSDdev*,void*);
    WSDdev* _dev;
    WSCbool  _focused;

    WSCbool _wait_for_receive_data;

  public:
    WSDxkeyboard();
    virtual ~WSDxkeyboard();

    virtual long initialize();

    WSCbool deliverKeyEvent(XEvent* ev);

    virtual long startKanji(WSDdev*,short x,short y,short fontno,short fgno,short bgno);
    virtual long startAscii(WSDdev*,short x,short y,short fontno,short fgno,short bgno);
    virtual long setFepPos (WSDdev*,short x,short y,short fontno,short fgno,short bgno);
    virtual long resetFep(WSDdev*);

#ifndef KINPUT2    //XIM
    virtual void setEnableFep(WSDdev*,WSCbool);
#endif

    void selectionDataAvailable();
    void setModeWindowPos(short x,short y,WSDdev*);
    virtual void setSelectedString(char*,long encode = WS_EN_DEFAULT);
    virtual char* getSelectedString(long encode = WS_EN_DEFAULT);

//-----------------------------------------------------------------//
WSMFclassDef(WSDxkeyboard,WSDkeyboard);

};
extern WSDxkeyboard* WSGIxkeyboard();
#endif
