package jp.ac.dendai.cdl.mori.wikie.main;


/**
 * メインクラス
 * @author Mori
 *
 */
public class WikIE {
    public static final String ENTRY = "entry";
    public static final String LEAF = "leaf";
    public static final String NODE = "node";
    public static final String EDGE = "edge";
    public static final String OTHER = "other";
    public static final String TARGET = "target";
    public static final String REDIRECT = "redirect";
    public static final String HYPERNYM = "hypernym";

    public static final String UTF8 = "UTF8";

    public static final String MEDIAWIKI_ELEMENT = "mediawiki";
    public static final String BASE_ELEMENT = "base";
    public static final String NAMESPACES_ELEMENT = "namespaces";
    public static final String NAMESPACE_ELEMENT = "namespace";
    public static final String PAGE_ELEMENT = "page";
    public static final String TITLE_ELEMENT = "title";
    public static final String ID_ELEMENT = "id";
    public static final String REVISION_ELEMENT = "revision";
    public static final String TIMESTAMP_ELEMENT = "timestamp";
    public static final String CONTRIBUTOR_ELEMENT = "contributor";
    public static final String USERNAME_ELEMENT = "username";
    public static final String IP_ELEMENT = "ip";
    public static final String TEXT_ELEMENT = "text";

    public static final String KEY_ATTRIBUTE = "key";

    public static final int LEAF_KIND = 1;
    public static final int NODE_KIND = 2;
    public static final int REDIRECT_KIND = 3;
    public static final int HYPERNYM_KIND = 4;

    public static int ARTICLE_NS_NUM = 0;
    public static int IMAGE_NS_NUM = 6;
    public static int CATEGOR_NS_NUM = 14;

    /**
     * メインメソッド
     * @param args 機能, 入力ファイル, 出力フォルダ
     */
    public static void main(String[] args) {
        if (args.length == 0) {
            printHelp();
            return;
        }
        String option = args[0];
        String[] args2 = new String[args.length-1];
        for (int i = 1; i < args.length; i++) {
            args2[i-1] = args[i];
        }
        try {
            if (option.equals("-node")) Driver.node(args2);
            else if (option.equals("-edge")) Driver.edge(args2);
            else if (option.equals("-pageLink")) Driver.pageLink(args2);
            else if (option.equals("-variation")) Driver.variation(args2);
            else if (option.equals("-isbn")) Driver.isbn(args2);
            else if (option.equals("-interWiki")) Driver.interWiki(args2);
            else if (option.equals("-history")) Driver.history(args2);
            else if (option.equals("-test")) Driver.test(args2);
            else if (option.equals("-help")) printHelp();
            else {
                printHelp();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printHelp() {
        System.out.println(
                "-edge: ページ間関係抽出\n" +
                "-history: 編集回数抽出\n" +
                "-interWiki: 言語間リンク抽出\n" +
                "-isbn: ISBNコード抽出\n" +
                "-node: ページ情報抽出\n" +
                "-pageLink: ページ間リンク抽出\n" +
                "-variation: エントリの表記ゆれ抽出\n"
                );
    }
}
