package jp.ac.dendai.cdl.mori.wikie.mapper;

import java.io.*;
import java.util.*;

import jp.ac.dendai.cdl.mori.wikie.main.*;
import jp.ac.dendai.cdl.mori.wikie.util.*;

import org.apache.hadoop.io.*;
import org.apache.hadoop.mapred.*;

/**
 * interWiki処理用Mapper
 * @author Mori
 *
 */
public class InterWikiMapper extends WikipediaMapper implements Mapper<LongWritable, Text, Text, Text> {
    @Override
    public void map(LongWritable key, Text value,
            OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        try {
            String page = WikipediaNormalizer.removeNonPrintingCharacter(value.toString());
            String id  = WikipediaMapper.getValueFromElementName(WikIE.ID_ELEMENT, page, 0, 1);
            String text = WikipediaMapper.getValueFromElementName(WikIE.TEXT_ELEMENT, page, 0, 1);
            Iterator<String> interWikiItr = linkChecker.getInterWiki(text).iterator();
            while (interWikiItr.hasNext()) {
                output.collect(new Text(id), new Text(interWikiItr.next()));
            }
        }
        catch (NullPointerException e) {
            // TODO: handle exception
        }
    }
}
