package jp.ac.dendai.cdl.mori.wikie.mapper;

import java.util.*;
import java.util.regex.*;

import jp.ac.dendai.cdl.mori.wikie.main.*;
import jp.ac.dendai.cdl.mori.wikie.util.*;

import org.apache.hadoop.conf.*;
import org.apache.hadoop.fs.*;
import org.apache.hadoop.mapred.*;

/**
 * 各Mapperの親クラス
 * @author Mori
 *
 */
public abstract class WikipediaMapper extends MapReduceBase {
    /**
     * Normalizer
     */
    public static WikipediaNormalizer normalizer;
    /**
     * LinkChecker
     */
    public static WikipediaLinkChecker linkChecker;

    @Override
    public void configure(JobConf job) {
        super.configure(job);
        try {
            if (normalizer == null) {
                Path p = new Path(FileSystem.get(new Configuration()).getWorkingDirectory(), job.get(Driver.PROP_RESOURCE));
                normalizer = new WikipediaNormalizer(p);
                linkChecker = WikipediaLinkChecker.getInstance(normalizer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 指定したタグの中身を抽出する
     * @param elementName 抽出したいタグ名。&lt;と&gt;は含まない。属性も含まない。
     * @param target 対象とする文字列
     * @param index 何番目に出現するか
     * @param group 取得するグループ
     * @return 取得できた文字列<br>
     *         取得できなかった場合はnullが返される。
     */
    public static String getValueFromElementName(String elementName, String target, int index, int group) {
        Pattern pattern = Pattern.compile("<" + elementName + " *.*?>(.+?)</" + elementName + ">");
        Matcher matcher = pattern.matcher(target);
        int i = 0;
        while (matcher.find() && i <= index) {
            if (i++ == index) {
                return matcher.group(group);
            }
        }
        return null;
    }

    /**
     * 指定したタグの中身をすべて抽出する
     * @param elementName　抽出したいタグ名。&lt;と&gt;は含まない。属性も含まない。
     * @param target　対象とする文字列
     * @param group　取得するグループ
     * @return　取得結果を格納したArrayList
     *         取得結果がない場合は空のArrayList
     */
    public static ArrayList<String> getValuesFromElementName(String elementName, String target, int group) {
        Pattern pattern = Pattern.compile("<" + elementName + " *.*?>(.+?)</" + elementName + ">");
        Matcher matcher = pattern.matcher(target);
        ArrayList<String> result = new ArrayList<String>();
        while (matcher.find()) {
            result.add(matcher.group(group));
        }
        return result;
    }
}
