package jp.ac.dendai.cdl.mori.wikie.reducer;

import java.io.*;
import java.util.*;

import jp.ac.dendai.cdl.mori.wikie.main.*;

import org.apache.hadoop.io.*;
import org.apache.hadoop.mapred.*;

/**
 * edge処理用Reducer
 * @author Mori
 *
 */
public class EdgeReducer extends MapReduceBase implements Reducer<Text, Text, Text, Text>{

    @Override
    public void reduce(Text key, Iterator<Text> inputValueItr, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        String entryId = new String("-1");

        ArrayList<String> inputValueArrayList = new ArrayList<String>();
        while (inputValueItr.hasNext()) {
            String inputValue = inputValueItr.next().toString();
            String[] status = inputValue.split("\t");
            if (status[0].equals(WikIE.ENTRY)) {
                entryId = status[2];
                //output.collect(new Text(status[2]), new Text(key.toString() + "\t" + status[1]));
            }
            else {
                inputValueArrayList.add(inputValue);
            }
        }
        Iterator<String> inputValueIterator = inputValueArrayList.iterator();
        while (inputValueIterator.hasNext()) {
            String inputValue = inputValueIterator.next();
            String[] status = inputValue.split("\t");
            String type = status[0];
                if (type.equals(WikIE.EDGE)) {
                    output.collect(new Text(status[1]), new Text(entryId + "\t" + WikIE.HYPERNYM));
                }
                else if (type.equals(WikIE.TARGET)) {
                    output.collect(new Text(status[1]), new Text(entryId + "\t" + WikIE.TARGET));
                }
        }
    }
}
