package jp.ac.dendai.cdl.mori.wikie.reducer;

import java.io.*;
import java.util.*;

import org.apache.hadoop.io.*;
import org.apache.hadoop.mapred.*;
import org.apache.hadoop.mapred.lib.*;

/**
 * interWiki処理用Reducer
 * @author Mori
 *
 */
public class InterWikiReducer extends IdentityReducer<Text, Text> {
    @Override
    public void reduce(Text key, Iterator<Text> values, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        StringBuffer link = new StringBuffer();
        while (values.hasNext()) {
            link.append(values.next() + "\t");
        }
        link.deleteCharAt(link.length()-1);
        output.collect(key, new Text(link.toString()));
    }
}
