package jp.ac.dendai.cdl.mori.wikie.util;

import java.io.*;
import java.net.*;
import java.util.*;
import java.util.regex.*;

import jp.ac.dendai.cdl.mori.wikie.main.*;

/**
 * Wikipediaのロボットユーザを表す。
 * @author Mori
 *
 */
public class WikipediaBot {
    /**
     * 唯一のインスタンス
     */
    private static WikipediaBot instance = null;
    /**
     * ロボットの名前が掲載されているページのURL
     */
    public static final String URL = "http://ja.wikipedia.org/wiki/Category:Wikipedia_bots";
    /**
     * ロボットの名前を格納しておく
     */
    private ArrayList<String> botNameArray;

    private WikipediaBot() {
        this.botNameArray = new ArrayList<String>();
        setBotNameArray();
    }

    /**
     * WikipediaBotインスタンス取得用
     * @return WikipediaBotインスタンス
     */
    public static WikipediaBot getInstance() {
        if (instance == null) {
            instance = new WikipediaBot();
        }
        return instance;
    }

    /**
     * ロボットの名前を設定する。
     * URLにあるページから集める。
     */
    private void setBotNameArray() {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(WikipediaBot.URL).openStream(), WikIE.UTF8));
            String line = new String();
            while ((line = reader.readLine()) != null) {
                Pattern pattern = Pattern.compile("<a href=\".+?\" title=\"利用者:.+?\">利用者:(.+?)</a>");
                Matcher matcher = pattern.matcher(line);
                while (matcher.find()) {
                    String newBotName = matcher.group(1);
                    if (!this.botNameArray.contains(newBotName)) {
                        botNameArray.add(newBotName);
                    }
                }
            }
            System.out.println(botNameArray.size() + "のBotを検出");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * ユーザ名がロボットのものであるか判定する。
     * @param userName ユーザ名
     * @return ロボットならtrue
     */
    public boolean contains(String userName) {
        return botNameArray.contains(userName);
    }
}
