package jp.ac.dendai.cdl.mori.wikie.util;

import static org.junit.Assert.*;

import java.io.*;
import java.util.*;

import org.junit.*;

public class WikipediaLinkCheckerTest {
    private static WikipediaLinkChecker checker;
    private static WikipediaNormalizer normalizer;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        normalizer = new WikipediaNormalizer(new File("input/jawiki-latest-pages-meta-current.xml"));
        checker = WikipediaLinkChecker.getInstance(normalizer);
    }

    @Test
    public void testIsRedirect() {
        assertEquals("アメリカ合衆国", checker.isRedirect("#REDIRECT [[アメリカ合衆国]]"));
        assertEquals("アメリカ合衆国", checker.isRedirect(" #redirect [[アメリカ合衆国]] "));
        assertEquals("アメリカ合衆国", checker.isRedirect(" # redirect [[ アメリカ合衆国 ]]"));
        assertEquals("アメリカ合衆国", checker.isRedirect(" # redirect [[:アメリカ合衆国]]"));
    }

    //@Test
    public void testGetCategory() {
        String[] correct = {"category:言語", "category:言語学", "category:民族"};
        String[] target = new String[]{};
        target = checker.getCategory("[[Category:言語|*]][[ category:言語学|けんこ ]][[  category:民族|けんこ]]").toArray(target);
        assertArrayEquals(correct, target);
    }

    @Test
    public void testGetInterWiki() {
        String[] correct = {"en:Language",
                            "ar:لغة",
                            "bat-smg:Kalba",
                            "be:Мова",
                            "be-x-old:Мова",
                            "bg:Език (лингвистика)"};
        String[] target = new String[]{};
        target = checker.getInterWiki("[[:en:Richard M. Daley]][[EN:Language]][[ar:لغة]][[category:abc]][[bat-smg:Kalba]][[be:Мова]][[be-x-old:Мова]][[bg:Език (лингвистика)]][[def]]").toArray(target);
        assertArrayEquals(correct, target);
    }

    @Test
    public void testGetPageLink() {
        String[] correct1 = {"Wikipedia", "Wikipedia"};
        String[] correct2 = {"ウィキペディア", "リンク方法"};
        ArrayList<WikipediaLink> target = checker.getPageLink(
                "[[wikipedia|ウィキペディア]]" +
                "[[ wikipedia # リンクの貼り方 | リンク方法 ]]");
        for (int i = 0; i < correct1.length; i++) {
            WikipediaLink link = target.get(i);
            String entry = link.getEntryTitle();
            String anchor = link.getAnchorText();
            assertEquals(correct1[i], entry);
            assertEquals(correct2[i], anchor);
        }
    }
    /*
    @Test
    public void testGetLinkType() {
        assertEquals(0, checker.getLinkType("abc"));
        assertEquals(0, checker.getLinkType(":abc"));
        assertEquals(1, checker.getLinkType(":en:abc"));
        assertEquals(2, checker.getLinkType("en:abc"));
    }
    */
    @Test
    public void testNormalizerLink() {
        assertEquals("#コンパクトタイプ|T70", checker.normalizeLink("#.E3.82.B3.E3.83.B3.E3.83.91.E3.82.AF.E3.83.88.E3.82.BF.E3.82.A4.E3.83.97|T70"));
        assertEquals(".hack//G.U.: The World", checker.normalizeLink(".hack//G.U.: The World"));
        assertEquals("特別:BrokenRedirects", checker.normalizeLink("%E7%89%B9%E5%88%A5:BrokenRedirects"));
        assertEquals("", checker.normalizeLink("category:"));
        assertEquals("Wikipedia", checker.normalizeLink("wikipedia"));
        assertEquals("abc", checker.spilitLink("abc"));
        assertEquals("en:\tabc", checker.spilitLink("en:abc"));
        assertEquals("abc", checker.spilitLink("abc"));
        assertEquals("Abc", checker.normalizeLink("abc"));
        assertEquals("Abc", checker.normalizeLink(":abc"));
        assertEquals(":en:Abc", checker.normalizeLink(":En:abc"));
        assertEquals("en:category:Computer: abc", checker.normalizeLink("En : Category : computer: abc"));
        assertEquals(":en:category:Computer: abc", checker.normalizeLink(":En : Category : computer: abc"));
    }
}
