package jp.ac.dendai.cdl.mori.wikie.util;

import java.text.*;
import java.util.*;

/**
 * Wikipediaの編集履歴一件分を表現するクラス。
 * @author 05ki103
 *
 */
public class WikipediaRevision {
    /**
     * ユーザ名
     */
    private String userName;
    /**
     * タイムスタンプ
     */
    private String timestamp;
    /**
     * タイムスタンプをUTCに変換したもの
     */
    private Date utc;

    /**
     * コンストラクタ
     * @param userName ユーザ名
     * @param timestamp ソースとなるXMLファイルのtimestamp要素の内容そのまま
     * @throws ParseException
     */
    public WikipediaRevision(String userName, String timestamp) throws ParseException {
        this.userName = userName;
        this.timestamp = timestamp;
        this.utc = convertToUTC(this.timestamp);
    }

    /**
     * ユーザ名を返す
     * @return　ユーザ名
     */
    public String getUserName() {
        return userName;
    }

    /**
     * タイムスタンプを返す
     * @return タイムスタンプ
     */
    public String getTimestamp() {
        return timestamp;
    }

    /**
     * タイムスタンプをUTCに変換した時間を返す
     * @return UTC時間
     */
    public Date getUtc() {
        return utc;
    }

    /**
     * WikipediaのXMLファイルのタイムスタンプをUTCに変換する
     * @param timestamp　ソースとなるXMLファイルのtimestamp要素の内容そのまま
     * @return　タイムスタンプをUTCに変換した時間を返す
     * @throws ParseException
     */
    public static Date convertToUTC(String timestamp) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Calendar c = Calendar.getInstance();
        Date jtc = sdf.parse(timestamp);
        c.setTime(jtc);
        c.add(Calendar.HOUR, -9);
        Date utc = c.getTime();
        return utc;
    }
}
