/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.api;

import info.bliki.api.Page;
import info.bliki.api.User;
import info.bliki.api.XMLPagesParser;
import info.bliki.api.XMLUserParser;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connector {
    public static final String USER_AGENT = "plog4u.org/3.0";
    public static final String UTF8_CHARSET = "utf-8";
    private MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
    private HttpClient client = new HttpClient((HttpConnectionManager)this.manager);

    public User login(User user) {
        PostMethod method = new PostMethod(user.getActionUrl());
        String userName = user.getUsername();
        if (userName == null || userName.trim().length() == 0) {
            return user;
        }
        method.setFollowRedirects(false);
        method.addRequestHeader("User-Agent", USER_AGENT);
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("action", "login"), new NameValuePair("format", "xml"), new NameValuePair("lgname", userName), new NameValuePair("lgpassword", user.getPassword())};
        method.addParameters(params);
        try {
            int responseCode = this.client.executeMethod((HttpMethod)method);
            if (responseCode == 200) {
                String responseBody = method.getResponseBodyAsString();
                XMLUserParser parser = new XMLUserParser(user, responseBody);
                parser.parse();
                if (!user.getResult().equals("Success")) {
                    return null;
                }
                User user2 = user;
                return user2;
            }
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        finally {
            method.releaseConnection();
        }
        return null;
    }

    public List<Page> queryContent(User user, List<String> listOfTitleStrings) {
        String[] valuePairs = new String[]{"prop", "revisions", "rvprop", "timestamp|user|comment|content"};
        return this.query(user, listOfTitleStrings, valuePairs);
    }

    public List<Page> queryCategories(User user, List<String> listOfTitleStrings) {
        String[] valuePairs = new String[]{"prop", "categories"};
        return this.query(user, listOfTitleStrings, valuePairs);
    }

    public List<Page> queryInfo(User user, List<String> listOfTitleStrings) {
        String[] valuePairs = new String[]{"prop", "info"};
        return this.query(user, listOfTitleStrings, valuePairs);
    }

    public List<Page> queryLinks(User user, List<String> listOfTitleStrings) {
        String[] valuePairs = new String[]{"prop", "links"};
        return this.query(user, listOfTitleStrings, valuePairs);
    }

    public List<Page> queryImageinfo(User user, List<String> listOfImageStrings) {
        String[] valuePairs = new String[]{"prop", "imageinfo", "iiprop", "url"};
        return this.query(user, listOfImageStrings, valuePairs);
    }

    public List<Page> query(User user, List<String> listOfTitleStrings, String[] valuePairs) {
        PostMethod method = new PostMethod(user.getActionUrl());
        method.setFollowRedirects(false);
        method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        method.setRequestHeader("User-Agent", USER_AGENT);
        StringBuffer titlesString = new StringBuffer();
        int i = 0;
        while (i < listOfTitleStrings.size()) {
            titlesString.append(listOfTitleStrings.get(i));
            if (i < listOfTitleStrings.size() - 1) {
                titlesString.append("|");
            }
            ++i;
        }
        int k = 0;
        int size = 6;
        if (valuePairs != null) {
            size = 6 + valuePairs.length / 2;
        }
        try {
            NameValuePair[] params = new NameValuePair[size];
            params[k++] = new NameValuePair("action", "query");
            params[k++] = new NameValuePair("titles", titlesString.toString());
            params[k++] = new NameValuePair("lgusername", user.getUserid());
            params[k++] = new NameValuePair("lguserid", user.getNormalizedUsername());
            params[k++] = new NameValuePair("lgtoken", user.getToken());
            params[k++] = new NameValuePair("format", "xml");
            if (valuePairs != null && valuePairs.length > 0) {
                int i2 = 0;
                while (i2 < valuePairs.length) {
                    params[k++] = new NameValuePair(valuePairs[i2], valuePairs[i2 + 1]);
                    i2 += 2;
                }
            }
            method.addParameters(params);
            int responseCode = this.client.executeMethod((HttpMethod)method);
            if (responseCode == 200) {
                String responseBody = method.getResponseBodyAsString();
                XMLPagesParser parser = new XMLPagesParser(responseBody);
                parser.parse();
                List<Page> list = parser.getPagesList();
                return list;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        finally {
            method.releaseConnection();
        }
        return new ArrayList<Page>();
    }
}

