/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.dendai.cdl.mori.wikie.mapred;

import java.io.IOException;
import java.util.ArrayList;
import jp.ac.dendai.cdl.mori.wikie.mapred.WMapper;
import jp.ac.dendai.cdl.mori.wikie.parser.WPageElementHandler;
import jp.ac.dendai.cdl.mori.wikie.util.WEntry;
import jp.ac.dendai.cdl.mori.wikie.util.WLink;
import jp.ac.dendai.cdl.mori.wikie.util.WNormalizer;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public class PageLinkMapper
extends WMapper {
    public void map(LongWritable key, Text value, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        try {
            WPageElementHandler page = this.createPageHandler(value);
            WEntry entry = this.normalizer.normalize(page.getTitle());
            String title = entry.toString();
            String id = page.getId();
            String text = WNormalizer.deleteNonPrintingChar(page.getText());
            String kind = this.linkUtils.getKind(entry, text);
            output.collect((Object)new Text(title), (Object)new Text("entry\t" + id));
            if (kind.equals("leaf")) {
                ArrayList<String> exist = new ArrayList<String>();
                for (WLink link : this.linkUtils.getLink(text)) {
                    String linkAsString = link.toString();
                    if (exist.contains(linkAsString)) continue;
                    String target = link.getEntry().toString();
                    if (target.length() == 0) {
                        output.collect((Object)new Text(title), (Object)new Text(String.valueOf(id) + "\t" + link.getSection() + "\t" + link.getAnchorText()));
                    } else {
                        output.collect((Object)new Text(link.getEntry().toString()), (Object)new Text(String.valueOf(id) + "\t" + link.getSection() + "\t" + link.getAnchorText()));
                    }
                    exist.add(linkAsString);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

