/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.model;

import info.bliki.wiki.filter.WikipediaScanner;
import java.util.List;

public class ImageFormat {
    private String fFilename;
    private String fType;
    private String fLocation = "none";
    private String fSizeStr = null;
    private int fSize = -1;
    private String fCaption;
    private String fAlt;
    private String fNamespace;

    public static ImageFormat getImageFormat(String rawImageLink, String imageNamespace) {
        ImageFormat img = new ImageFormat();
        List<String> list = WikipediaScanner.splitByPipe(rawImageLink, null);
        if (list.size() > 0) {
            String token = list.get(0);
            img.setFilename("");
            if (token.length() > imageNamespace.length() && token.charAt(imageNamespace.length()) == ':' && imageNamespace.equalsIgnoreCase(token.substring(0, imageNamespace.length()))) {
                img.setFilename(token.substring(imageNamespace.length() + 1));
                img.setNamespace(imageNamespace);
            }
            int j = 1;
            while (j < list.size()) {
                String caption = list.get(j).trim();
                if (caption.length() > 0) {
                    token = caption.toLowerCase();
                    if (token.equals("frame") || token.equals("thumb") || token.equals("thumbnail")) {
                        img.setType(token);
                    } else if (token.equals("right") || token.equals("left") || token.equals("center") || token.equals("none")) {
                        img.setLocation(token);
                    } else if (token.endsWith("px")) {
                        img.setSize(token);
                    } else {
                        img.setCaption(caption);
                    }
                }
                ++j;
            }
        }
        return img;
    }

    public String getAlt() {
        return this.fAlt;
    }

    public String getCaption() {
        return this.fCaption;
    }

    public String getFilename() {
        return this.fFilename;
    }

    public String getLocation() {
        return this.fLocation;
    }

    public String getNamespace() {
        return this.fNamespace;
    }

    public int getSize() {
        return this.fSize;
    }

    public String getSizeStr() {
        return this.fSizeStr;
    }

    public String getType() {
        return this.fType;
    }

    public void setAlt(String alt) {
        this.fAlt = alt;
    }

    public void setCaption(String caption) {
        this.fCaption = caption;
    }

    public void setFilename(String filename) {
        this.fFilename = filename;
    }

    public void setLocation(String location) {
        this.fLocation = location.toLowerCase();
    }

    public void setNamespace(String namespace) {
        this.fNamespace = namespace;
    }

    public void setSize(String size) {
        this.fSizeStr = size.toLowerCase();
        if (this.fSizeStr.endsWith("px")) {
            try {
                this.fSize = Integer.parseInt(this.fSizeStr.substring(0, this.fSizeStr.length() - 2));
                if (this.fSize < 0) {
                    this.fSize = -1;
                    this.fSizeStr = null;
                }
            }
            catch (NumberFormatException e) {
                this.fSize = -1;
                this.fSizeStr = null;
            }
        }
    }

    public void setType(String type) {
        this.fType = type.toLowerCase();
    }
}

