/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.dendai.cdl.mori.wikie.util;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import jp.ac.dendai.cdl.mori.wikie.util.WLink;
import jp.ac.dendai.cdl.mori.wikie.util.WLinkUtils;
import jp.ac.dendai.cdl.mori.wikie.util.WNormalizer;
import org.junit.Assert;
import org.junit.Test;

public class WLinkUtilsTest {
    public Set<String> langSet = new TreeSet<String>();
    public Set<String> proSet;

    public WLinkUtilsTest() {
        this.langSet.add("en");
        this.proSet = new TreeSet<String>();
        this.proSet.add("w");
    }

    @Test
    public void testGetPage() {
        try {
            WNormalizer n = new WNormalizer("pageHead.xml", this.proSet, this.langSet);
            WLinkUtils link = new WLinkUtils(n);
            List<WLink> linkList = link.getLink("[[ \u767e\u79d1\u4e8b\u5178 # \u6b74\u53f2 | \u767e\u79d1\u4e8b\u5178\u306e\u6b74\u53f2 ]]");
            for (WLink wl : linkList) {
                Assert.assertEquals((Object)"\u767e\u79d1\u4e8b\u5178#\u6b74\u53f2|\u767e\u79d1\u4e8b\u5178\u306e\u6b74\u53f2", (Object)wl.toString());
            }
            linkList = link.getLink("[[ \u767e\u79d1\u4e8b\u5178 # \u6b74\u53f2 ]]");
            for (WLink wl : linkList) {
                Assert.assertEquals((Object)"\u767e\u79d1\u4e8b\u5178#\u6b74\u53f2", (Object)wl.toString());
            }
            linkList = link.getLink("[[\u767e\u79d1\u4e8b\u5178 | \u767e\u79d1\u4e8b\u5178\u306e\u6b74\u53f2 ]]");
            for (WLink wl : linkList) {
                Assert.assertEquals((Object)"\u767e\u79d1\u4e8b\u5178|\u767e\u79d1\u4e8b\u5178\u306e\u6b74\u53f2", (Object)wl.toString());
            }
            linkList = link.getLink("[[ \u767e\u79d1\u4e8b\u5178 ]]");
            for (WLink wl : linkList) {
                Assert.assertEquals((Object)"\u767e\u79d1\u4e8b\u5178", (Object)wl.toString());
            }
            linkList = link.getLink("[[ # \u6b74\u53f2 | \u767e\u79d1\u4e8b\u5178\u306e\u6b74\u53f2 ]]");
            for (WLink wl : linkList) {
                Assert.assertEquals((Object)"#\u6b74\u53f2|\u767e\u79d1\u4e8b\u5178\u306e\u6b74\u53f2", (Object)wl.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

