package jp.ac.dendai.cdl.mori.wikie.test;

import java.io.*;

import org.apache.hadoop.conf.*;
import org.apache.hadoop.fs.*;
import org.apache.hadoop.io.*;
import org.apache.hadoop.mapred.*;
import org.apache.hadoop.util.*;

public class Diff extends Configured implements Tool {

    public static void main(String[] args) throws Exception {
        ToolRunner.run(new Configuration(), new Diff(), args);
    }

    @Override
    public int run(String[] args) throws Exception {
        JobConf conf = createJobConf(args);
        if (conf != null) {
            JobClient.runJob(conf);
            return 0;
        }
        return -1;
    }

    /**
     * 実行するJobConfを生成する。
     * @param args　コマンドライン引数
     * @return 生成したJobConf
     * @throws IOException
     * @throws ClassNotFoundException
     */
    public JobConf createJobConf(String[] args)
    throws IOException, ClassNotFoundException {
        JobConf conf = new JobConf(Diff.class);
        conf.setMapperClass(DiffMapper.class);
        conf.setReducerClass(DiffReducer.class);
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputFormat(TextOutputFormat.class);
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(Text.class);
        FileInputFormat.setInputPaths(conf, new Path(args[0]), new Path(args[1]));
        FileOutputFormat.setOutputPath(conf, new Path(args[2]));
        return conf;
    }

}
