/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterManager;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.ipc.HMasterInterface;
import org.apache.hadoop.hbase.util.Threads;

@InterfaceAudience.Private
public class DistributedHBaseCluster
extends HBaseCluster {
    private HBaseAdmin admin;
    private ClusterManager clusterManager;

    public DistributedHBaseCluster(Configuration conf, ClusterManager clusterManager) throws IOException {
        super(conf);
        this.clusterManager = clusterManager;
        this.admin = new HBaseAdmin(conf);
        this.initialClusterStatus = this.getClusterStatus();
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    @Override
    public ClusterStatus getClusterStatus() throws IOException {
        return this.admin.getClusterStatus();
    }

    @Override
    public ClusterStatus getInitialClusterStatus() throws IOException {
        return this.initialClusterStatus;
    }

    @Override
    public void close() throws IOException {
        if (this.admin != null) {
            this.admin.close();
        }
    }

    @Override
    public void startRegionServer(String hostname) throws IOException {
        LOG.info((Object)("Starting RS on: " + hostname));
        this.clusterManager.start(ClusterManager.ServiceType.HBASE_REGIONSERVER, hostname);
    }

    @Override
    public void killRegionServer(ServerName serverName) throws IOException {
        LOG.info((Object)("Aborting RS: " + serverName.getServerName()));
        this.clusterManager.kill(ClusterManager.ServiceType.HBASE_REGIONSERVER, serverName.getHostname());
    }

    @Override
    public void stopRegionServer(ServerName serverName) throws IOException {
        LOG.info((Object)("Stopping RS: " + serverName.getServerName()));
        this.clusterManager.stop(ClusterManager.ServiceType.HBASE_REGIONSERVER, serverName.getHostname());
    }

    @Override
    public void waitForRegionServerToStop(ServerName serverName, long timeout) throws IOException {
        this.waitForServiceToStop(ClusterManager.ServiceType.HBASE_REGIONSERVER, serverName, timeout);
    }

    private void waitForServiceToStop(ClusterManager.ServiceType service, ServerName serverName, long timeout) throws IOException {
        LOG.info((Object)("Waiting service:" + (Object)((Object)service) + " to stop: " + serverName.getServerName()));
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout) {
            if (!this.clusterManager.isRunning(service, serverName.getHostname())) {
                return;
            }
            Threads.sleep((long)1000L);
        }
        throw new IOException("did timeout waiting for service to stop:" + serverName);
    }

    @Override
    public HMasterInterface getMasterAdmin() throws IOException {
        HConnection conn = HConnectionManager.getConnection((Configuration)this.conf);
        return conn.getMaster();
    }

    @Override
    public void startMaster(String hostname) throws IOException {
        LOG.info((Object)("Starting Master on: " + hostname));
        this.clusterManager.start(ClusterManager.ServiceType.HBASE_MASTER, hostname);
    }

    @Override
    public void killMaster(ServerName serverName) throws IOException {
        LOG.info((Object)("Aborting Master: " + serverName.getServerName()));
        this.clusterManager.kill(ClusterManager.ServiceType.HBASE_MASTER, serverName.getHostname());
    }

    @Override
    public void stopMaster(ServerName serverName) throws IOException {
        LOG.info((Object)("Stopping Master: " + serverName.getServerName()));
        this.clusterManager.stop(ClusterManager.ServiceType.HBASE_MASTER, serverName.getHostname());
    }

    @Override
    public void waitForMasterToStop(ServerName serverName, long timeout) throws IOException {
        this.waitForServiceToStop(ClusterManager.ServiceType.HBASE_MASTER, serverName, timeout);
    }

    @Override
    public boolean waitForActiveAndReadyMaster(long timeout) throws IOException {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout) {
            try {
                this.getMasterAdmin();
                return true;
            }
            catch (MasterNotRunningException m) {
                LOG.warn((Object)("Master not started yet " + (Object)((Object)m)));
            }
            catch (ZooKeeperConnectionException e) {
                LOG.warn((Object)("Failed to connect to ZK " + (Object)((Object)e)));
            }
            Threads.sleep((long)1000L);
        }
        return false;
    }

    @Override
    public ServerName getServerHoldingRegion(byte[] regionName) throws IOException {
        HConnection connection = this.admin.getConnection();
        HRegionLocation regionLoc = connection.locateRegion(regionName);
        if (regionLoc == null) {
            return null;
        }
        HServerInfo sn = connection.getHRegionConnection(regionLoc.getHostname(), regionLoc.getPort()).getHServerInfo();
        return new ServerName(sn.getServerAddress().getHostname(), sn.getServerAddress().getPort(), sn.getStartCode());
    }

    @Override
    public void waitUntilShutDown() {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public void shutdown() throws IOException {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public boolean isDistributedCluster() {
        return true;
    }

    @Override
    public void restoreClusterStatus(ClusterStatus initial) throws IOException {
        ClusterStatus current = this.getClusterStatus();
        if (!ServerName.isSameHostnameAndPort((ServerName)initial.getMaster(), (ServerName)current.getMaster())) {
            boolean foundOldMaster = false;
            for (ServerName currentBackup : current.getBackupMasters()) {
                if (!ServerName.isSameHostnameAndPort((ServerName)currentBackup, (ServerName)initial.getMaster())) {
                    this.stopMaster(currentBackup);
                    continue;
                }
                foundOldMaster = true;
            }
            this.stopMaster(current.getMaster());
            if (foundOldMaster) {
                this.startMaster(initial.getMaster().getHostname());
            }
            this.waitForActiveAndReadyMaster();
            for (ServerName backup : initial.getBackupMasters()) {
                this.startMaster(backup.getHostname());
            }
        } else {
            HashMap<String, ServerName> initialBackups = new HashMap<String, ServerName>();
            HashMap<String, ServerName> currentBackups = new HashMap<String, ServerName>();
            for (ServerName server : initial.getBackupMasters()) {
                initialBackups.put(server.getHostname(), server);
            }
            for (ServerName server : current.getBackupMasters()) {
                currentBackups.put(server.getHostname(), server);
            }
            for (String hostname : Sets.difference(initialBackups.keySet(), currentBackups.keySet())) {
                this.startMaster(hostname);
            }
            for (String hostname : Sets.difference(currentBackups.keySet(), initialBackups.keySet())) {
                this.stopMaster((ServerName)currentBackups.get(hostname));
            }
        }
        HashMap<String, ServerName> initialServers = new HashMap<String, ServerName>();
        HashMap<String, ServerName> currentServers = new HashMap<String, ServerName>();
        for (ServerName server : initial.getServers()) {
            initialServers.put(server.getHostname(), server);
        }
        for (ServerName server : current.getServers()) {
            currentServers.put(server.getHostname(), server);
        }
        for (String hostname : Sets.difference(initialServers.keySet(), currentServers.keySet())) {
            this.startRegionServer(hostname);
        }
        for (String hostname : Sets.difference(currentServers.keySet(), initialServers.keySet())) {
            this.stopRegionServer((ServerName)currentServers.get(hostname));
        }
    }
}

