/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ClusterManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.util.Shell;

@InterfaceAudience.Private
public class HBaseClusterManager
extends ClusterManager {
    protected CommandProvider getCommandProvider(ClusterManager.ServiceType service) {
        return new HBaseShellCommandProvider();
    }

    private Pair<Integer, String> exec(String hostname, String ... cmd) throws IOException {
        LOG.info((Object)("Executing remote command: " + StringUtils.join((Object[])cmd, (String)" ") + " , hostname:" + hostname));
        RemoteShell shell = new RemoteShell(hostname, cmd);
        shell.execute();
        LOG.info((Object)("Executed remote command, exit code:" + shell.getExitCode() + " , output:" + shell.getOutput()));
        return new Pair((Object)shell.getExitCode(), (Object)shell.getOutput());
    }

    private void exec(String hostname, ClusterManager.ServiceType service, CommandProvider.Operation op) throws IOException {
        this.exec(hostname, this.getCommandProvider(service).getCommand(service, op));
    }

    @Override
    public void start(ClusterManager.ServiceType service, String hostname) throws IOException {
        this.exec(hostname, service, CommandProvider.Operation.START);
    }

    @Override
    public void stop(ClusterManager.ServiceType service, String hostname) throws IOException {
        this.exec(hostname, service, CommandProvider.Operation.STOP);
    }

    @Override
    public void restart(ClusterManager.ServiceType service, String hostname) throws IOException {
        this.exec(hostname, service, CommandProvider.Operation.RESTART);
    }

    @Override
    public void signal(ClusterManager.ServiceType service, String signal, String hostname) throws IOException {
        this.exec(hostname, this.getCommandProvider(service).signalCommand(service, signal));
    }

    @Override
    public boolean isRunning(ClusterManager.ServiceType service, String hostname) throws IOException {
        String ret = (String)this.exec(hostname, this.getCommandProvider(service).isRunningCommand(service)).getSecond();
        return ret.length() > 0;
    }

    static class HBaseShellCommandProvider
    extends CommandProvider {
        HBaseShellCommandProvider() {
        }

        private String getHBaseHome() {
            return System.getenv("HBASE_HOME");
        }

        private String getConfig() {
            String confDir = System.getenv("HBASE_CONF_DIR");
            if (confDir != null) {
                return String.format("--config %s", confDir);
            }
            return "";
        }

        @Override
        public String getCommand(ClusterManager.ServiceType service, CommandProvider.Operation op) {
            return String.format("%s/bin/hbase-daemon.sh %s %s %s", new Object[]{this.getHBaseHome(), this.getConfig(), op.toString().toLowerCase(), service});
        }
    }

    static abstract class CommandProvider {
        CommandProvider() {
        }

        public abstract String getCommand(ClusterManager.ServiceType var1, Operation var2);

        public String isRunningCommand(ClusterManager.ServiceType service) {
            return this.findPidCommand(service);
        }

        protected String findPidCommand(ClusterManager.ServiceType service) {
            return String.format("ps aux | grep %s | grep -v grep | tr -s ' ' | cut -d ' ' -f2", new Object[]{service});
        }

        public String signalCommand(ClusterManager.ServiceType service, String signal) {
            return String.format("%s | xargs kill -s %s", this.findPidCommand(service), signal);
        }

        static enum Operation {
            START,
            STOP,
            RESTART;

        }
    }

    static class RemoteShell
    extends Shell.ShellCommandExecutor {
        private String hostname;
        private String sshCmd = "/usr/bin/ssh";
        private String sshOptions = System.getenv("HBASE_SSH_OPTS");

        public RemoteShell(String hostname, String[] execString, File dir, Map<String, String> env, long timeout) {
            super(execString, dir, env, timeout);
            this.hostname = hostname;
        }

        public RemoteShell(String hostname, String[] execString, File dir, Map<String, String> env) {
            super(execString, dir, env);
            this.hostname = hostname;
        }

        public RemoteShell(String hostname, String[] execString, File dir) {
            super(execString, dir);
            this.hostname = hostname;
        }

        public RemoteShell(String hostname, String[] execString) {
            super(execString);
            this.hostname = hostname;
        }

        public String[] getExecString() {
            return new String[]{"bash", "-c", StringUtils.join((Object[])new String[]{this.sshCmd, this.sshOptions == null ? "" : this.sshOptions, this.hostname, "\"" + StringUtils.join((Object[])super.getExecString(), (String)" ") + "\""}, (String)" ")};
        }

        public void execute() throws IOException {
            super.execute();
        }

        public void setSshCmd(String sshCmd) {
            this.sshCmd = sshCmd;
        }

        public void setSshOptions(String sshOptions) {
            this.sshOptions = sshOptions;
        }

        public String getSshCmd() {
            return this.sshCmd;
        }

        public String getSshOptions() {
            return this.sshOptions;
        }
    }
}

