/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;

public class ResourceChecker {
    private static final Log LOG = LogFactory.getLog(ResourceChecker.class);
    private static Set<String> initialThreadNames = new HashSet<String>();
    private static final ResourceAnalyzer rc = new ResourceAnalyzer();
    private static final long MAX_THREADS_COUNT = 500L;
    private static final long MAX_FILE_HANDLES_COUNT = 1024L;
    private long initialThreadsCount;
    private long initialFileHandlesCount;
    private long initialConnectionCount;

    public boolean checkThreads(String tagLine) {
        boolean isOk = true;
        long threadCount = rc.getThreadsCount(Phase.INTERMEDIATE);
        if (threadCount > 500L) {
            LOG.error((Object)(tagLine + ": too many threads used. We use " + threadCount + " our max is " + 500L));
            isOk = false;
        }
        return isOk;
    }

    public boolean check(String tagLine) {
        boolean isOk = this.checkThreads(tagLine);
        if (!this.checkFileHandles(tagLine)) {
            isOk = false;
        }
        return isOk;
    }

    public ResourceChecker(String tagLine) {
        this.init(tagLine);
    }

    public final void init(String tagLine) {
        if (rc.getMaxFileDescriptorCount() < 1024L) {
            LOG.error((Object)("Bad configuration: the operating systems file handles maximum is " + rc.getMaxFileDescriptorCount() + " our is " + 1024L));
        }
        this.logInfo(Phase.INITIAL, tagLine);
        this.initialThreadsCount = rc.getThreadsCount(Phase.INITIAL);
        this.initialFileHandlesCount = rc.getOpenFileDescriptorCount();
        this.initialConnectionCount = rc.getConnectionCount();
        this.check(tagLine);
    }

    public void logInfo(Phase phase, String tagLine) {
        Map<Thread, StackTraceElement[]> stackTraces;
        long threadCount = rc.getThreadsCount(phase);
        LOG.info((Object)(tagLine + ": " + threadCount + " threads" + (this.initialThreadsCount > 0L ? " (was " + this.initialThreadsCount + "), " : ", ") + rc.getOpenFileDescriptorCount() + " file descriptors" + (this.initialFileHandlesCount > 0L ? " (was " + this.initialFileHandlesCount + "). " : " ") + rc.getConnectionCount() + " connections" + (this.initialConnectionCount > 0L ? " (was " + this.initialConnectionCount + "), " : ", ") + (this.initialThreadsCount > 0L && threadCount > this.initialThreadsCount ? " -thread leak?- " : "") + (this.initialFileHandlesCount > 0L && rc.getOpenFileDescriptorCount() > this.initialFileHandlesCount ? " -file handle leak?- " : "") + (this.initialConnectionCount > 0L && rc.getConnectionCount() > this.initialConnectionCount ? " -connection leak?- " : "")));
        if (phase == Phase.END && (stackTraces = Thread.getAllStackTraces()).size() > initialThreadNames.size()) {
            for (Thread t : stackTraces.keySet()) {
                StackTraceElement[] stackElements;
                if (initialThreadNames.contains(t.getName())) continue;
                LOG.info((Object)(tagLine + ": potentially hanging thread - " + t.getName()));
                for (StackTraceElement ele : stackElements = stackTraces.get(t)) {
                    LOG.info((Object)("\t" + ele));
                }
            }
        }
    }

    public boolean checkFileHandles(String tagLine) {
        boolean isOk = true;
        if (rc.getOpenFileDescriptorCount() > 1024L) {
            LOG.error((Object)(tagLine + ": too many file handles used. We use " + rc.getOpenFileDescriptorCount() + " our max is " + 1024L));
            isOk = false;
        }
        return isOk;
    }

    public static void printThreads() {
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        System.out.println("name; state; isDameon; isAlive; isInterrupted");
        for (Thread t : threads) {
            System.out.println(t.getName() + ";" + (Object)((Object)t.getState()) + ";" + t.isDaemon() + ";" + t.isAlive() + ";" + t.isInterrupted());
        }
    }

    private static class ResourceAnalyzer {
        private static final OperatingSystemMXBean osStats = ManagementFactory.getOperatingSystemMXBean();
        private static final UnixOperatingSystemMXBean unixOsStats = osStats instanceof UnixOperatingSystemMXBean ? (UnixOperatingSystemMXBean)osStats : null;

        private ResourceAnalyzer() {
        }

        public long getThreadsCount(Phase phase) {
            Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
            if (phase == Phase.INITIAL) {
                for (Thread t : stackTraces.keySet()) {
                    initialThreadNames.add(t.getName());
                }
            }
            return stackTraces.size();
        }

        public long getOpenFileDescriptorCount() {
            if (unixOsStats == null) {
                return 0L;
            }
            return unixOsStats.getOpenFileDescriptorCount();
        }

        public long getMaxFileDescriptorCount() {
            if (unixOsStats == null) {
                return 0L;
            }
            return unixOsStats.getMaxFileDescriptorCount();
        }

        public long getConnectionCount() {
            return HConnectionTestingUtility.getConnectionCount();
        }
    }

    static enum Phase {
        INITIAL,
        INTERMEDIATE,
        END;

    }
}

