/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestFSTableDescriptorForceCreation {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Test
    public void testShouldCreateNewTableDescriptorIfForcefulCreationIsFalse() throws IOException {
        String name = "newTable2";
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), "newTable2");
        HTableDescriptor htd = new HTableDescriptor("newTable2");
        Assert.assertTrue((String)"Should create new table descriptor", (boolean)FSTableDescriptors.createTableDescriptor((FileSystem)fs, (Path)rootdir, (HTableDescriptor)htd, (boolean)false));
    }

    @Test
    public void testShouldNotCreateTheSameTableDescriptorIfForcefulCreationIsFalse() throws IOException {
        String name = "testAlreadyExists";
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), "testAlreadyExists");
        FSTableDescriptors htds = new FSTableDescriptors(fs, rootdir);
        HTableDescriptor htd = new HTableDescriptor("testAlreadyExists");
        htds.add(htd);
        Assert.assertFalse((String)"Should not create new table descriptor", (boolean)FSTableDescriptors.createTableDescriptor((FileSystem)fs, (Path)rootdir, (HTableDescriptor)htd, (boolean)false));
    }

    @Test
    public void testShouldAllowForcefulCreationOfAlreadyExistingTableDescriptor() throws Exception {
        String name = "createNewTableNew2";
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), "createNewTableNew2");
        HTableDescriptor htd = new HTableDescriptor("createNewTableNew2");
        FSTableDescriptors.createTableDescriptor((FileSystem)fs, (Path)rootdir, (HTableDescriptor)htd, (boolean)false);
        Assert.assertTrue((String)"Should create new table descriptor", (boolean)FSTableDescriptors.createTableDescriptor((FileSystem)fs, (Path)rootdir, (HTableDescriptor)htd, (boolean)true));
    }
}

