/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHServerInfo {
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Test
    public void testHashCodeAndEquals() {
        HServerAddress hsa1 = new HServerAddress("localhost", 1234);
        HServerInfo hsi1 = new HServerInfo(hsa1, 1L, 5678);
        HServerInfo hsi2 = new HServerInfo(hsa1, 1L, 5678);
        HServerInfo hsi3 = new HServerInfo(hsa1, 2L, 5678);
        HServerInfo hsi4 = new HServerInfo(hsa1, 1L, 5677);
        HServerAddress hsa2 = new HServerAddress("localhost", 1235);
        HServerInfo hsi5 = new HServerInfo(hsa2, 1L, 5678);
        Assert.assertEquals((long)hsi1.hashCode(), (long)hsi2.hashCode());
        Assert.assertTrue((boolean)hsi1.equals((Object)hsi2));
        Assert.assertNotSame((Object)hsi1.hashCode(), (Object)hsi3.hashCode());
        Assert.assertFalse((boolean)hsi1.equals((Object)hsi3));
        Assert.assertNotSame((Object)hsi1.hashCode(), (Object)hsi4.hashCode());
        Assert.assertFalse((boolean)hsi1.equals((Object)hsi4));
        Assert.assertNotSame((Object)hsi1.hashCode(), (Object)hsi5.hashCode());
        Assert.assertFalse((boolean)hsi1.equals((Object)hsi5));
    }

    @Test
    public void testHServerInfoHServerInfo() {
        HServerAddress hsa1 = new HServerAddress("localhost", 1234);
        HServerInfo hsi1 = new HServerInfo(hsa1, 1L, 5678);
        HServerInfo hsi2 = new HServerInfo(hsi1);
        Assert.assertEquals((Object)hsi1, (Object)hsi2);
    }

    @Test
    public void testGetServerAddress() {
        HServerAddress hsa1 = new HServerAddress("localhost", 1234);
        HServerInfo hsi1 = new HServerInfo(hsa1, 1L, 5678);
        Assert.assertEquals((Object)hsi1.getServerAddress(), (Object)hsa1);
    }

    @Test
    public void testToString() {
        HServerAddress hsa1 = new HServerAddress("localhost", 1234);
        HServerInfo hsi1 = new HServerInfo(hsa1, 1L, 5678);
        System.out.println(hsi1.toString());
    }

    @Test
    public void testReadFields() throws IOException {
        HServerAddress hsa1 = new HServerAddress("localhost", 1234);
        HServerInfo hsi1 = new HServerInfo(hsa1, 1L, 5678);
        HServerAddress hsa2 = new HServerAddress("localhost", 1235);
        HServerInfo hsi2 = new HServerInfo(hsa2, 1L, 5678);
        byte[] bytes = Writables.getBytes((Writable)hsi1);
        HServerInfo deserialized = (HServerInfo)Writables.getWritable((byte[])bytes, (Writable)new HServerInfo());
        Assert.assertEquals((Object)hsi1, (Object)deserialized);
        bytes = Writables.getBytes((Writable)hsi2);
        deserialized = (HServerInfo)Writables.getWritable((byte[])bytes, (Writable)new HServerInfo());
        Assert.assertNotSame((Object)hsa1, (Object)deserialized);
    }

    @Test
    public void testCompareTo() {
        HServerAddress hsa1 = new HServerAddress("localhost", 1234);
        HServerInfo hsi1 = new HServerInfo(hsa1, 1L, 5678);
        HServerAddress hsa2 = new HServerAddress("localhost", 1235);
        HServerInfo hsi2 = new HServerInfo(hsa2, 1L, 5678);
        Assert.assertTrue((hsi1.compareTo(hsi1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((hsi2.compareTo(hsi2) == 0 ? 1 : 0) != 0);
        int compare1 = hsi1.compareTo(hsi2);
        int compare2 = hsi2.compareTo(hsi1);
        Assert.assertTrue((boolean)(compare1 > 0 ? compare2 < 0 : compare2 > 0));
    }
}

