/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.EmptyWatcher;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestZooKeeper {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static HConnection persistentConnection;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        persistentConnection = HConnectionManager.createConnection((Configuration)TEST_UTIL.getConfiguration());
        TEST_UTIL.startMiniZKCluster();
        TEST_UTIL.getConfiguration().setBoolean("dfs.support.append", true);
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        persistentConnection.close();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.ensureSomeRegionServersAvailable(2);
    }

    private ZooKeeperWatcher getZooKeeperWatcher(HConnection c) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method getterZK = c.getClass().getMethod("getKeepAliveZooKeeperWatcher", new Class[0]);
        getterZK.setAccessible(true);
        return (ZooKeeperWatcher)getterZK.invoke((Object)c, new Object[0]);
    }

    public void testClientSessionExpired() throws Exception {
        this.LOG.info((Object)"testClientSessionExpired");
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        new HTable(c, HConstants.META_TABLE_NAME).close();
        HConnection connection = HConnectionManager.getConnection((Configuration)c);
        ZooKeeperWatcher connectionZK = connection.getZooKeeperWatcher();
        TEST_UTIL.expireSession(connectionZK, false);
        ZKUtil.dump((ZooKeeperWatcher)connectionZK);
        System.err.println("ZooKeeper should have timed out");
        this.LOG.info((Object)("state=" + connectionZK.getRecoverableZooKeeper().getState()));
        Assert.assertTrue((boolean)connectionZK.getRecoverableZooKeeper().getState().equals((Object)ZooKeeper.States.CLOSED));
        ZooKeeperWatcher newConnectionZK = connection.getZooKeeperWatcher();
        ZooKeeper.States state = newConnectionZK.getRecoverableZooKeeper().getState();
        this.LOG.info((Object)("state=" + state));
        Assert.assertTrue((state.equals((Object)ZooKeeper.States.CONNECTED) || state.equals((Object)ZooKeeper.States.CONNECTING) ? 1 : 0) != 0);
    }

    @Test
    public void testRegionServerSessionExpired() throws Exception {
        this.LOG.info((Object)"Starting testRegionServerSessionExpired");
        int metaIndex = TEST_UTIL.getMiniHBaseCluster().getServerWithMeta();
        TEST_UTIL.expireRegionServerSession(metaIndex);
        this.testSanity();
    }

    public void testMasterSessionExpired() throws Exception {
        this.LOG.info((Object)"Starting testMasterSessionExpired");
        TEST_UTIL.expireMasterSession();
        this.testSanity();
    }

    private void testSanity() throws Exception {
        String tableName = "test" + System.currentTimeMillis();
        HBaseAdmin admin = new HBaseAdmin(new Configuration(TEST_UTIL.getConfiguration()));
        this.testAdminSanity(admin, tableName);
        HTable table = new HTable(new Configuration(TEST_UTIL.getConfiguration()), tableName);
        this.testTableSanity(table, tableName);
    }

    private void testSanity(HConnection conn, ExecutorService pool) throws Exception {
        String tableName = "test" + System.currentTimeMillis();
        HBaseAdmin admin = new HBaseAdmin(persistentConnection);
        this.testAdminSanity(admin, tableName);
        HTable table = new HTable(Bytes.toBytes((String)tableName), persistentConnection, pool);
        this.testTableSanity(table, tableName);
    }

    private void testAdminSanity(HBaseAdmin admin, String tableName) throws Exception {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        HColumnDescriptor family = new HColumnDescriptor("fam");
        desc.addFamily(family);
        this.LOG.info((Object)("Creating table " + tableName));
        admin.createTable(desc);
    }

    private void testTableSanity(HTable table, String tableName) throws Exception {
        Put put = new Put(Bytes.toBytes((String)"testrow"));
        put.add(Bytes.toBytes((String)"fam"), Bytes.toBytes((String)"col"), Bytes.toBytes((String)"testdata"));
        this.LOG.info((Object)("Putting table " + tableName));
        table.put(put);
        table.close();
    }

    @Test
    public void testMultipleZK() {
        try {
            HTable localMeta = new HTable(new Configuration(TEST_UTIL.getConfiguration()), HConstants.META_TABLE_NAME);
            Configuration otherConf = new Configuration(TEST_UTIL.getConfiguration());
            otherConf.set("hbase.zookeeper.quorum", "127.0.0.1");
            HTable ipMeta = new HTable(otherConf, HConstants.META_TABLE_NAME);
            localMeta.exists(new Get(HConstants.LAST_ROW));
            ipMeta.exists(new Get(HConstants.LAST_ROW));
            Assert.assertFalse((HConnectionManager.getConnection((Configuration)localMeta.getConfiguration()).getZooKeeperWatcher() == HConnectionManager.getConnection((Configuration)otherConf).getZooKeeperWatcher() ? 1 : 0) != 0);
            Assert.assertFalse((boolean)HConnectionManager.getConnection((Configuration)localMeta.getConfiguration()).getZooKeeperWatcher().getQuorum().equals(HConnectionManager.getConnection((Configuration)otherConf).getZooKeeperWatcher().getQuorum()));
            localMeta.close();
            ipMeta.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testZNodeDeletes() throws Exception {
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(new Configuration(TEST_UTIL.getConfiguration()), TestZooKeeper.class.getName(), null);
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)"/l1/l2/l3/l4");
        try {
            ZKUtil.deleteNode((ZooKeeperWatcher)zkw, (String)"/l1/l2");
            Assert.fail((String)"We should not be able to delete if znode has childs");
        }
        catch (KeeperException ex) {
            Assert.assertNotNull((Object)ZKUtil.getDataNoWatch((ZooKeeperWatcher)zkw, (String)"/l1/l2/l3/l4", null));
        }
        ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)"/l1/l2");
        Assert.assertNull((Object)ZKUtil.getDataNoWatch((ZooKeeperWatcher)zkw, (String)"/l1/l2/l3/l4", null));
        ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)"/l1/l2");
        ZKUtil.deleteNode((ZooKeeperWatcher)zkw, (String)"/l1");
        Assert.assertNull((Object)ZKUtil.getDataNoWatch((ZooKeeperWatcher)zkw, (String)"/l1/l2", null));
    }

    @Test
    public void testClusterKey() throws Exception {
        this.testKey("server", "2181", "hbase");
        this.testKey("server1,server2,server3", "2181", "hbase");
        try {
            ZKUtil.transformClusterKey((String)"2181:hbase");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testPersistentConnection() throws Exception {
        ThreadPoolExecutor pool = new ThreadPoolExecutor(1, 10, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.testSanity(persistentConnection, pool);
    }

    private void testKey(String ensemble, String port, String znode) throws IOException {
        Configuration conf = new Configuration();
        String key = ensemble + ":" + port + ":" + znode;
        String[] parts = ZKUtil.transformClusterKey((String)key);
        Assert.assertEquals((Object)ensemble, (Object)parts[0]);
        Assert.assertEquals((Object)port, (Object)parts[1]);
        Assert.assertEquals((Object)znode, (Object)parts[2]);
        ZKUtil.applyClusterKeyToConf((Configuration)conf, (String)key);
        Assert.assertEquals((Object)parts[0], (Object)conf.get("hbase.zookeeper.quorum"));
        Assert.assertEquals((Object)parts[1], (Object)conf.get("hbase.zookeeper.property.clientPort"));
        Assert.assertEquals((Object)parts[2], (Object)conf.get("zookeeper.znode.parent"));
        String reconstructedKey = ZKUtil.getZooKeeperClusterKey((Configuration)conf);
        Assert.assertEquals((Object)key, (Object)reconstructedKey);
    }

    @Test
    public void testCreateSilentIsReallySilent() throws InterruptedException, KeeperException, IOException {
        Configuration c = TEST_UTIL.getConfiguration();
        String aclZnode = "/aclRoot";
        String quorumServers = ZKConfig.getZKQuorumServersString((Configuration)c);
        int sessionTimeout = 5000;
        ZooKeeper zk = new ZooKeeper(quorumServers, sessionTimeout, (Watcher)EmptyWatcher.instance);
        zk.addAuthInfo("digest", "hbase:rox".getBytes());
        ZooKeeperWatcher zk2 = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), "testMasterAddressManagerFromZK", null);
        block10: while (true) {
            try {
                zk.setACL("/", (List)ZooDefs.Ids.CREATOR_ALL_ACL, -1);
            }
            catch (KeeperException e) {
                switch (e.code()) {
                    case CONNECTIONLOSS: 
                    case SESSIONEXPIRED: 
                    case OPERATIONTIMEOUT: {
                        this.LOG.warn((Object)("Possibly transient ZooKeeper exception: " + (Object)((Object)e)));
                        Threads.sleep((long)100L);
                        continue block10;
                    }
                }
                throw e;
            }
            break;
        }
        block11: while (true) {
            try {
                zk.create(aclZnode, null, (List)ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            }
            catch (KeeperException e) {
                switch (e.code()) {
                    case CONNECTIONLOSS: 
                    case SESSIONEXPIRED: 
                    case OPERATIONTIMEOUT: {
                        this.LOG.warn((Object)("Possibly transient ZooKeeper exception: " + (Object)((Object)e)));
                        Threads.sleep((long)100L);
                        continue block11;
                    }
                }
                throw e;
            }
            break;
        }
        zk.close();
        ZKUtil.createAndFailSilent((ZooKeeperWatcher)zk2, (String)aclZnode);
    }

    @Test
    public void testGetChildDataAndWatchForNewChildrenShouldNotThrowNPE() throws Exception {
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), "testGetChildDataAndWatchForNewChildrenShouldNotThrowNPE", null);
        ZKUtil.getChildDataAndWatchForNewChildren((ZooKeeperWatcher)zkw, (String)"/wrongNode");
    }

    @Test(timeout=20000L)
    public void testMasterZKSessionRecoveryFailure() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster m = cluster.getMaster();
        m.abort("Test recovery from zk session expired", (Throwable)new KeeperException.SessionExpiredException());
        Assert.assertFalse((boolean)m.isStopped());
        this.testSanity();
    }
}

