/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.avro;

import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.avro.AvroServer;
import org.apache.hadoop.hbase.avro.generated.AColumn;
import org.apache.hadoop.hbase.avro.generated.AColumnValue;
import org.apache.hadoop.hbase.avro.generated.AFamilyDescriptor;
import org.apache.hadoop.hbase.avro.generated.AGet;
import org.apache.hadoop.hbase.avro.generated.APut;
import org.apache.hadoop.hbase.avro.generated.ATableDescriptor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestAvroServer {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static ByteBuffer tableAname = ByteBuffer.wrap(Bytes.toBytes((String)"tableA"));
    private static ByteBuffer tableBname = ByteBuffer.wrap(Bytes.toBytes((String)"tableB"));
    private static ByteBuffer familyAname = ByteBuffer.wrap(Bytes.toBytes((String)"FamilyA"));
    private static ByteBuffer qualifierAname = ByteBuffer.wrap(Bytes.toBytes((String)"QualifierA"));
    private static ByteBuffer rowAname = ByteBuffer.wrap(Bytes.toBytes((String)"RowA"));
    private static ByteBuffer valueA = ByteBuffer.wrap(Bytes.toBytes((String)"ValueA"));
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test(timeout=300000L)
    public void testTableAdminAndMetadata() throws Exception {
        AvroServer.HBaseImpl impl = new AvroServer.HBaseImpl(TEST_UTIL.getConfiguration());
        Assert.assertEquals((long)impl.listTables().size(), (long)0L);
        ATableDescriptor tableA = new ATableDescriptor();
        tableA.name = tableAname;
        impl.createTable(tableA);
        Assert.assertEquals((long)impl.listTables().size(), (long)1L);
        Assert.assertTrue((boolean)impl.isTableEnabled(tableAname));
        Assert.assertTrue((boolean)impl.tableExists(tableAname));
        ATableDescriptor tableB = new ATableDescriptor();
        tableB.name = tableBname;
        impl.createTable(tableB);
        Assert.assertEquals((long)impl.listTables().size(), (long)2L);
        impl.disableTable(tableBname);
        Assert.assertFalse((boolean)impl.isTableEnabled(tableBname));
        impl.deleteTable(tableBname);
        Assert.assertEquals((long)impl.listTables().size(), (long)1L);
        impl.disableTable(tableAname);
        Assert.assertFalse((boolean)impl.isTableEnabled(tableAname));
        long oldMaxFileSize = impl.describeTable((ByteBuffer)TestAvroServer.tableAname).maxFileSize;
        tableA.maxFileSize = 123456L;
        impl.modifyTable(tableAname, tableA);
        while (impl.describeTable((ByteBuffer)TestAvroServer.tableAname).maxFileSize == oldMaxFileSize) {
            Threads.sleep((long)100L);
        }
        Assert.assertTrue((impl.describeTable((ByteBuffer)TestAvroServer.tableAname).maxFileSize == 123456L ? 1 : 0) != 0);
        Assert.assertEquals((long)123456L, (long)impl.describeTable((ByteBuffer)TestAvroServer.tableAname).maxFileSize);
        impl.deleteTable(tableAname);
    }

    @Test
    public void testFamilyAdminAndMetadata() throws Exception {
        AvroServer.HBaseImpl impl = new AvroServer.HBaseImpl(TEST_UTIL.getConfiguration());
        ATableDescriptor tableA = new ATableDescriptor();
        tableA.name = tableAname;
        AFamilyDescriptor familyA = new AFamilyDescriptor();
        familyA.name = familyAname;
        Schema familyArraySchema = Schema.createArray((Schema)AFamilyDescriptor.SCHEMA$);
        GenericData.Array families = new GenericData.Array(1, familyArraySchema);
        families.add((Object)familyA);
        tableA.families = families;
        impl.createTable(tableA);
        Assert.assertEquals((long)impl.describeTable((ByteBuffer)TestAvroServer.tableAname).families.size(), (long)1L);
        impl.disableTable(tableAname);
        Assert.assertFalse((boolean)impl.isTableEnabled(tableAname));
        familyA.maxVersions = 123456;
        impl.modifyFamily(tableAname, familyAname, familyA);
        Assert.assertEquals((long)impl.describeFamily((ByteBuffer)TestAvroServer.tableAname, (ByteBuffer)TestAvroServer.familyAname).maxVersions.intValue(), (long)123456L);
        impl.deleteFamily(tableAname, familyAname);
        Assert.assertEquals((long)impl.describeTable((ByteBuffer)TestAvroServer.tableAname).families.size(), (long)0L);
        impl.deleteTable(tableAname);
    }

    @Test
    public void testDML() throws Exception {
        AvroServer.HBaseImpl impl = new AvroServer.HBaseImpl(TEST_UTIL.getConfiguration());
        ATableDescriptor tableA = new ATableDescriptor();
        tableA.name = tableAname;
        AFamilyDescriptor familyA = new AFamilyDescriptor();
        familyA.name = familyAname;
        Schema familyArraySchema = Schema.createArray((Schema)AFamilyDescriptor.SCHEMA$);
        GenericData.Array families = new GenericData.Array(1, familyArraySchema);
        families.add((Object)familyA);
        tableA.families = families;
        impl.createTable(tableA);
        Assert.assertEquals((long)impl.describeTable((ByteBuffer)TestAvroServer.tableAname).families.size(), (long)1L);
        AGet getA = new AGet();
        getA.row = rowAname;
        Schema columnsSchema = Schema.createArray((Schema)AColumn.SCHEMA$);
        GenericData.Array columns = new GenericData.Array(1, columnsSchema);
        AColumn column = new AColumn();
        column.family = familyAname;
        column.qualifier = qualifierAname;
        columns.add((Object)column);
        getA.columns = columns;
        Assert.assertFalse((boolean)impl.exists(tableAname, getA));
        APut putA = new APut();
        putA.row = rowAname;
        Schema columnValuesSchema = Schema.createArray((Schema)AColumnValue.SCHEMA$);
        GenericData.Array columnValues = new GenericData.Array(1, columnValuesSchema);
        AColumnValue acv = new AColumnValue();
        acv.family = familyAname;
        acv.qualifier = qualifierAname;
        acv.value = valueA;
        columnValues.add((Object)acv);
        putA.columnValues = columnValues;
        impl.put(tableAname, putA);
        Assert.assertTrue((boolean)impl.exists(tableAname, getA));
        Assert.assertEquals((long)impl.get((ByteBuffer)TestAvroServer.tableAname, (AGet)getA).entries.size(), (long)1L);
        impl.disableTable(tableAname);
        impl.deleteTable(tableAname);
    }
}

