/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.catalog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.Writable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={MediumTests.class})
public class TestMetaReaderEditorNoCluster {
    private static final Log LOG = LogFactory.getLog(TestMetaReaderEditorNoCluster.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final Abortable ABORTABLE = new Abortable(){
        boolean aborted = false;

        public void abort(String why, Throwable e) {
            LOG.info((Object)why, e);
            this.aborted = true;
            throw new RuntimeException(e);
        }

        public boolean isAborted() {
            return this.aborted;
        }
    };
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Before
    public void before() throws Exception {
        UTIL.startMiniZKCluster();
    }

    @After
    public void after() throws IOException {
        UTIL.shutdownMiniZKCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRideOverServerNotRunning() throws IOException, InterruptedException {
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(UTIL.getConfiguration(), this.getClass().getSimpleName(), ABORTABLE, true);
        ServerName sn = new ServerName("example.com", 1234, System.currentTimeMillis());
        HConnection connection = null;
        CatalogTracker ct = null;
        try {
            HRegionInterface implementation = (HRegionInterface)Mockito.mock(HRegionInterface.class);
            long scannerid = 123L;
            Mockito.when((Object)implementation.openScanner((byte[])Mockito.any(), (Scan)Mockito.any())).thenThrow(new Throwable[]{new IOException("Server not running (1 of 3)")}).thenThrow(new Throwable[]{new IOException("Server not running (2 of 3)")}).thenThrow(new Throwable[]{new IOException("Server not running (3 of 3)")}).thenReturn((Object)123L);
            ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
            byte[] rowToVerify = Bytes.toBytes((String)"rowToVerify");
            kvs.add(new KeyValue(rowToVerify, HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)HRegionInfo.FIRST_META_REGIONINFO)));
            kvs.add(new KeyValue(rowToVerify, HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes((String)sn.getHostAndPort())));
            kvs.add(new KeyValue(rowToVerify, HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER, Bytes.toBytes((long)sn.getStartcode())));
            Result[] result = new Result[]{new Result(kvs)};
            Mockito.when((Object)implementation.next(Mockito.anyLong(), Mockito.anyInt())).thenReturn((Object)result).thenReturn(null);
            connection = HConnectionTestingUtility.getSpiedConnection(UTIL.getConfiguration());
            HRegionLocation anyLocation = new HRegionLocation(HRegionInfo.FIRST_META_REGIONINFO, sn.getHostname(), sn.getPort());
            ((HConnection)Mockito.doReturn((Object)anyLocation).when((Object)connection)).locateRegion((byte[])Mockito.any(), (byte[])Mockito.any());
            ((HConnection)Mockito.doReturn((Object)anyLocation).when((Object)connection)).getRegionLocation((byte[])Mockito.any(), (byte[])Mockito.any(), Mockito.anyBoolean());
            ((HConnection)Mockito.doReturn((Object)implementation).when((Object)connection)).getHRegionConnection(Mockito.anyString(), Mockito.anyInt());
            ct = new CatalogTracker(zkw, null, connection, ABORTABLE);
            ct.start();
            NavigableMap hris = MetaReader.getServerUserRegions((CatalogTracker)ct, (ServerName)sn);
            Assert.assertTrue((hris.size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((HRegionInfo)hris.firstEntry().getKey()).equals((Object)HRegionInfo.FIRST_META_REGIONINFO));
            Assert.assertTrue((boolean)Bytes.equals((byte[])rowToVerify, (byte[])((Result)hris.firstEntry().getValue()).getRow()));
            ((HRegionInterface)Mockito.verify((Object)implementation, (VerificationMode)Mockito.times((int)4))).openScanner((byte[])Mockito.any(), (Scan)Mockito.any());
        }
        finally {
            if (ct != null) {
                ct.stop();
            }
            HConnectionManager.deleteConnection((Configuration)UTIL.getConfiguration());
            zkw.close();
        }
    }
}

