/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.mockito.Mockito;

public class HConnectionTestingUtility {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HConnection getMockedConnection(Configuration conf) throws ZooKeeperConnectionException {
        HConnectionManager.HConnectionKey connectionKey = new HConnectionManager.HConnectionKey(conf);
        Map map = HConnectionManager.HBASE_INSTANCES;
        synchronized (map) {
            HConnectionManager.HConnectionImplementation connection = (HConnectionManager.HConnectionImplementation)HConnectionManager.HBASE_INSTANCES.get(connectionKey);
            if (connection == null) {
                connection = (HConnectionManager.HConnectionImplementation)Mockito.mock(HConnectionManager.HConnectionImplementation.class);
                Mockito.when((Object)connection.getConfiguration()).thenReturn((Object)conf);
                HConnectionManager.HBASE_INSTANCES.put(connectionKey, connection);
            }
            return connection;
        }
    }

    public static HConnection getMockedConnectionAndDecorate(Configuration conf, HRegionInterface implementation, ServerName sn, HRegionInfo hri) throws IOException {
        HConnection c = HConnectionTestingUtility.getMockedConnection(conf);
        ((HConnection)Mockito.doNothing().when((Object)c)).close();
        HRegionLocation loc = new HRegionLocation(hri, sn.getHostname(), sn.getPort());
        Mockito.when((Object)c.getRegionLocation((byte[])Mockito.any(), (byte[])Mockito.any(), Mockito.anyBoolean())).thenReturn((Object)loc);
        Mockito.when((Object)c.locateRegion((byte[])Mockito.any(), (byte[])Mockito.any())).thenReturn((Object)loc);
        if (implementation != null) {
            Mockito.when((Object)c.getHRegionConnection(Mockito.anyString(), Mockito.anyInt())).thenReturn((Object)implementation);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HConnection getSpiedConnection(Configuration conf) throws ZooKeeperConnectionException {
        HConnectionManager.HConnectionKey connectionKey = new HConnectionManager.HConnectionKey(conf);
        Map map = HConnectionManager.HBASE_INSTANCES;
        synchronized (map) {
            HConnectionManager.HConnectionImplementation connection = (HConnectionManager.HConnectionImplementation)HConnectionManager.HBASE_INSTANCES.get(connectionKey);
            if (connection == null) {
                connection = (HConnectionManager.HConnectionImplementation)Mockito.spy((Object)new HConnectionManager.HConnectionImplementation(conf, true));
                HConnectionManager.HBASE_INSTANCES.put(connectionKey, connection);
            }
            return connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getConnectionCount() {
        Map map = HConnectionManager.HBASE_INSTANCES;
        synchronized (map) {
            return HConnectionManager.HBASE_INSTANCES.size();
        }
    }
}

