/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.wal.HLogUtilsForTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKTableReadOnly;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestAdmin {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private HBaseAdmin admin;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.online.schema.update.enable", true);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.admin = TEST_UTIL.getHBaseAdmin();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testSplitFlushCompactUnknownTable() throws InterruptedException {
        String unknowntable = "fubar";
        IOException exception = null;
        try {
            this.admin.compact("fubar");
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.flush("fubar");
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.split("fubar");
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteEditUnknownColumnFamilyAndOrTable() throws IOException {
        String nonexistent = "nonexistent";
        HColumnDescriptor nonexistentHcd = new HColumnDescriptor("nonexistent");
        IOException exception = null;
        try {
            this.admin.addColumn("nonexistent", nonexistentHcd);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.deleteTable("nonexistent");
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.deleteColumn("nonexistent", "nonexistent");
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.disableTable("nonexistent");
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.enableTable("nonexistent");
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.modifyColumn("nonexistent", nonexistentHcd);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            HTableDescriptor htd = new HTableDescriptor("nonexistent");
            this.admin.modifyTable(htd.getName(), htd);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        String tableName = "t";
        HTableDescriptor htd = new HTableDescriptor("t");
        htd.addFamily(new HColumnDescriptor("cf"));
        this.admin.createTable(htd);
        try {
            exception = null;
            try {
                this.admin.deleteColumn(htd.getName(), nonexistentHcd.getName());
            }
            catch (IOException e) {
                exception = e;
            }
            Assert.assertTrue((boolean)(exception instanceof InvalidFamilyOperationException));
            exception = null;
            try {
                this.admin.modifyColumn(htd.getName(), nonexistentHcd);
            }
            catch (IOException e) {
                exception = e;
            }
            Assert.assertTrue((boolean)(exception instanceof InvalidFamilyOperationException));
        }
        finally {
            this.admin.disableTable("t");
            this.admin.deleteTable("t");
        }
    }

    @Test
    public void testDisableAndEnableTable() throws IOException {
        byte[] row = Bytes.toBytes((String)"row");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        byte[] value = Bytes.toBytes((String)"value");
        byte[] table = Bytes.toBytes((String)"testDisableAndEnableTable");
        HTable ht = TEST_UTIL.createTable(table, HConstants.CATALOG_FAMILY);
        Put put = new Put(row);
        put.add(HConstants.CATALOG_FAMILY, qualifier, value);
        ht.put(put);
        Get get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        ht.get(get);
        this.admin.disableTable(table);
        Assert.assertTrue((String)"Table must be disabled.", (boolean)TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getZKTable().isDisabledTable(Bytes.toString((byte[])table)));
        get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        boolean ok = false;
        try {
            ht.get(get);
        }
        catch (DoNotRetryIOException e) {
            ok = true;
        }
        Assert.assertTrue((boolean)ok);
        this.admin.enableTable(table);
        Assert.assertTrue((String)"Table must be enabled.", (boolean)TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getZKTable().isEnabledTable(Bytes.toString((byte[])table)));
        try {
            ht.get(get);
        }
        catch (RetriesExhaustedException e) {
            ok = false;
        }
        Assert.assertTrue((boolean)ok);
        ht.close();
    }

    @Test
    public void testDisableAndEnableTables() throws IOException {
        byte[] row = Bytes.toBytes((String)"row");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        byte[] value = Bytes.toBytes((String)"value");
        byte[] table1 = Bytes.toBytes((String)"testDisableAndEnableTable1");
        byte[] table2 = Bytes.toBytes((String)"testDisableAndEnableTable2");
        HTable ht1 = TEST_UTIL.createTable(table1, HConstants.CATALOG_FAMILY);
        HTable ht2 = TEST_UTIL.createTable(table2, HConstants.CATALOG_FAMILY);
        Put put = new Put(row);
        put.add(HConstants.CATALOG_FAMILY, qualifier, value);
        ht1.put(put);
        ht2.put(put);
        Get get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        ht1.get(get);
        ht2.get(get);
        this.admin.disableTables("testDisableAndEnableTable.*");
        get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        boolean ok = false;
        try {
            ht1.get(get);
            ht2.get(get);
        }
        catch (DoNotRetryIOException e) {
            ok = true;
        }
        Assert.assertTrue((boolean)ok);
        this.admin.enableTables("testDisableAndEnableTable.*");
        try {
            ht1.get(get);
        }
        catch (IOException e) {
            ok = false;
        }
        try {
            ht2.get(get);
        }
        catch (IOException e) {
            ok = false;
        }
        Assert.assertTrue((boolean)ok);
        ht1.close();
        ht2.close();
    }

    @Test
    public void testCreateTable() throws IOException {
        HTableDescriptor[] tables = this.admin.listTables();
        int numTables = tables.length;
        TEST_UTIL.createTable(Bytes.toBytes((String)"testCreateTable"), HConstants.CATALOG_FAMILY).close();
        tables = this.admin.listTables();
        Assert.assertEquals((long)(numTables + 1), (long)tables.length);
        Assert.assertTrue((String)"Table must be enabled.", (boolean)TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getZKTable().isEnabledTable("testCreateTable"));
    }

    @Test
    public void testGetTableDescriptor() throws IOException {
        HColumnDescriptor fam1 = new HColumnDescriptor("fam1");
        HColumnDescriptor fam2 = new HColumnDescriptor("fam2");
        HColumnDescriptor fam3 = new HColumnDescriptor("fam3");
        HTableDescriptor htd = new HTableDescriptor("myTestTable");
        htd.addFamily(fam1);
        htd.addFamily(fam2);
        htd.addFamily(fam3);
        this.admin.createTable(htd);
        HTable table = new HTable(TEST_UTIL.getConfiguration(), "myTestTable");
        HTableDescriptor confirmedHtd = table.getTableDescriptor();
        Assert.assertEquals((long)htd.compareTo(confirmedHtd), (long)0L);
        table.close();
    }

    @Test
    public void testHColumnValidName() {
        boolean exceptionThrown = false;
        try {
            HColumnDescriptor fam1 = new HColumnDescriptor("\\test\\abc");
        }
        catch (IllegalArgumentException iae) {
            exceptionThrown = true;
            Assert.assertTrue((boolean)exceptionThrown);
        }
    }

    @Test
    public void testOnlineChangeTableSchema() throws IOException, InterruptedException {
        byte[] tableName = Bytes.toBytes((String)"changeTableSchemaOnline");
        TEST_UTIL.getMiniHBaseCluster().getMaster().getConfiguration().setBoolean("hbase.online.schema.update.enable", true);
        HTableDescriptor[] tables = this.admin.listTables();
        int numTables = tables.length;
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY).close();
        tables = this.admin.listTables();
        Assert.assertEquals((long)(numTables + 1), (long)tables.length);
        HTableDescriptor htd = this.admin.getTableDescriptor(tableName);
        HTableDescriptor copy = new HTableDescriptor(htd);
        Assert.assertTrue((boolean)htd.equals((Object)copy));
        long newFlushSize = htd.getMemStoreFlushSize() / 2L;
        if (newFlushSize <= 0L) {
            newFlushSize = 0x4000000L;
        }
        copy.setMemStoreFlushSize(newFlushSize);
        String key = "anyoldkey";
        Assert.assertTrue((htd.getValue("anyoldkey") == null ? 1 : 0) != 0);
        copy.setValue("anyoldkey", "anyoldkey");
        boolean expectedException = false;
        try {
            this.modifyTable(tableName, copy);
        }
        catch (TableNotDisabledException re) {
            expectedException = true;
        }
        Assert.assertFalse((boolean)expectedException);
        HTableDescriptor modifiedHtd = this.admin.getTableDescriptor(tableName);
        Assert.assertFalse((boolean)htd.equals((Object)modifiedHtd));
        Assert.assertTrue((boolean)copy.equals((Object)modifiedHtd));
        Assert.assertEquals((long)newFlushSize, (long)modifiedHtd.getMemStoreFlushSize());
        Assert.assertEquals((Object)"anyoldkey", (Object)modifiedHtd.getValue("anyoldkey"));
        htd = this.admin.getTableDescriptor(tableName);
        int countOfFamilies = modifiedHtd.getFamilies().size();
        Assert.assertTrue((countOfFamilies > 0 ? 1 : 0) != 0);
        HColumnDescriptor hcd = (HColumnDescriptor)modifiedHtd.getFamilies().iterator().next();
        int maxversions = hcd.getMaxVersions();
        int newMaxVersions = maxversions + 1;
        hcd.setMaxVersions(newMaxVersions);
        byte[] hcdName = hcd.getName();
        expectedException = false;
        try {
            this.admin.modifyColumn(tableName, hcd);
        }
        catch (TableNotDisabledException re) {
            expectedException = true;
        }
        Assert.assertFalse((boolean)expectedException);
        modifiedHtd = this.admin.getTableDescriptor(tableName);
        HColumnDescriptor modifiedHcd = modifiedHtd.getFamily(hcdName);
        Assert.assertEquals((long)newMaxVersions, (long)modifiedHcd.getMaxVersions());
        Assert.assertFalse((boolean)this.admin.isTableDisabled(tableName));
        String xtracolName = "xtracol";
        htd = this.admin.getTableDescriptor(tableName);
        HColumnDescriptor xtracol = new HColumnDescriptor("xtracol");
        xtracol.setValue("xtracol", "xtracol");
        expectedException = false;
        try {
            this.admin.addColumn(tableName, xtracol);
        }
        catch (TableNotDisabledException re) {
            expectedException = true;
        }
        Assert.assertFalse((boolean)expectedException);
        modifiedHtd = this.admin.getTableDescriptor(tableName);
        hcd = modifiedHtd.getFamily(xtracol.getName());
        Assert.assertTrue((hcd != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)hcd.getValue("xtracol").equals("xtracol"));
        this.admin.deleteColumn(tableName, xtracol.getName());
        modifiedHtd = this.admin.getTableDescriptor(tableName);
        hcd = modifiedHtd.getFamily(xtracol.getName());
        Assert.assertTrue((hcd == null ? 1 : 0) != 0);
        this.admin.disableTable(tableName);
        this.admin.deleteTable(tableName);
        this.admin.listTables();
        Assert.assertFalse((boolean)this.admin.tableExists(tableName));
    }

    @Test
    public void testShouldFailOnlineSchemaUpdateIfOnlineSchemaIsNotEnabled() throws Exception {
        byte[] tableName = Bytes.toBytes((String)"changeTableSchemaOnlineFailure");
        TEST_UTIL.getMiniHBaseCluster().getMaster().getConfiguration().setBoolean("hbase.online.schema.update.enable", false);
        HTableDescriptor[] tables = this.admin.listTables();
        int numTables = tables.length;
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY).close();
        tables = this.admin.listTables();
        Assert.assertEquals((long)(numTables + 1), (long)tables.length);
        HTableDescriptor htd = this.admin.getTableDescriptor(tableName);
        HTableDescriptor copy = new HTableDescriptor(htd);
        Assert.assertTrue((boolean)htd.equals((Object)copy));
        long newFlushSize = htd.getMemStoreFlushSize() / 2L;
        if (newFlushSize <= 0L) {
            newFlushSize = 0x4000000L;
        }
        copy.setMemStoreFlushSize(newFlushSize);
        String key = "anyoldkey";
        Assert.assertTrue((htd.getValue("anyoldkey") == null ? 1 : 0) != 0);
        copy.setValue("anyoldkey", "anyoldkey");
        boolean expectedException = false;
        try {
            this.modifyTable(tableName, copy);
        }
        catch (TableNotDisabledException re) {
            expectedException = true;
        }
        Assert.assertTrue((String)"Online schema update should not happen.", (boolean)expectedException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyTable(byte[] tableName, HTableDescriptor htd) throws IOException {
        HMaster services = TEST_UTIL.getMiniHBaseCluster().getMaster();
        ExecutorService executor = services.getExecutorService();
        AtomicBoolean done = new AtomicBoolean(false);
        executor.registerListener(EventHandler.EventType.C_M_MODIFY_TABLE, (EventHandler.EventHandlerListener)new DoneListener(done));
        this.admin.modifyTable(tableName, htd);
        while (!done.get()) {
            AtomicBoolean atomicBoolean = done;
            synchronized (atomicBoolean) {
                try {
                    done.wait(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        executor.unregisterListener(EventHandler.EventType.C_M_MODIFY_TABLE);
    }

    protected void verifyRoundRobinDistribution(HTable ht, int expectedRegions) throws IOException {
        int numRS = ht.getConnection().getCurrentNrHRS();
        Map regions = ht.getRegionsInfo();
        HashMap server2Regions = new HashMap();
        for (Map.Entry entry : regions.entrySet()) {
            HServerAddress server = (HServerAddress)entry.getValue();
            ArrayList regs = (ArrayList)server2Regions.get(server);
            if (regs == null) {
                regs = new ArrayList();
                server2Regions.put(server, regs);
            }
            regs.add(entry.getKey());
        }
        float average = (float)expectedRegions / (float)numRS;
        int min = (int)Math.floor(average);
        int max = (int)Math.ceil(average);
        for (List regionList : server2Regions.values()) {
            Assert.assertTrue((regionList.size() == min || regionList.size() == max ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCreateTableWithRegions() throws IOException, InterruptedException {
        byte[] tableName = Bytes.toBytes((String)"testCreateTableWithRegions");
        byte[][] splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {4, 4, 4}, {5, 5, 5}, {6, 6, 6}, {7, 7, 7}, {8, 8, 8}, {9, 9, 9}};
        int expectedRegions = splitKeys.length + 1;
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc, (byte[][])splitKeys);
        HTable ht = new HTable(TEST_UTIL.getConfiguration(), tableName);
        Map regions = ht.getRegionsInfo();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions " + "but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        System.err.println("Found " + regions.size() + " regions");
        Iterator hris = regions.keySet().iterator();
        HRegionInfo hri = (HRegionInfo)hris.next();
        Assert.assertTrue((hri.getStartKey() == null || hri.getStartKey().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[0]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[0]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[1]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[1]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[2]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[2]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[3]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[3]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[4]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[4]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[5]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[5]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[6]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[6]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[7]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[7]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[8]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[8]));
        Assert.assertTrue((hri.getEndKey() == null || hri.getEndKey().length == 0 ? 1 : 0) != 0);
        this.verifyRoundRobinDistribution(ht, expectedRegions);
        ht.close();
        byte[] startKey = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        byte[] endKey = new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
        expectedRegions = 10;
        byte[] TABLE_2 = Bytes.add((byte[])tableName, (byte[])Bytes.toBytes((String)"_2"));
        desc = new HTableDescriptor(TABLE_2);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        this.admin.createTable(desc, startKey, endKey, expectedRegions);
        HTable ht2 = new HTable(TEST_UTIL.getConfiguration(), TABLE_2);
        regions = ht2.getRegionsInfo();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions " + "but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        System.err.println("Found " + regions.size() + " regions");
        hris = regions.keySet().iterator();
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((hri.getStartKey() == null || hri.getStartKey().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9}));
        Assert.assertTrue((hri.getEndKey() == null || hri.getEndKey().length == 0 ? 1 : 0) != 0);
        this.verifyRoundRobinDistribution(ht2, expectedRegions);
        ht2.close();
        startKey = new byte[]{0, 0, 0, 0, 0, 0};
        endKey = new byte[]{1, 0, 0, 0, 0, 0};
        expectedRegions = 5;
        byte[] TABLE_3 = Bytes.add((byte[])tableName, (byte[])Bytes.toBytes((String)"_3"));
        desc = new HTableDescriptor(TABLE_3);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        this.admin.createTable(desc, startKey, endKey, expectedRegions);
        HTable ht3 = new HTable(TEST_UTIL.getConfiguration(), TABLE_3);
        regions = ht3.getRegionsInfo();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions " + "but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        System.err.println("Found " + regions.size() + " regions");
        this.verifyRoundRobinDistribution(ht3, expectedRegions);
        ht3.close();
        splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {2, 2, 2}};
        byte[] TABLE_4 = Bytes.add((byte[])tableName, (byte[])Bytes.toBytes((String)"_4"));
        desc = new HTableDescriptor(TABLE_4);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        HBaseAdmin ladmin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        try {
            ladmin.createTable(desc, (byte[][])splitKeys);
            Assert.assertTrue((String)"Should not be able to create this table because of duplicate split keys", (boolean)false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        ladmin.close();
    }

    @Test
    public void testCreateTableWithOnlyEmptyStartRow() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testCreateTableWithOnlyEmptyStartRow");
        byte[][] splitKeys = new byte[][]{HConstants.EMPTY_BYTE_ARRAY};
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor("col"));
        try {
            this.admin.createTable(desc, (byte[][])splitKeys);
            Assert.fail((String)"Test case should fail as empty split key is passed.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    @Test
    public void testCreateTableWithEmptyRowInTheSplitKeys() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testCreateTableWithEmptyRowInTheSplitKeys");
        byte[][] splitKeys = new byte[][]{"region1".getBytes(), HConstants.EMPTY_BYTE_ARRAY, "region2".getBytes()};
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor("col"));
        try {
            this.admin.createTable(desc, (byte[][])splitKeys);
            Assert.fail((String)"Test case should fail as empty split key is passed.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    @Test
    public void testTableExist() throws IOException {
        byte[] table = Bytes.toBytes((String)"testTableExist");
        boolean exist = false;
        exist = this.admin.tableExists(table);
        Assert.assertEquals((Object)false, (Object)exist);
        TEST_UTIL.createTable(table, HConstants.CATALOG_FAMILY);
        exist = this.admin.tableExists(table);
        Assert.assertEquals((Object)true, (Object)exist);
    }

    @Test
    public void testForceSplit() throws Exception {
        byte[][] familyNames = new byte[][]{Bytes.toBytes((String)"cf")};
        int[] rowCounts = new int[]{6000};
        int numVersions = 3;
        int blockSize = 256;
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize);
        byte[] splitKey = Bytes.toBytes((int)3500);
        this.splitTest(splitKey, familyNames, rowCounts, numVersions, blockSize);
    }

    @Test
    public void testEnableTableRoundRobinAssignment() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testEnableTableAssignment");
        byte[][] splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {4, 4, 4}, {5, 5, 5}, {6, 6, 6}, {7, 7, 7}, {8, 8, 8}, {9, 9, 9}};
        int expectedRegions = splitKeys.length + 1;
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc, (byte[][])splitKeys);
        HTable ht = new HTable(TEST_UTIL.getConfiguration(), tableName);
        Map regions = ht.getRegionsInfo();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions " + "but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        this.admin.disableTable(tableName);
        this.admin.enableTable(tableName);
        HTable metaTable = new HTable(TEST_UTIL.getConfiguration(), HConstants.META_TABLE_NAME);
        List regionInfos = this.admin.getTableRegions(tableName);
        HashMap<String, Integer> serverMap = new HashMap<String, Integer>();
        int j = regionInfos.size();
        for (int i = 0; i < j; ++i) {
            HRegionInfo hri = (HRegionInfo)regionInfos.get(i);
            Get get = new Get(hri.getRegionName());
            Result result = metaTable.get(get);
            String server = Bytes.toString((byte[])result.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER));
            Integer regioncount = (Integer)serverMap.get(server);
            if (regioncount == null) {
                regioncount = 0;
            }
            Integer n = regioncount;
            Integer n2 = regioncount = Integer.valueOf(regioncount + 1);
            serverMap.put(server, regioncount);
        }
        ArrayList entryList = new ArrayList(serverMap.entrySet());
        Collections.sort(entryList, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> oa, Map.Entry<String, Integer> ob) {
                return oa.getValue() - ob.getValue();
            }
        });
        Assert.assertTrue((entryList.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)((Map.Entry)entryList.get(2)).getValue() - (Integer)((Map.Entry)entryList.get(0)).getValue() < 2 ? 1 : 0) != 0);
    }

    @Test
    public void testForceSplitMultiFamily() throws Exception {
        int numVersions = 3;
        int blockSize = 256;
        byte[][] familyNames = new byte[][]{Bytes.toBytes((String)"cf1"), Bytes.toBytes((String)"cf2")};
        int[] rowCounts = new int[]{6000, 1};
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize);
        rowCounts = new int[]{1, 6000};
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize);
        rowCounts = new int[]{6000, 300};
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize);
        rowCounts = new int[]{300, 6000};
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize);
    }

    void splitTest(byte[] splitPoint, byte[][] familyNames, int[] rowCounts, int numVersions, int blockSize) throws Exception {
        byte[] tableName = Bytes.toBytes((String)"testForceSplit");
        Assert.assertFalse((boolean)this.admin.tableExists(tableName));
        final HTable table = TEST_UTIL.createTable(tableName, familyNames, numVersions, blockSize);
        int rowCount = 0;
        byte[] q = new byte[]{};
        for (int index = 0; index < familyNames.length; ++index) {
            ArrayList<Put> puts = new ArrayList<Put>(rowCounts[index]);
            for (int i = 0; i < rowCounts[index]; ++i) {
                byte[] k = Bytes.toBytes((int)i);
                Put put = new Put(k);
                put.add(familyNames[index], q, k);
                puts.add(put);
            }
            table.put(puts);
            if (rowCount >= rowCounts[index]) continue;
            rowCount = rowCounts[index];
        }
        Map m = table.getRegionsInfo();
        System.out.println("Initial regions (" + m.size() + "): " + m);
        Assert.assertTrue((m.size() == 1 ? 1 : 0) != 0);
        Scan scan = new Scan();
        ResultScanner scanner = table.getScanner(scan);
        int rows = 0;
        for (Result result : scanner) {
            ++rows;
        }
        scanner.close();
        Assert.assertEquals((long)rowCount, (long)rows);
        scan = new Scan();
        scanner = table.getScanner(scan);
        scanner.next();
        final AtomicInteger count = new AtomicInteger(0);
        Thread t = new Thread("CheckForSplit"){

            @Override
            public void run() {
                for (int i = 0; i < 20; ++i) {
                    try {
                        2.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    Map regions = null;
                    try {
                        regions = table.getRegionsInfo();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (regions == null) continue;
                    count.set(regions.size());
                    if (count.get() >= 2) break;
                    TestAdmin.this.LOG.debug((Object)"Cycle waiting on split");
                }
            }
        };
        t.start();
        this.admin.split(tableName, splitPoint);
        t.join();
        rows = 1;
        for (Result result : scanner) {
            if (++rows <= rowCount) continue;
            scanner.close();
            Assert.assertTrue((String)("Scanned more than expected (" + rowCount + ")"), (boolean)false);
        }
        scanner.close();
        Assert.assertEquals((long)rowCount, (long)rows);
        Map regions = null;
        try {
            regions = table.getRegionsInfo();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Assert.assertEquals((long)2L, (long)regions.size());
        HRegionInfo[] r = regions.keySet().toArray(new HRegionInfo[0]);
        if (splitPoint != null) {
            Assert.assertEquals((Object)Bytes.toString((byte[])splitPoint), (Object)Bytes.toString((byte[])r[0].getEndKey()));
            Assert.assertEquals((Object)Bytes.toString((byte[])splitPoint), (Object)Bytes.toString((byte[])r[1].getStartKey()));
            this.LOG.debug((Object)("Properly split on " + Bytes.toString((byte[])splitPoint)));
        } else if (familyNames.length > 1) {
            int splitKey = Bytes.toInt((byte[])r[0].getEndKey());
            int deltaForLargestFamily = Math.abs(rowCount / 2 - splitKey);
            for (int index = 0; index < familyNames.length; ++index) {
                int delta = Math.abs(rowCounts[index] / 2 - splitKey);
                Assert.assertTrue((delta >= deltaForLargestFamily ? 1 : 0) != 0);
            }
        }
        TEST_UTIL.deleteTable(tableName);
        table.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyHHTableDescriptor() throws IOException {
        this.admin.createTable(new HTableDescriptor());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidHColumnDescriptor() throws IOException {
        new HColumnDescriptor("/cfamily/name");
    }

    @Test(timeout=36000L)
    public void testEnableDisableAddColumnDeleteColumn() throws Exception {
        ZooKeeperWatcher zkw = HBaseTestingUtility.getZooKeeperWatcher(TEST_UTIL);
        byte[] tableName = Bytes.toBytes((String)"testMasterAdmin");
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY).close();
        while (!ZKTableReadOnly.isEnabledTable((ZooKeeperWatcher)zkw, (String)"testMasterAdmin")) {
            Thread.sleep(10L);
        }
        this.admin.disableTable(tableName);
        try {
            new HTable(TEST_UTIL.getConfiguration(), tableName);
        }
        catch (DoNotRetryIOException e) {
            // empty catch block
        }
        this.admin.addColumn(tableName, new HColumnDescriptor("col2"));
        this.admin.enableTable(tableName);
        try {
            this.admin.deleteColumn(tableName, Bytes.toBytes((String)"col2"));
        }
        catch (TableNotDisabledException e) {
            this.LOG.info((Object)e);
        }
        this.admin.disableTable(tableName);
        this.admin.deleteTable(tableName);
    }

    @Test
    public void testCreateBadTables() throws IOException {
        int i;
        String msg = null;
        try {
            this.admin.createTable(HTableDescriptor.ROOT_TABLEDESC);
        }
        catch (IllegalArgumentException e) {
            msg = e.toString();
        }
        Assert.assertTrue((String)("Unexcepted exception message " + msg), (msg != null && msg.startsWith(IllegalArgumentException.class.getName()) && msg.contains(HTableDescriptor.ROOT_TABLEDESC.getNameAsString()) ? 1 : 0) != 0);
        msg = null;
        try {
            this.admin.createTable(HTableDescriptor.META_TABLEDESC);
        }
        catch (IllegalArgumentException e) {
            msg = e.toString();
        }
        Assert.assertTrue((String)("Unexcepted exception message " + msg), (msg != null && msg.startsWith(IllegalArgumentException.class.getName()) && msg.contains(HTableDescriptor.META_TABLEDESC.getNameAsString()) ? 1 : 0) != 0);
        final HTableDescriptor threadDesc = new HTableDescriptor("threaded_testCreateBadTables");
        threadDesc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        int count = 10;
        Thread[] threads = new Thread[count];
        final AtomicInteger successes = new AtomicInteger(0);
        final AtomicInteger failures = new AtomicInteger(0);
        final HBaseAdmin localAdmin = this.admin;
        for (i = 0; i < count; ++i) {
            threads[i] = new Thread(Integer.toString(i)){

                @Override
                public void run() {
                    try {
                        localAdmin.createTable(threadDesc);
                        successes.incrementAndGet();
                    }
                    catch (TableExistsException e) {
                        failures.incrementAndGet();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed threaded create" + this.getName(), e);
                    }
                }
            };
        }
        for (i = 0; i < count; ++i) {
            threads[i].start();
        }
        for (i = 0; i < count; ++i) {
            while (threads[i].isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
        }
        Assert.assertEquals((long)1L, (long)successes.get());
        Assert.assertEquals((long)(count - 1), (long)failures.get());
    }

    @Test
    public void testTableNameClash() throws Exception {
        String name = "testTableNameClash";
        this.admin.createTable(new HTableDescriptor(name + "SOMEUPPERCASE"));
        this.admin.createTable(new HTableDescriptor(name));
        new HTable(TEST_UTIL.getConfiguration(), name).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableRPCTimeOut() throws Exception {
        String name = "testCreateTableRPCTimeOut";
        int oldTimeout = TEST_UTIL.getConfiguration().getInt(HConstants.HBASE_RPC_TIMEOUT_KEY, HConstants.DEFAULT_HBASE_RPC_TIMEOUT);
        TEST_UTIL.getConfiguration().setInt(HConstants.HBASE_RPC_TIMEOUT_KEY, 1500);
        try {
            int expectedRegions = 100;
            byte[] startKey = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
            byte[] endKey = new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
            HBaseAdmin hbaseadmin = new HBaseAdmin(TEST_UTIL.getConfiguration());
            hbaseadmin.createTable(new HTableDescriptor(name), startKey, endKey, expectedRegions);
            hbaseadmin.close();
        }
        finally {
            TEST_UTIL.getConfiguration().setInt(HConstants.HBASE_RPC_TIMEOUT_KEY, oldTimeout);
        }
    }

    @Test
    public void testReadOnlyTable() throws Exception {
        byte[] name = Bytes.toBytes((String)"testReadOnlyTable");
        HTable table = TEST_UTIL.createTable(name, HConstants.CATALOG_FAMILY);
        byte[] value = Bytes.toBytes((String)"somedata");
        Put put = new Put(value);
        put.add(HConstants.CATALOG_FAMILY, HConstants.CATALOG_FAMILY, value);
        table.put(put);
        table.close();
    }

    @Test
    public void testTableNames() throws IOException {
        byte[][] illegalNames = new byte[][]{Bytes.toBytes((String)"-bad"), Bytes.toBytes((String)".bad"), HConstants.ROOT_TABLE_NAME, HConstants.META_TABLE_NAME};
        for (int i = 0; i < illegalNames.length; ++i) {
            try {
                new HTableDescriptor(illegalNames[i]);
                throw new IOException("Did not detect '" + Bytes.toString((byte[])illegalNames[i]) + "' as an illegal user table name");
            }
            catch (IllegalArgumentException e) {
                continue;
            }
        }
        byte[] legalName = Bytes.toBytes((String)"g-oo.d");
        try {
            new HTableDescriptor(legalName);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Legal user table name: '" + Bytes.toString((byte[])legalName) + "' caused IllegalArgumentException: " + e.getMessage());
        }
    }

    @Test(expected=TableExistsException.class)
    public void testTableExistsExceptionWithATable() throws IOException {
        byte[] name = Bytes.toBytes((String)"testTableExistsExceptionWithATable");
        TEST_UTIL.createTable(name, HConstants.CATALOG_FAMILY).close();
        TEST_UTIL.createTable(name, HConstants.CATALOG_FAMILY);
    }

    @Test(expected=TableNotEnabledException.class)
    public void testTableNotEnabledExceptionWithATable() throws IOException {
        byte[] name = Bytes.toBytes((String)"testTableNotEnabledExceptionWithATable");
        TEST_UTIL.createTable(name, HConstants.CATALOG_FAMILY).close();
        this.admin.disableTable(name);
        this.admin.disableTable(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=TableNotDisabledException.class)
    public void testTableNotDisabledExceptionWithATable() throws IOException {
        byte[] name = Bytes.toBytes((String)"testTableNotDisabledExceptionWithATable");
        HTable t = TEST_UTIL.createTable(name, HConstants.CATALOG_FAMILY);
        try {
            this.admin.enableTable(name);
        }
        finally {
            t.close();
        }
    }

    @Test(expected=TableNotFoundException.class)
    public void testTableNotFoundExceptionWithoutAnyTables() throws IOException {
        new HTable(TEST_UTIL.getConfiguration(), "testTableNotFoundExceptionWithoutAnyTables");
    }

    @Test
    public void testShouldCloseTheRegionBasedOnTheEncodedRegionName() throws Exception {
        byte[] TABLENAME = Bytes.toBytes((String)"TestHBACloseRegion");
        this.createTableWithDefaultConf(TABLENAME);
        HRegionInfo info = null;
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TABLENAME);
        List onlineRegions = rs.getOnlineRegions();
        for (HRegionInfo regionInfo : onlineRegions) {
            if (regionInfo.isMetaTable()) continue;
            info = regionInfo;
            this.admin.closeRegionWithEncodedRegionName(regionInfo.getEncodedName(), rs.getServerName().getServerName());
        }
        Thread.sleep(1000L);
        onlineRegions = rs.getOnlineRegions();
        Assert.assertFalse((String)"The region should not be present in online regions list.", (boolean)onlineRegions.contains(info));
    }

    @Test
    public void testCloseRegionIfInvalidRegionNameIsPassed() throws Exception {
        byte[] TABLENAME = Bytes.toBytes((String)"TestHBACloseRegion1");
        this.createTableWithDefaultConf(TABLENAME);
        HRegionInfo info = null;
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TABLENAME);
        List onlineRegions = rs.getOnlineRegions();
        for (HRegionInfo regionInfo : onlineRegions) {
            if (regionInfo.isMetaTable() || !regionInfo.getRegionNameAsString().contains("TestHBACloseRegion1")) continue;
            info = regionInfo;
            this.admin.closeRegionWithEncodedRegionName("sample", rs.getServerName().getServerName());
        }
        onlineRegions = rs.getOnlineRegions();
        Assert.assertTrue((String)"The region should be present in online regions list.", (boolean)onlineRegions.contains(info));
    }

    @Test
    public void testCloseRegionThatFetchesTheHRIFromMeta() throws Exception {
        byte[] TABLENAME = Bytes.toBytes((String)"TestHBACloseRegion2");
        this.createTableWithDefaultConf(TABLENAME);
        HRegionInfo info = null;
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TABLENAME);
        List onlineRegions = rs.getOnlineRegions();
        for (HRegionInfo regionInfo : onlineRegions) {
            if (regionInfo.isMetaTable() || !regionInfo.getRegionNameAsString().contains("TestHBACloseRegion2")) continue;
            info = regionInfo;
            this.admin.closeRegion(regionInfo.getRegionNameAsString(), rs.getServerName().getServerName());
        }
        boolean isInList = rs.getOnlineRegions().contains(info);
        long timeout = System.currentTimeMillis() + 2000L;
        while (System.currentTimeMillis() < timeout && isInList) {
            Thread.sleep(100L);
            isInList = rs.getOnlineRegions().contains(info);
        }
        Assert.assertFalse((String)"The region should not be present in online regions list.", (boolean)isInList);
    }

    @Test
    public void testCloseRegionWhenServerNameIsNull() throws Exception {
        byte[] TABLENAME = Bytes.toBytes((String)"TestHBACloseRegion3");
        this.createTableWithDefaultConf(TABLENAME);
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TABLENAME);
        try {
            List onlineRegions = rs.getOnlineRegions();
            for (HRegionInfo regionInfo : onlineRegions) {
                if (regionInfo.isMetaTable() || !regionInfo.getRegionNameAsString().contains("TestHBACloseRegion3")) continue;
                this.admin.closeRegionWithEncodedRegionName(regionInfo.getEncodedName(), null);
            }
            Assert.fail((String)"The test should throw exception if the servername passed is null.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCloseRegionWhenServerNameIsEmpty() throws Exception {
        byte[] TABLENAME = Bytes.toBytes((String)"TestHBACloseRegionWhenServerNameIsEmpty");
        this.createTableWithDefaultConf(TABLENAME);
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TABLENAME);
        try {
            List onlineRegions = rs.getOnlineRegions();
            for (HRegionInfo regionInfo : onlineRegions) {
                if (regionInfo.isMetaTable() || !regionInfo.getRegionNameAsString().contains("TestHBACloseRegionWhenServerNameIsEmpty")) continue;
                this.admin.closeRegionWithEncodedRegionName(regionInfo.getEncodedName(), " ");
            }
            Assert.fail((String)"The test should throw exception if the servername passed is empty.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCloseRegionWhenEncodedRegionNameIsNotGiven() throws Exception {
        byte[] TABLENAME = Bytes.toBytes((String)"TestHBACloseRegion4");
        this.createTableWithDefaultConf(TABLENAME);
        HRegionInfo info = null;
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TABLENAME);
        List onlineRegions = rs.getOnlineRegions();
        for (HRegionInfo regionInfo : onlineRegions) {
            if (regionInfo.isMetaTable() || !regionInfo.getRegionNameAsString().contains("TestHBACloseRegion4")) continue;
            info = regionInfo;
            this.admin.closeRegionWithEncodedRegionName(regionInfo.getRegionNameAsString(), rs.getServerName().getServerName());
        }
        onlineRegions = rs.getOnlineRegions();
        Assert.assertTrue((String)"The region should be present in online regions list.", (boolean)onlineRegions.contains(info));
    }

    private HBaseAdmin createTable(byte[] TABLENAME) throws IOException {
        Configuration config = TEST_UTIL.getConfiguration();
        HBaseAdmin admin = new HBaseAdmin(config);
        HTableDescriptor htd = new HTableDescriptor(TABLENAME);
        HColumnDescriptor hcd = new HColumnDescriptor("value");
        htd.addFamily(hcd);
        admin.createTable(htd, (byte[][])null);
        return admin;
    }

    private void createTableWithDefaultConf(byte[] TABLENAME) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TABLENAME);
        HColumnDescriptor hcd = new HColumnDescriptor("value");
        htd.addFamily(hcd);
        this.admin.createTable(htd, (byte[][])null);
    }

    @Test
    public void testGetTableRegions() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testGetTableRegions");
        int expectedRegions = 10;
        byte[] startKey = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        byte[] endKey = new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc, startKey, endKey, expectedRegions);
        List RegionInfos = this.admin.getTableRegions(tableName);
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions " + "but only found " + RegionInfos.size()), (long)expectedRegions, (long)RegionInfos.size());
    }

    @Test
    public void testHLogRollWriting() throws Exception {
        this.setUpforLogRolling();
        String className = this.getClass().getName();
        StringBuilder v = new StringBuilder(className);
        while (v.length() < 1000) {
            v.append(className);
        }
        byte[] value = Bytes.toBytes((String)v.toString());
        HRegionServer regionServer = this.startAndWriteData("TestLogRolling", value);
        this.LOG.info((Object)("after writing there are " + HLogUtilsForTests.getNumLogFiles(regionServer.getWAL()) + " log files"));
        ArrayList regions = new ArrayList(regionServer.getOnlineRegionsLocalContext());
        for (HRegion r : regions) {
            r.flushcache();
        }
        this.admin.rollHLogWriter(regionServer.getServerName().getServerName());
        int count = HLogUtilsForTests.getNumLogFiles(regionServer.getWAL());
        this.LOG.info((Object)("after flushing all regions and rolling logs there are " + count + " log files"));
        Assert.assertTrue((String)("actual count: " + count), (count <= 2 ? 1 : 0) != 0);
    }

    private void setUpforLogRolling() {
        TEST_UTIL.getConfiguration().setLong("hbase.hregion.max.filesize", 786432L);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.maxlogentries", 32);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.logroll.errors.tolerated", 2);
        TEST_UTIL.getConfiguration().setInt("ipc.ping.interval", 10000);
        TEST_UTIL.getConfiguration().setInt("ipc.socket.timeout", 10000);
        TEST_UTIL.getConfiguration().setInt("hbase.rpc.timeout", 10000);
        TEST_UTIL.getConfiguration().setInt("hbase.hregion.memstore.optionalflushcount", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.hregion.memstore.flush.size", 8192);
        TEST_UTIL.getConfiguration().setLong("hbase.client.pause", 10000L);
        TEST_UTIL.getConfiguration().setInt("hbase.server.thread.wakefrequency", 2000);
        TEST_UTIL.getConfiguration().setBoolean("dfs.support.append", true);
        TEST_UTIL.getConfiguration().setInt("heartbeat.recheck.interval", 5000);
        TEST_UTIL.getConfiguration().setInt("dfs.heartbeat.interval", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.block.write.retries", 30);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.hlog.tolerable.lowreplication", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.hlog.lowreplication.rolllimit", 3);
    }

    private HRegionServer startAndWriteData(String tableName, byte[] value) throws IOException {
        new HTable(TEST_UTIL.getConfiguration(), HConstants.META_TABLE_NAME).close();
        HRegionServer regionServer = TEST_UTIL.getHBaseCluster().getRegionServerThreads().get(0).getRegionServer();
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc);
        HTable table = new HTable(TEST_UTIL.getConfiguration(), tableName);
        regionServer = TEST_UTIL.getRSForFirstRegionInTable(Bytes.toBytes((String)tableName));
        for (int i = 1; i <= 256; ++i) {
            Put put = new Put(Bytes.toBytes((String)("row" + String.format("%1$04d", i))));
            put.add(HConstants.CATALOG_FAMILY, null, value);
            table.put(put);
            if (i % 32 != 0) continue;
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        table.close();
        return regionServer;
    }

    @Test
    public void testCheckHBaseAvailableClosesConnection() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        int initialCount = HConnectionTestingUtility.getConnectionCount();
        HBaseAdmin.checkHBaseAvailable((Configuration)conf);
        int finalCount = HConnectionTestingUtility.getConnectionCount();
        Assert.assertEquals((long)initialCount, (long)finalCount);
    }

    @Test
    public void testDisableCatalogTable() throws Exception {
        try {
            this.admin.disableTable(".META.");
            Assert.fail((String)"Expected to throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        HTableDescriptor htd = new HTableDescriptor("testDisableCatalogTable".getBytes());
        HColumnDescriptor hcd = new HColumnDescriptor("cf1".getBytes());
        htd.addFamily(hcd);
        TEST_UTIL.getHBaseAdmin().createTable(htd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRegion() throws Exception {
        String name = "testGetRegion";
        this.LOG.info((Object)"Started testGetRegion");
        byte[] nameBytes = Bytes.toBytes((String)"testGetRegion");
        HTable t = TEST_UTIL.createTable(nameBytes, HConstants.CATALOG_FAMILY);
        TEST_UTIL.createMultiRegions(t, HConstants.CATALOG_FAMILY);
        CatalogTracker ct = new CatalogTracker(TEST_UTIL.getConfiguration());
        ct.start();
        try {
            HRegionLocation regionLocation = t.getRegionLocation("mmm");
            HRegionInfo region = regionLocation.getRegionInfo();
            byte[] regionName = region.getRegionName();
            Pair pair = this.admin.getRegion(regionName, ct);
            Assert.assertTrue((boolean)Bytes.equals((byte[])regionName, (byte[])((HRegionInfo)pair.getFirst()).getRegionName()));
            pair = this.admin.getRegion(region.getEncodedNameAsBytes(), ct);
            Assert.assertTrue((boolean)Bytes.equals((byte[])regionName, (byte[])((HRegionInfo)pair.getFirst()).getRegionName()));
        }
        finally {
            ct.stop();
        }
    }

    @Test
    public void testRootTableSplit() throws Exception {
        Scan s = new Scan();
        HTable rootTable = new HTable(TEST_UTIL.getConfiguration(), HConstants.ROOT_TABLE_NAME);
        ResultScanner scanner = rootTable.getScanner(s);
        Result metaEntry = scanner.next();
        this.admin.split(HConstants.ROOT_TABLE_NAME, metaEntry.getRow());
        Thread.sleep(1000L);
        List<HRegion> regions = TEST_UTIL.getMiniHBaseCluster().getRegions(HConstants.ROOT_TABLE_NAME);
        Assert.assertEquals((String)"ROOT region should not be splitted.", (long)1L, (long)regions.size());
    }

    static class DoneListener
    implements EventHandler.EventHandlerListener {
        private final AtomicBoolean done;

        DoneListener(AtomicBoolean done) {
            this.done = done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterProcess(EventHandler event) {
            this.done.set(true);
            AtomicBoolean atomicBoolean = this.done;
            synchronized (atomicBoolean) {
                this.done.notifyAll();
            }
        }

        public void beforeProcess(EventHandler event) {
        }
    }
}

