/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestAttributes {
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Test
    public void testAttributesSerialization() throws IOException {
        Put put = new Put();
        put.setAttribute("attribute1", Bytes.toBytes((String)"value1"));
        put.setAttribute("attribute2", Bytes.toBytes((String)"value2"));
        put.setAttribute("attribute3", Bytes.toBytes((String)"value3"));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteArrayOutputStream);
        put.write((DataOutput)out);
        Put put2 = new Put();
        Assert.assertTrue((boolean)put2.getAttributesMap().isEmpty());
        put2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
        Assert.assertNull((Object)put2.getAttribute("absent"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value1"), put2.getAttribute("attribute1")));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value2"), put2.getAttribute("attribute2")));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value3"), put2.getAttribute("attribute3")));
        Assert.assertEquals((long)3L, (long)put2.getAttributesMap().size());
    }

    @Test
    public void testPutAttributes() {
        Put put = new Put();
        Assert.assertTrue((boolean)put.getAttributesMap().isEmpty());
        Assert.assertNull((Object)put.getAttribute("absent"));
        put.setAttribute("absent", null);
        Assert.assertTrue((boolean)put.getAttributesMap().isEmpty());
        Assert.assertNull((Object)put.getAttribute("absent"));
        put.setAttribute("attribute1", Bytes.toBytes((String)"value1"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value1"), put.getAttribute("attribute1")));
        Assert.assertEquals((long)1L, (long)put.getAttributesMap().size());
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value1"), (byte[])put.getAttributesMap().get("attribute1")));
        put.setAttribute("attribute1", Bytes.toBytes((String)"value12"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value12"), put.getAttribute("attribute1")));
        Assert.assertEquals((long)1L, (long)put.getAttributesMap().size());
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value12"), (byte[])put.getAttributesMap().get("attribute1")));
        put.setAttribute("attribute2", Bytes.toBytes((String)"value2"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value2"), put.getAttribute("attribute2")));
        Assert.assertEquals((long)2L, (long)put.getAttributesMap().size());
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value2"), (byte[])put.getAttributesMap().get("attribute2")));
        put.setAttribute("attribute2", null);
        Assert.assertNull((Object)put.getAttribute("attribute2"));
        Assert.assertEquals((long)1L, (long)put.getAttributesMap().size());
        Assert.assertNull(put.getAttributesMap().get("attribute2"));
        put.setAttribute("attribute2", null);
        Assert.assertNull((Object)put.getAttribute("attribute2"));
        Assert.assertEquals((long)1L, (long)put.getAttributesMap().size());
        Assert.assertNull(put.getAttributesMap().get("attribute2"));
        put.setAttribute("attribute1", null);
        Assert.assertNull((Object)put.getAttribute("attribute1"));
        Assert.assertTrue((boolean)put.getAttributesMap().isEmpty());
        Assert.assertNull(put.getAttributesMap().get("attribute1"));
    }

    @Test
    public void testDeleteAttributes() {
        Delete del = new Delete();
        Assert.assertTrue((boolean)del.getAttributesMap().isEmpty());
        Assert.assertNull((Object)del.getAttribute("absent"));
        del.setAttribute("absent", null);
        Assert.assertTrue((boolean)del.getAttributesMap().isEmpty());
        Assert.assertNull((Object)del.getAttribute("absent"));
        del.setAttribute("attribute1", Bytes.toBytes((String)"value1"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value1"), del.getAttribute("attribute1")));
        Assert.assertEquals((long)1L, (long)del.getAttributesMap().size());
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value1"), (byte[])del.getAttributesMap().get("attribute1")));
        del.setAttribute("attribute1", Bytes.toBytes((String)"value12"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value12"), del.getAttribute("attribute1")));
        Assert.assertEquals((long)1L, (long)del.getAttributesMap().size());
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value12"), (byte[])del.getAttributesMap().get("attribute1")));
        del.setAttribute("attribute2", Bytes.toBytes((String)"value2"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value2"), del.getAttribute("attribute2")));
        Assert.assertEquals((long)2L, (long)del.getAttributesMap().size());
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value2"), (byte[])del.getAttributesMap().get("attribute2")));
        del.setAttribute("attribute2", null);
        Assert.assertNull((Object)del.getAttribute("attribute2"));
        Assert.assertEquals((long)1L, (long)del.getAttributesMap().size());
        Assert.assertNull(del.getAttributesMap().get("attribute2"));
        del.setAttribute("attribute2", null);
        Assert.assertNull((Object)del.getAttribute("attribute2"));
        Assert.assertEquals((long)1L, (long)del.getAttributesMap().size());
        Assert.assertNull(del.getAttributesMap().get("attribute2"));
        del.setAttribute("attribute1", null);
        Assert.assertNull((Object)del.getAttribute("attribute1"));
        Assert.assertTrue((boolean)del.getAttributesMap().isEmpty());
        Assert.assertNull(del.getAttributesMap().get("attribute1"));
    }

    @Test
    public void testGetId() {
        Get get = new Get();
        Assert.assertNull((String)"Make sure id is null if unset", get.toMap().get("id"));
        get.setId("myId");
        Assert.assertEquals((Object)"myId", get.toMap().get("id"));
    }

    @Test
    public void testAppendId() {
        Append append = new Append();
        Assert.assertNull((String)"Make sure id is null if unset", append.toMap().get("id"));
        append.setId("myId");
        Assert.assertEquals((Object)"myId", append.toMap().get("id"));
    }

    @Test
    public void testDeleteId() {
        Delete delete = new Delete();
        Assert.assertNull((String)"Make sure id is null if unset", delete.toMap().get("id"));
        delete.setId("myId");
        Assert.assertEquals((Object)"myId", delete.toMap().get("id"));
    }

    @Test
    public void testPutId() {
        Put put = new Put();
        Assert.assertNull((String)"Make sure id is null if unset", put.toMap().get("id"));
        put.setId("myId");
        Assert.assertEquals((Object)"myId", put.toMap().get("id"));
    }

    @Test
    public void testScanId() {
        Scan scan = new Scan();
        Assert.assertNull((String)"Make sure id is null if unset", scan.toMap().get("id"));
        scan.setId("myId");
        Assert.assertEquals((Object)"myId", scan.toMap().get("id"));
    }
}

