/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestHCM {
    private static final Log LOG = LogFactory.getLog(TestHCM.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] TABLE_NAME = Bytes.toBytes((String)"test");
    private static final byte[] TABLE_NAME1 = Bytes.toBytes((String)"test1");
    private static final byte[] FAM_NAM = Bytes.toBytes((String)"f");
    private static final byte[] ROW = Bytes.toBytes((String)"bbb");
    private static Random _randy = new Random();
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    public void testManyNewConnectionsDoesnotOOME() throws SecurityException, IllegalArgumentException, ZooKeeperConnectionException, NoSuchFieldException, IllegalAccessException, InterruptedException {
        TestHCM.createNewConfigurations();
    }

    public static void createNewConfigurations() throws SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException, InterruptedException, ZooKeeperConnectionException {
        HConnection last = null;
        for (int i = 0; i <= HConnectionManager.MAX_CACHED_HBASE_INSTANCES * 2; ++i) {
            Configuration configuration = HBaseConfiguration.create();
            configuration.set("somekey", String.valueOf(_randy.nextInt()));
            System.out.println("Hash Code: " + configuration.hashCode());
            HConnection connection = HConnectionManager.getConnection((Configuration)configuration);
            if (last != null && last == connection) {
                System.out.println("!! Got same connection for once !!");
            }
            configuration.set("someotherkey", String.valueOf(_randy.nextInt()));
            last = connection;
            LOG.info((Object)("Cache Size: " + TestHCM.getHConnectionManagerCacheSize()));
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)1L, (long)TestHCM.getHConnectionManagerCacheSize());
    }

    private static int getHConnectionManagerCacheSize() {
        return HConnectionTestingUtility.getConnectionCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void abortingHConnectionRemovesItselfFromHCM() throws Exception {
        HashMap oldHBaseInstances = new HashMap();
        oldHBaseInstances.putAll(HConnectionManager.HBASE_INSTANCES);
        HConnectionManager.HBASE_INSTANCES.clear();
        try {
            HConnection connection = HConnectionManager.getConnection((Configuration)TEST_UTIL.getConfiguration());
            connection.abort("test abortingHConnectionRemovesItselfFromHCM", (Throwable)new Exception("test abortingHConnectionRemovesItselfFromHCM"));
            Assert.assertNotSame((Object)connection, (Object)HConnectionManager.getConnection((Configuration)TEST_UTIL.getConfiguration()));
        }
        finally {
            HConnectionManager.HBASE_INSTANCES.clear();
            HConnectionManager.HBASE_INSTANCES.putAll(oldHBaseInstances);
        }
    }

    @Test
    public void testRegionCaching() throws Exception {
        HTable table = TEST_UTIL.createTable(TABLE_NAME, FAM_NAM);
        TEST_UTIL.createMultiRegions(table, FAM_NAM);
        Put put = new Put(ROW);
        put.add(FAM_NAM, ROW, ROW);
        table.put(put);
        HConnectionManager.HConnectionImplementation conn = (HConnectionManager.HConnectionImplementation)table.getConnection();
        Assert.assertNotNull((Object)conn.getCachedLocation(TABLE_NAME, ROW));
        conn.deleteCachedLocation(TABLE_NAME, ROW);
        HRegionLocation rl = conn.getCachedLocation(TABLE_NAME, ROW);
        Assert.assertNull((String)("What is this location?? " + rl), (Object)rl);
        table.close();
    }

    @Test
    public void testConnectionManagement() throws Exception {
        TEST_UTIL.createTable(TABLE_NAME1, FAM_NAM);
        HConnection conn = HConnectionManager.createConnection((Configuration)TEST_UTIL.getConfiguration());
        ThreadPoolExecutor pool = new ThreadPoolExecutor(1, 10, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Threads.newDaemonThreadFactory((String)"test-hcm-table"));
        HTable table = new HTable(TABLE_NAME1, conn, (ExecutorService)pool);
        table.close();
        Assert.assertFalse((boolean)conn.isClosed());
        Assert.assertFalse((boolean)pool.isShutdown());
        table = new HTable(TEST_UTIL.getConfiguration(), TABLE_NAME1, (ExecutorService)pool);
        table.close();
        Assert.assertFalse((boolean)pool.isShutdown());
        conn.close();
        pool.shutdownNow();
    }

    @Test
    public void testConnectionSameness() throws Exception {
        HConnection previousConnection = null;
        for (int i = 0; i < 2; ++i) {
            Configuration configuration = TEST_UTIL.getConfiguration();
            configuration.set("some_key", String.valueOf(_randy.nextInt()));
            LOG.info((Object)("The hash code of the current configuration is: " + configuration.hashCode()));
            HConnection currentConnection = HConnectionManager.getConnection((Configuration)configuration);
            if (previousConnection != null) {
                Assert.assertTrue((String)"Did not get the same connection even though its key didn't change", (previousConnection == currentConnection ? 1 : 0) != 0);
            }
            previousConnection = currentConnection;
            configuration.set("other_key", String.valueOf(_randy.nextInt()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionUniqueness() throws Exception {
        int zkmaxconnections = TEST_UTIL.getConfiguration().getInt("hbase.zookeeper.property.maxClientCnxns", 300);
        int maxConnections = Math.min(zkmaxconnections - 1, 20);
        ArrayList<HConnection> connections = new ArrayList<HConnection>(maxConnections);
        HConnection previousConnection = null;
        try {
            for (int i = 0; i < maxConnections; ++i) {
                Configuration configuration = new Configuration(TEST_UTIL.getConfiguration());
                configuration.set("some_key", String.valueOf(_randy.nextInt()));
                configuration.set(HConstants.HBASE_CLIENT_INSTANCE_ID, String.valueOf(_randy.nextInt()));
                LOG.info((Object)("The hash code of the current configuration is: " + configuration.hashCode()));
                HConnection currentConnection = HConnectionManager.getConnection((Configuration)configuration);
                if (previousConnection != null) {
                    Assert.assertTrue((String)"Got the same connection even though its key changed!", (previousConnection != currentConnection ? 1 : 0) != 0);
                }
                configuration.set("other_key", String.valueOf(_randy.nextInt()));
                previousConnection = currentConnection;
                LOG.info((Object)("The current HConnectionManager#HBASE_INSTANCES cache size is: " + TestHCM.getHConnectionManagerCacheSize()));
                Thread.sleep(50L);
                connections.add(currentConnection);
            }
        }
        finally {
            for (HConnection c : connections) {
                HConnectionManager.deleteConnection((Configuration)c.getConfiguration());
            }
        }
    }

    @Test
    public void testClosing() throws Exception {
        Configuration configuration = new Configuration(TEST_UTIL.getConfiguration());
        configuration.set(HConstants.HBASE_CLIENT_INSTANCE_ID, String.valueOf(_randy.nextInt()));
        HConnection c1 = HConnectionManager.createConnection((Configuration)configuration);
        HConnection c2 = HConnectionManager.createConnection((Configuration)configuration);
        HConnection c3 = HConnectionManager.getConnection((Configuration)configuration);
        HConnection c4 = HConnectionManager.getConnection((Configuration)configuration);
        Assert.assertTrue((c3 == c4 ? 1 : 0) != 0);
        c1.close();
        Assert.assertTrue((boolean)c1.isClosed());
        Assert.assertFalse((boolean)c2.isClosed());
        Assert.assertFalse((boolean)c3.isClosed());
        c3.close();
        Assert.assertFalse((boolean)c3.isClosed());
        c3.close();
        Assert.assertTrue((boolean)c3.isClosed());
        HConnection c5 = HConnectionManager.getConnection((Configuration)configuration);
        Assert.assertTrue((c5 != c3 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)c2.isClosed());
        c2.close();
        Assert.assertTrue((boolean)c2.isClosed());
        c5.close();
        Assert.assertTrue((boolean)c5.isClosed());
    }

    @Test
    public void testCreateConnection() throws Exception {
        HConnection c2;
        Configuration configuration = TEST_UTIL.getConfiguration();
        HConnection c1 = HConnectionManager.createConnection((Configuration)configuration);
        Assert.assertTrue((c1 != (c2 = HConnectionManager.createConnection((Configuration)configuration)) ? 1 : 0) != 0);
        Assert.assertTrue((c1.getConfiguration() == c2.getConfiguration() ? 1 : 0) != 0);
        HConnection c3 = HConnectionManager.getConnection((Configuration)configuration);
        Assert.assertTrue((c1 != c3 ? 1 : 0) != 0);
        Assert.assertTrue((c2 != c3 ? 1 : 0) != 0);
    }
}

