/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMultiParallel {
    private static final Log LOG = LogFactory.getLog(TestMultiParallel.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final byte[] VALUE = Bytes.toBytes((String)"value");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"qual");
    private static final String FAMILY = "family";
    private static final String TEST_TABLE = "multi_test_table";
    private static final byte[] BYTES_FAMILY = Bytes.toBytes((String)"family");
    private static final byte[] ONE_ROW = Bytes.toBytes((String)"xxx");
    private static final byte[][] KEYS = TestMultiParallel.makeKeys();
    private static final int slaves = 2;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster(2);
        HTable t = UTIL.createTable(Bytes.toBytes((String)TEST_TABLE), Bytes.toBytes((String)FAMILY));
        UTIL.createMultiRegions(t, Bytes.toBytes((String)FAMILY));
        UTIL.waitTableAvailable(Bytes.toBytes((String)TEST_TABLE), 15000L);
        t.close();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void before() throws IOException {
        LOG.info((Object)"before");
        if (UTIL.ensureSomeRegionServersAvailable(2)) {
            UTIL.getMiniHBaseCluster().getMaster().balance();
        }
        LOG.info((Object)"before done");
    }

    private static byte[][] makeKeys() {
        byte[] cp;
        byte[] k;
        int kIdx;
        int i;
        byte[][] starterKeys = HBaseTestingUtility.KEYS;
        int numKeys = (int)((float)starterKeys.length * 10.33f);
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        for (i = 0; i < numKeys; ++i) {
            kIdx = i % starterKeys.length;
            k = starterKeys[kIdx];
            cp = new byte[k.length + 1];
            System.arraycopy(k, 0, cp, 0, k.length);
            cp[k.length] = new Integer(i % 256).byteValue();
            keys.add(cp);
        }
        for (i = 0; i < 100; ++i) {
            kIdx = i % starterKeys.length;
            k = starterKeys[kIdx];
            cp = new byte[k.length + 1];
            System.arraycopy(k, 0, cp, 0, k.length);
            cp[k.length] = new Integer(i % 256).byteValue();
            keys.add(cp);
        }
        return (byte[][])keys.toArray((T[])new byte[][]{new byte[0]});
    }

    @Test(timeout=300000L)
    public void testActiveThreadsCount() throws Exception {
        HTable table = new HTable(UTIL.getConfiguration(), TEST_TABLE);
        List<Row> puts = this.constructPutRequests();
        table.batch(puts);
        Field poolField = table.getClass().getDeclaredField("pool");
        poolField.setAccessible(true);
        ThreadPoolExecutor tExecutor = (ThreadPoolExecutor)poolField.get(table);
        Assert.assertEquals((long)2L, (long)tExecutor.getLargestPoolSize());
        table.close();
    }

    @Test(timeout=300000L)
    public void testBatchWithGet() throws Exception {
        LOG.info((Object)"test=testBatchWithGet");
        HTable table = new HTable(UTIL.getConfiguration(), TEST_TABLE);
        List<Row> puts = this.constructPutRequests();
        table.batch(puts);
        ArrayList<Get> gets = new ArrayList<Get>();
        for (byte[] byArray : KEYS) {
            Get get = new Get(byArray);
            get.addColumn(BYTES_FAMILY, QUALIFIER);
            gets.add(get);
        }
        Object[] multiRes = new Result[gets.size()];
        table.batch(gets, multiRes);
        ArrayList<Result> singleRes = new ArrayList<Result>();
        for (Row row : gets) {
            singleRes.add(table.get((Get)row));
        }
        Assert.assertEquals((long)singleRes.size(), (long)multiRes.length);
        for (int i = 0; i < singleRes.size(); ++i) {
            Assert.assertTrue((boolean)((Result)singleRes.get(i)).containsColumn(BYTES_FAMILY, QUALIFIER));
            KeyValue[] keyValueArray = ((Result)singleRes.get(i)).raw();
            KeyValue[] multiKvs = multiRes[i].raw();
            for (int j = 0; j < keyValueArray.length; ++j) {
                Assert.assertEquals((Object)keyValueArray[j], (Object)multiKvs[j]);
                Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])keyValueArray[j].getValue(), (byte[])multiKvs[j].getValue()));
            }
        }
        table.close();
    }

    @Test
    public void testBadFam() throws Exception {
        LOG.info((Object)"test=testBadFam");
        HTable table = new HTable(UTIL.getConfiguration(), TEST_TABLE);
        ArrayList<Put> actions = new ArrayList<Put>();
        Put p = new Put(Bytes.toBytes((String)"row1"));
        p.add(Bytes.toBytes((String)"bad_family"), Bytes.toBytes((String)"qual"), Bytes.toBytes((String)"value"));
        actions.add(p);
        p = new Put(Bytes.toBytes((String)"row2"));
        p.add(BYTES_FAMILY, Bytes.toBytes((String)"qual"), Bytes.toBytes((String)"value"));
        actions.add(p);
        Object[] r = new Object[actions.size()];
        try {
            table.batch(actions, r);
            Assert.fail();
        }
        catch (RetriesExhaustedWithDetailsException ex) {
            LOG.debug((Object)ex);
            Assert.assertFalse((boolean)ex.mayHaveClusterIssues());
        }
        Assert.assertEquals((long)2L, (long)r.length);
        Assert.assertTrue((boolean)(r[0] instanceof Throwable));
        Assert.assertTrue((boolean)(r[1] instanceof Result));
        table.close();
    }

    @Test(timeout=300000L)
    public void testFlushCommitsWithAbort() throws Exception {
        LOG.info((Object)"test=testFlushCommitsWithAbort");
        this.doTestFlushCommits(true);
    }

    @Test(timeout=300000L)
    public void testFlushCommitsNoAbort() throws Exception {
        LOG.info((Object)"test=testFlushCommitsNoAbort");
        this.doTestFlushCommits(false);
    }

    private void doTestFlushCommits(boolean doAbort) throws Exception {
        LOG.info((Object)"get new table");
        HTable table = new HTable(UTIL.getConfiguration(), TEST_TABLE);
        table.setAutoFlush(false);
        table.setWriteBufferSize(0xA00000L);
        LOG.info((Object)"constructPutRequests");
        List<Row> puts = this.constructPutRequests();
        for (Row put : puts) {
            table.put((Put)put);
        }
        LOG.info((Object)"puts");
        table.flushCommits();
        int liveRScount = UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().size();
        assert (liveRScount > 0);
        JVMClusterUtil.RegionServerThread liveRS = UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().get(0);
        if (doAbort) {
            LOG.info((Object)("Aborted=" + UTIL.getMiniHBaseCluster().abortRegionServer(0)));
            while (liveRS.getRegionServer().getNumberOfOnlineRegions() != 0) {
                Thread.sleep(100L);
            }
            while (UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().size() == liveRScount) {
                Thread.sleep(100L);
            }
            puts = this.constructPutRequests();
            for (Row put : puts) {
                table.put((Put)put);
            }
            table.flushCommits();
        }
        LOG.info((Object)"validating loaded data");
        this.validateLoadedData(table);
        List<JVMClusterUtil.RegionServerThread> liveRSs = UTIL.getMiniHBaseCluster().getLiveRegionServerThreads();
        int count = 0;
        for (JVMClusterUtil.RegionServerThread t : liveRSs) {
            LOG.info((Object)("Count=" + ++count + ", Alive=" + t.getRegionServer()));
        }
        LOG.info((Object)("Count=" + count));
        Assert.assertEquals((String)("Server count=" + count + ", abort=" + doAbort), (long)(doAbort ? liveRScount - 1 : liveRScount), (long)count);
        for (JVMClusterUtil.RegionServerThread t : liveRSs) {
            int regions = t.getRegionServer().getOnlineRegions().size();
            Assert.assertTrue((String)("Count of regions=" + regions), (regions > 10 ? 1 : 0) != 0);
        }
        table.close();
        LOG.info((Object)"done");
    }

    @Test(timeout=300000L)
    public void testBatchWithPut() throws Exception {
        LOG.info((Object)"test=testBatchWithPut");
        HTable table = new HTable(UTIL.getConfiguration(), TEST_TABLE);
        List<Row> puts = this.constructPutRequests();
        Object[] results = table.batch(puts);
        this.validateSizeAndEmpty(results, KEYS.length);
        int liveRScount = UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().size();
        assert (liveRScount > 0);
        JVMClusterUtil.RegionServerThread liveRS = UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().get(0);
        liveRS.getRegionServer().abort("Aborting for tests", (Throwable)new Exception("testBatchWithPut"));
        puts = this.constructPutRequests();
        results = table.batch(puts);
        this.validateSizeAndEmpty(results, KEYS.length);
        this.validateLoadedData(table);
        table.close();
    }

    @Test(timeout=300000L)
    public void testBatchWithDelete() throws Exception {
        LOG.info((Object)"test=testBatchWithDelete");
        HTable table = new HTable(UTIL.getConfiguration(), TEST_TABLE);
        List<Row> puts = this.constructPutRequests();
        Object[] results = table.batch(puts);
        this.validateSizeAndEmpty(results, KEYS.length);
        ArrayList<Delete> deletes = new ArrayList<Delete>();
        for (int i = 0; i < KEYS.length; ++i) {
            Delete delete = new Delete(KEYS[i]);
            delete.deleteFamily(BYTES_FAMILY);
            deletes.add(delete);
        }
        results = table.batch(deletes);
        this.validateSizeAndEmpty(results, KEYS.length);
        for (byte[] k : KEYS) {
            Get get = new Get(k);
            get.addColumn(BYTES_FAMILY, QUALIFIER);
            Assert.assertFalse((boolean)table.exists(get));
        }
        table.close();
    }

    @Test(timeout=300000L)
    public void testHTableDeleteWithList() throws Exception {
        LOG.info((Object)"test=testHTableDeleteWithList");
        HTable table = new HTable(UTIL.getConfiguration(), TEST_TABLE);
        List<Row> puts = this.constructPutRequests();
        Object[] results = table.batch(puts);
        this.validateSizeAndEmpty(results, KEYS.length);
        ArrayList<Delete> deletes = new ArrayList<Delete>();
        for (int i = 0; i < KEYS.length; ++i) {
            Delete delete = new Delete(KEYS[i]);
            delete.deleteFamily(BYTES_FAMILY);
            deletes.add(delete);
        }
        table.delete(deletes);
        Assert.assertTrue((boolean)deletes.isEmpty());
        for (byte[] k : KEYS) {
            Get get = new Get(k);
            get.addColumn(BYTES_FAMILY, QUALIFIER);
            Assert.assertFalse((boolean)table.exists(get));
        }
        table.close();
    }

    @Test(timeout=300000L)
    public void testBatchWithManyColsInOneRowGetAndPut() throws Exception {
        LOG.info((Object)"test=testBatchWithManyColsInOneRowGetAndPut");
        HTable table = new HTable(UTIL.getConfiguration(), TEST_TABLE);
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int i = 0; i < 100; ++i) {
            Put put = new Put(ONE_ROW);
            byte[] qual = Bytes.toBytes((String)("column" + i));
            put.add(BYTES_FAMILY, qual, VALUE);
            puts.add(put);
        }
        Object[] results = table.batch(puts);
        this.validateSizeAndEmpty(results, 100);
        ArrayList<Get> gets = new ArrayList<Get>();
        for (int i = 0; i < 100; ++i) {
            Get get = new Get(ONE_ROW);
            byte[] qual = Bytes.toBytes((String)("column" + i));
            get.addColumn(BYTES_FAMILY, qual);
            gets.add(get);
        }
        Object[] multiRes = table.batch(gets);
        int idx = 0;
        for (Object r : multiRes) {
            byte[] qual = Bytes.toBytes((String)("column" + idx));
            this.validateResult(r, qual, VALUE);
            ++idx;
        }
        table.close();
    }

    @Test(timeout=300000L)
    public void testBatchWithIncrementAndAppend() throws Exception {
        LOG.info((Object)"test=testBatchWithIncrementAndAppend");
        byte[] QUAL1 = Bytes.toBytes((String)"qual1");
        byte[] QUAL2 = Bytes.toBytes((String)"qual2");
        byte[] QUAL3 = Bytes.toBytes((String)"qual3");
        byte[] QUAL4 = Bytes.toBytes((String)"qual4");
        HTable table = new HTable(UTIL.getConfiguration(), TEST_TABLE);
        Delete d = new Delete(ONE_ROW);
        table.delete(d);
        Put put = new Put(ONE_ROW);
        put.add(BYTES_FAMILY, QUAL1, Bytes.toBytes((String)"abc"));
        put.add(BYTES_FAMILY, QUAL2, Bytes.toBytes((long)1L));
        table.put(put);
        Increment inc = new Increment(ONE_ROW);
        inc.addColumn(BYTES_FAMILY, QUAL2, 1L);
        inc.addColumn(BYTES_FAMILY, QUAL3, 1L);
        Append a = new Append(ONE_ROW);
        a.add(BYTES_FAMILY, QUAL1, Bytes.toBytes((String)"def"));
        a.add(BYTES_FAMILY, QUAL4, Bytes.toBytes((String)"xyz"));
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(inc);
        actions.add(a);
        Object[] multiRes = table.batch(actions);
        this.validateResult(multiRes[1], QUAL1, Bytes.toBytes((String)"abcdef"));
        this.validateResult(multiRes[1], QUAL4, Bytes.toBytes((String)"xyz"));
        this.validateResult(multiRes[0], QUAL2, Bytes.toBytes((long)2L));
        this.validateResult(multiRes[0], QUAL3, Bytes.toBytes((long)1L));
        table.close();
    }

    @Test(timeout=300000L)
    public void testBatchWithMixedActions() throws Exception {
        LOG.info((Object)"test=testBatchWithMixedActions");
        HTable table = new HTable(UTIL.getConfiguration(), TEST_TABLE);
        Object[] results = table.batch(this.constructPutRequests());
        this.validateSizeAndEmpty(results, KEYS.length);
        ArrayList<Object> actions = new ArrayList<Object>();
        byte[] qual2 = Bytes.toBytes((String)"qual2");
        byte[] val2 = Bytes.toBytes((String)"putvalue2");
        Get get = new Get(KEYS[10]);
        get.addColumn(BYTES_FAMILY, QUALIFIER);
        actions.add(get);
        get = new Get(KEYS[11]);
        get.addColumn(BYTES_FAMILY, QUALIFIER);
        actions.add(get);
        Put put = new Put(KEYS[10]);
        put.add(BYTES_FAMILY, qual2, val2);
        actions.add(put);
        Delete delete = new Delete(KEYS[20]);
        delete.deleteFamily(BYTES_FAMILY);
        actions.add(delete);
        get = new Get(KEYS[30]);
        get.addColumn(BYTES_FAMILY, QUALIFIER);
        actions.add(get);
        put = new Put(KEYS[40]);
        put.add(BYTES_FAMILY, qual2, val2);
        actions.add(put);
        results = table.batch(actions);
        this.validateResult(results[0]);
        this.validateResult(results[1]);
        this.validateEmpty(results[2]);
        this.validateEmpty(results[3]);
        this.validateResult(results[4]);
        this.validateEmpty(results[5]);
        get = new Get(KEYS[40]);
        get.addColumn(BYTES_FAMILY, qual2);
        Result r = table.get(get);
        this.validateResult(r, qual2, val2);
        table.close();
    }

    private void validateResult(Object r) {
        this.validateResult(r, QUALIFIER, VALUE);
    }

    private void validateResult(Object r1, byte[] qual, byte[] val) {
        Result r = (Result)r1;
        Assert.assertTrue((boolean)r.containsColumn(BYTES_FAMILY, qual));
        Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])val, (byte[])r.getValue(BYTES_FAMILY, qual)));
    }

    private List<Row> constructPutRequests() {
        ArrayList<Row> puts = new ArrayList<Row>();
        for (byte[] k : KEYS) {
            Put put = new Put(k);
            put.add(BYTES_FAMILY, QUALIFIER, VALUE);
            puts.add((Row)put);
        }
        return puts;
    }

    private void validateLoadedData(HTable table) throws IOException {
        for (byte[] k : KEYS) {
            Get get = new Get(k);
            get.addColumn(BYTES_FAMILY, QUALIFIER);
            Result r = table.get(get);
            Assert.assertTrue((boolean)r.containsColumn(BYTES_FAMILY, QUALIFIER));
            Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])VALUE, (byte[])r.getValue(BYTES_FAMILY, QUALIFIER)));
        }
    }

    private void validateEmpty(Object r1) {
        Result result = (Result)r1;
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        Assert.assertTrue((result.getRow() == null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)result.raw().length);
    }

    private void validateSizeAndEmpty(Object[] results, int expectedSize) {
        Assert.assertEquals((long)expectedSize, (long)results.length);
        for (Object result : results) {
            this.validateEmpty(result);
        }
    }
}

