/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.ColumnPaginationFilter;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.DependentColumnFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.MultipleColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SkipFilter;
import org.apache.hadoop.hbase.filter.TimestampsFilter;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.util.Bytes;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestOperation {
    private static byte[] ROW = Bytes.toBytes((String)"testRow");
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
    private static byte[] VALUE = Bytes.toBytes((String)"testValue");
    private static ObjectMapper mapper = new ObjectMapper();
    private static List<Long> TS_LIST = Arrays.asList(2L, 3L, 5L);
    private static TimestampsFilter TS_FILTER = new TimestampsFilter(TS_LIST);
    private static String STR_TS_FILTER = TS_FILTER.getClass().getSimpleName() + " (3/3): [2, 3, 5]";
    private static List<Long> L_TS_LIST = Arrays.asList(0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
    private static TimestampsFilter L_TS_FILTER = new TimestampsFilter(L_TS_LIST);
    private static String STR_L_TS_FILTER = L_TS_FILTER.getClass().getSimpleName() + " (5/11): [0, 1, 2, 3, 4]";
    private static String COL_NAME_1 = "col1";
    private static ColumnPrefixFilter COL_PRE_FILTER = new ColumnPrefixFilter(COL_NAME_1.getBytes());
    private static String STR_COL_PRE_FILTER = COL_PRE_FILTER.getClass().getSimpleName() + " " + COL_NAME_1;
    private static String COL_NAME_2 = "col2";
    private static ColumnRangeFilter CR_FILTER = new ColumnRangeFilter(COL_NAME_1.getBytes(), true, COL_NAME_2.getBytes(), false);
    private static String STR_CR_FILTER = CR_FILTER.getClass().getSimpleName() + " [" + COL_NAME_1 + ", " + COL_NAME_2 + ")";
    private static int COL_COUNT = 9;
    private static ColumnCountGetFilter CCG_FILTER = new ColumnCountGetFilter(COL_COUNT);
    private static String STR_CCG_FILTER = CCG_FILTER.getClass().getSimpleName() + " " + COL_COUNT;
    private static int LIMIT = 3;
    private static int OFFSET = 4;
    private static ColumnPaginationFilter CP_FILTER = new ColumnPaginationFilter(LIMIT, OFFSET);
    private static String STR_CP_FILTER = CP_FILTER.getClass().getSimpleName() + " (" + LIMIT + ", " + OFFSET + ")";
    private static String STOP_ROW_KEY = "stop";
    private static InclusiveStopFilter IS_FILTER = new InclusiveStopFilter(STOP_ROW_KEY.getBytes());
    private static String STR_IS_FILTER = IS_FILTER.getClass().getSimpleName() + " " + STOP_ROW_KEY;
    private static String PREFIX = "prefix";
    private static PrefixFilter PREFIX_FILTER = new PrefixFilter(PREFIX.getBytes());
    private static String STR_PREFIX_FILTER = "PrefixFilter " + PREFIX;
    private static byte[][] PREFIXES = new byte[][]{"0".getBytes(), "1".getBytes(), "2".getBytes()};
    private static MultipleColumnPrefixFilter MCP_FILTER = new MultipleColumnPrefixFilter(PREFIXES);
    private static String STR_MCP_FILTER = MCP_FILTER.getClass().getSimpleName() + " (3/3): [0, 1, 2]";
    private static byte[][] L_PREFIXES = new byte[][]{"0".getBytes(), "1".getBytes(), "2".getBytes(), "3".getBytes(), "4".getBytes(), "5".getBytes(), "6".getBytes(), "7".getBytes()};
    private static MultipleColumnPrefixFilter L_MCP_FILTER = new MultipleColumnPrefixFilter(L_PREFIXES);
    private static String STR_L_MCP_FILTER = L_MCP_FILTER.getClass().getSimpleName() + " (5/8): [0, 1, 2, 3, 4]";
    private static int PAGE_SIZE = 9;
    private static PageFilter PAGE_FILTER = new PageFilter((long)PAGE_SIZE);
    private static String STR_PAGE_FILTER = PAGE_FILTER.getClass().getSimpleName() + " " + PAGE_SIZE;
    private static SkipFilter SKIP_FILTER = new SkipFilter((Filter)L_TS_FILTER);
    private static String STR_SKIP_FILTER = SKIP_FILTER.getClass().getSimpleName() + " " + STR_L_TS_FILTER;
    private static WhileMatchFilter WHILE_FILTER = new WhileMatchFilter((Filter)L_TS_FILTER);
    private static String STR_WHILE_FILTER = WHILE_FILTER.getClass().getSimpleName() + " " + STR_L_TS_FILTER;
    private static KeyOnlyFilter KEY_ONLY_FILTER = new KeyOnlyFilter();
    private static String STR_KEY_ONLY_FILTER = KEY_ONLY_FILTER.getClass().getSimpleName();
    private static FirstKeyOnlyFilter FIRST_KEY_ONLY_FILTER = new FirstKeyOnlyFilter();
    private static String STR_FIRST_KEY_ONLY_FILTER = FIRST_KEY_ONLY_FILTER.getClass().getSimpleName();
    private static CompareFilter.CompareOp CMP_OP = CompareFilter.CompareOp.EQUAL;
    private static byte[] CMP_VALUE = "value".getBytes();
    private static BinaryComparator BC = new BinaryComparator(CMP_VALUE);
    private static DependentColumnFilter DC_FILTER = new DependentColumnFilter(FAMILY, QUALIFIER, true, CMP_OP, (WritableByteArrayComparable)BC);
    private static String STR_DC_FILTER = String.format("%s (%s, %s, %s, %s, %s)", DC_FILTER.getClass().getSimpleName(), Bytes.toStringBinary((byte[])FAMILY), Bytes.toStringBinary((byte[])QUALIFIER), true, CMP_OP.name(), Bytes.toStringBinary((byte[])BC.getValue()));
    private static FamilyFilter FAMILY_FILTER = new FamilyFilter(CMP_OP, (WritableByteArrayComparable)BC);
    private static String STR_FAMILY_FILTER = FAMILY_FILTER.getClass().getSimpleName() + " (EQUAL, value)";
    private static QualifierFilter QUALIFIER_FILTER = new QualifierFilter(CMP_OP, (WritableByteArrayComparable)BC);
    private static String STR_QUALIFIER_FILTER = QUALIFIER_FILTER.getClass().getSimpleName() + " (EQUAL, value)";
    private static RowFilter ROW_FILTER = new RowFilter(CMP_OP, (WritableByteArrayComparable)BC);
    private static String STR_ROW_FILTER = ROW_FILTER.getClass().getSimpleName() + " (EQUAL, value)";
    private static ValueFilter VALUE_FILTER = new ValueFilter(CMP_OP, (WritableByteArrayComparable)BC);
    private static String STR_VALUE_FILTER = VALUE_FILTER.getClass().getSimpleName() + " (EQUAL, value)";
    private static SingleColumnValueFilter SCV_FILTER = new SingleColumnValueFilter(FAMILY, QUALIFIER, CMP_OP, CMP_VALUE);
    private static String STR_SCV_FILTER = String.format("%s (%s, %s, %s, %s)", SCV_FILTER.getClass().getSimpleName(), Bytes.toStringBinary((byte[])FAMILY), Bytes.toStringBinary((byte[])QUALIFIER), CMP_OP.name(), Bytes.toStringBinary((byte[])CMP_VALUE));
    private static SingleColumnValueExcludeFilter SCVE_FILTER = new SingleColumnValueExcludeFilter(FAMILY, QUALIFIER, CMP_OP, CMP_VALUE);
    private static String STR_SCVE_FILTER = String.format("%s (%s, %s, %s, %s)", SCVE_FILTER.getClass().getSimpleName(), Bytes.toStringBinary((byte[])FAMILY), Bytes.toStringBinary((byte[])QUALIFIER), CMP_OP.name(), Bytes.toStringBinary((byte[])CMP_VALUE));
    private static FilterList AND_FILTER_LIST = new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(TS_FILTER, L_TS_FILTER, CR_FILTER));
    private static String STR_AND_FILTER_LIST = String.format("%s AND (3/3): [%s, %s, %s]", AND_FILTER_LIST.getClass().getSimpleName(), STR_TS_FILTER, STR_L_TS_FILTER, STR_CR_FILTER);
    private static FilterList OR_FILTER_LIST = new FilterList(FilterList.Operator.MUST_PASS_ONE, Arrays.asList(TS_FILTER, L_TS_FILTER, CR_FILTER));
    private static String STR_OR_FILTER_LIST = String.format("%s OR (3/3): [%s, %s, %s]", AND_FILTER_LIST.getClass().getSimpleName(), STR_TS_FILTER, STR_L_TS_FILTER, STR_CR_FILTER);
    private static FilterList L_FILTER_LIST = new FilterList(Arrays.asList(TS_FILTER, L_TS_FILTER, CR_FILTER, COL_PRE_FILTER, CCG_FILTER, CP_FILTER, PREFIX_FILTER, PAGE_FILTER));
    private static String STR_L_FILTER_LIST = String.format("%s AND (5/8): [%s, %s, %s, %s, %s]", L_FILTER_LIST.getClass().getSimpleName(), STR_TS_FILTER, STR_L_TS_FILTER, STR_CR_FILTER, STR_COL_PRE_FILTER, STR_CCG_FILTER, STR_CP_FILTER);
    private static Filter[] FILTERS = new Filter[]{TS_FILTER, L_TS_FILTER, COL_PRE_FILTER, CP_FILTER, CR_FILTER, CCG_FILTER, IS_FILTER, PREFIX_FILTER, PAGE_FILTER, SKIP_FILTER, WHILE_FILTER, KEY_ONLY_FILTER, FIRST_KEY_ONLY_FILTER, MCP_FILTER, L_MCP_FILTER, DC_FILTER, FAMILY_FILTER, QUALIFIER_FILTER, ROW_FILTER, VALUE_FILTER, SCV_FILTER, SCVE_FILTER, AND_FILTER_LIST, OR_FILTER_LIST, L_FILTER_LIST};
    private static String[] FILTERS_INFO = new String[]{STR_TS_FILTER, STR_L_TS_FILTER, STR_COL_PRE_FILTER, STR_CP_FILTER, STR_CR_FILTER, STR_CCG_FILTER, STR_IS_FILTER, STR_PREFIX_FILTER, STR_PAGE_FILTER, STR_SKIP_FILTER, STR_WHILE_FILTER, STR_KEY_ONLY_FILTER, STR_FIRST_KEY_ONLY_FILTER, STR_MCP_FILTER, STR_L_MCP_FILTER, STR_DC_FILTER, STR_FAMILY_FILTER, STR_QUALIFIER_FILTER, STR_ROW_FILTER, STR_VALUE_FILTER, STR_SCV_FILTER, STR_SCVE_FILTER, STR_AND_FILTER_LIST, STR_OR_FILTER_LIST, STR_L_FILTER_LIST};
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Test
    public void testOperationJSON() throws IOException {
        Scan scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        String json = scan.toJSON();
        Map parsedJSON = (Map)mapper.readValue(json, HashMap.class);
        Assert.assertEquals((String)"startRow incorrect in Scan.toJSON()", (Object)Bytes.toStringBinary((byte[])ROW), parsedJSON.get("startRow"));
        List familyInfo = (List)((Map)parsedJSON.get("families")).get(Bytes.toStringBinary((byte[])FAMILY));
        Assert.assertNotNull((String)"Family absent in Scan.toJSON()", (Object)familyInfo);
        Assert.assertEquals((String)"Qualifier absent in Scan.toJSON()", (long)1L, (long)familyInfo.size());
        Assert.assertEquals((String)"Qualifier incorrect in Scan.toJSON()", (Object)Bytes.toStringBinary((byte[])QUALIFIER), familyInfo.get(0));
        Get get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        json = get.toJSON();
        parsedJSON = (Map)mapper.readValue(json, HashMap.class);
        Assert.assertEquals((String)"row incorrect in Get.toJSON()", (Object)Bytes.toStringBinary((byte[])ROW), parsedJSON.get("row"));
        familyInfo = (List)((Map)parsedJSON.get("families")).get(Bytes.toStringBinary((byte[])FAMILY));
        Assert.assertNotNull((String)"Family absent in Get.toJSON()", (Object)familyInfo);
        Assert.assertEquals((String)"Qualifier absent in Get.toJSON()", (long)1L, (long)familyInfo.size());
        Assert.assertEquals((String)"Qualifier incorrect in Get.toJSON()", (Object)Bytes.toStringBinary((byte[])QUALIFIER), familyInfo.get(0));
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, VALUE);
        json = put.toJSON();
        parsedJSON = (Map)mapper.readValue(json, HashMap.class);
        Assert.assertEquals((String)"row absent in Put.toJSON()", (Object)Bytes.toStringBinary((byte[])ROW), parsedJSON.get("row"));
        familyInfo = (List)((Map)parsedJSON.get("families")).get(Bytes.toStringBinary((byte[])FAMILY));
        Assert.assertNotNull((String)"Family absent in Put.toJSON()", (Object)familyInfo);
        Assert.assertEquals((String)"KeyValue absent in Put.toJSON()", (long)1L, (long)familyInfo.size());
        Map kvMap = (Map)familyInfo.get(0);
        Assert.assertEquals((String)"Qualifier incorrect in Put.toJSON()", (Object)Bytes.toStringBinary((byte[])QUALIFIER), kvMap.get("qualifier"));
        Assert.assertEquals((String)"Value length incorrect in Put.toJSON()", (Object)VALUE.length, kvMap.get("vlen"));
        Delete delete = new Delete(ROW);
        delete.deleteColumn(FAMILY, QUALIFIER);
        json = delete.toJSON();
        parsedJSON = (Map)mapper.readValue(json, HashMap.class);
        Assert.assertEquals((String)"row absent in Delete.toJSON()", (Object)Bytes.toStringBinary((byte[])ROW), parsedJSON.get("row"));
        familyInfo = (List)((Map)parsedJSON.get("families")).get(Bytes.toStringBinary((byte[])FAMILY));
        Assert.assertNotNull((String)"Family absent in Delete.toJSON()", (Object)familyInfo);
        Assert.assertEquals((String)"KeyValue absent in Delete.toJSON()", (long)1L, (long)familyInfo.size());
        kvMap = (Map)familyInfo.get(0);
        Assert.assertEquals((String)"Qualifier incorrect in Delete.toJSON()", (Object)Bytes.toStringBinary((byte[])QUALIFIER), kvMap.get("qualifier"));
    }

    static {
        Assert.assertEquals((String)"The sizes of static arrays do not match: [FILTERS: %d <=> FILTERS_INFO: %d]", (long)FILTERS.length, (long)FILTERS_INFO.length);
    }
}

