/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.TestRegionObserverInterface;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.Leases;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.Assert;

public class SimpleRegionObserver
extends BaseRegionObserver {
    static final Log LOG = LogFactory.getLog(TestRegionObserverInterface.class);
    boolean beforeDelete = true;
    boolean scannerOpened = false;
    boolean hadPreOpen;
    boolean hadPostOpen;
    boolean hadPreClose;
    boolean hadPostClose;
    boolean hadPreFlush;
    boolean hadPreFlushScannerOpen;
    boolean hadPostFlush;
    boolean hadPreSplit;
    boolean hadPostSplit;
    boolean hadPreCompactSelect;
    boolean hadPostCompactSelect;
    boolean hadPreCompactScanner;
    boolean hadPreCompact;
    boolean hadPostCompact;
    boolean hadPreGet = false;
    boolean hadPostGet = false;
    boolean hadPrePut = false;
    boolean hadPostPut = false;
    boolean hadPreDeleted = false;
    boolean hadPostDeleted = false;
    boolean hadPreGetClosestRowBefore = false;
    boolean hadPostGetClosestRowBefore = false;
    boolean hadPreIncrement = false;
    boolean hadPostIncrement = false;
    boolean hadPreWALRestored = false;
    boolean hadPostWALRestored = false;
    boolean hadPreScannerNext = false;
    boolean hadPostScannerNext = false;
    boolean hadPreScannerClose = false;
    boolean hadPostScannerClose = false;
    boolean hadPreScannerOpen = false;
    boolean hadPreStoreScannerOpen = false;
    boolean hadPostScannerOpen = false;
    boolean hadPreBulkLoadHFile = false;
    boolean hadPostBulkLoadHFile = false;
    boolean hadPreBatchMutate = false;
    boolean hadPostBatchMutate = false;

    public void start(CoprocessorEnvironment e) throws IOException {
        RegionCoprocessorEnvironment re = (RegionCoprocessorEnvironment)e;
        Leases leases = re.getRegionServerServices().getLeases();
        leases.createLease("x", null);
        leases.cancelLease("x");
    }

    public void preOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
        this.hadPreOpen = true;
    }

    public void postOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
        this.hadPostOpen = true;
    }

    public boolean wasOpened() {
        return this.hadPreOpen && this.hadPostOpen;
    }

    public void preClose(ObserverContext<RegionCoprocessorEnvironment> c, boolean abortRequested) {
        this.hadPreClose = true;
    }

    public void postClose(ObserverContext<RegionCoprocessorEnvironment> c, boolean abortRequested) {
        this.hadPostClose = true;
    }

    public boolean wasClosed() {
        return this.hadPreClose && this.hadPostClose;
    }

    public InternalScanner preFlush(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner) {
        this.hadPreFlush = true;
        return scanner;
    }

    public InternalScanner preFlushScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, KeyValueScanner memstoreScanner, InternalScanner s) throws IOException {
        this.hadPreFlushScannerOpen = true;
        return null;
    }

    public void postFlush(ObserverContext<RegionCoprocessorEnvironment> c, Store store, StoreFile resultFile) {
        this.hadPostFlush = true;
    }

    public boolean wasFlushed() {
        return this.hadPreFlush && this.hadPostFlush;
    }

    public void preSplit(ObserverContext<RegionCoprocessorEnvironment> c) {
        this.hadPreSplit = true;
    }

    public void postSplit(ObserverContext<RegionCoprocessorEnvironment> c, HRegion l, HRegion r) {
        this.hadPostSplit = true;
    }

    public boolean wasSplit() {
        return this.hadPreSplit && this.hadPostSplit;
    }

    public void preCompactSelection(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<StoreFile> candidates) {
        this.hadPreCompactSelect = true;
    }

    public void postCompactSelection(ObserverContext<RegionCoprocessorEnvironment> c, Store store, ImmutableList<StoreFile> selected) {
        this.hadPostCompactSelect = true;
    }

    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, InternalScanner scanner) {
        this.hadPreCompact = true;
        return scanner;
    }

    public InternalScanner preCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<? extends KeyValueScanner> scanners, ScanType scanType, long earliestPutTs, InternalScanner s) throws IOException {
        this.hadPreCompactScanner = true;
        return null;
    }

    public void postCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, StoreFile resultFile) {
        this.hadPostCompact = true;
    }

    public boolean wasCompacted() {
        return this.hadPreCompact && this.hadPostCompact;
    }

    public RegionScanner preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        this.hadPreScannerOpen = true;
        return null;
    }

    public KeyValueScanner preStoreScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, Scan scan, NavigableSet<byte[]> targetCols, KeyValueScanner s) throws IOException {
        this.hadPreStoreScannerOpen = true;
        return null;
    }

    public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        this.hadPostScannerOpen = true;
        return s;
    }

    public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> results, int limit, boolean hasMore) throws IOException {
        this.hadPreScannerNext = true;
        return hasMore;
    }

    public boolean postScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> results, int limit, boolean hasMore) throws IOException {
        this.hadPostScannerNext = true;
        return hasMore;
    }

    public void preScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.hadPreScannerClose = true;
    }

    public void postScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.hadPostScannerClose = true;
    }

    public void preGet(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<KeyValue> results) throws IOException {
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull((Object)get);
        Assert.assertNotNull(results);
        this.hadPreGet = true;
    }

    public void postGet(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<KeyValue> results) {
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull((Object)get);
        Assert.assertNotNull(results);
        if (Arrays.equals(e.getRegion().getTableDesc().getName(), TestRegionObserverInterface.TEST_TABLE)) {
            boolean foundA = false;
            boolean foundB = false;
            boolean foundC = false;
            for (KeyValue kv : results) {
                if (Bytes.equals((byte[])kv.getFamily(), (byte[])TestRegionObserverInterface.A)) {
                    foundA = true;
                }
                if (Bytes.equals((byte[])kv.getFamily(), (byte[])TestRegionObserverInterface.B)) {
                    foundB = true;
                }
                if (!Bytes.equals((byte[])kv.getFamily(), (byte[])TestRegionObserverInterface.C)) continue;
                foundC = true;
            }
            Assert.assertTrue((boolean)foundA);
            Assert.assertTrue((boolean)foundB);
            Assert.assertTrue((boolean)foundC);
        }
        this.hadPostGet = true;
    }

    public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, boolean writeToWAL) throws IOException {
        Map familyMap = put.getFamilyMap();
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull((Object)familyMap);
        if (Arrays.equals(e.getRegion().getTableDesc().getName(), TestRegionObserverInterface.TEST_TABLE)) {
            List kvs = (List)familyMap.get(TestRegionObserverInterface.A);
            Assert.assertNotNull((Object)kvs);
            Assert.assertNotNull(kvs.get(0));
            Assert.assertTrue((boolean)Bytes.equals((byte[])((KeyValue)kvs.get(0)).getQualifier(), (byte[])TestRegionObserverInterface.A));
            kvs = (List)familyMap.get(TestRegionObserverInterface.B);
            Assert.assertNotNull((Object)kvs);
            Assert.assertNotNull(kvs.get(0));
            Assert.assertTrue((boolean)Bytes.equals((byte[])((KeyValue)kvs.get(0)).getQualifier(), (byte[])TestRegionObserverInterface.B));
            kvs = (List)familyMap.get(TestRegionObserverInterface.C);
            Assert.assertNotNull((Object)kvs);
            Assert.assertNotNull(kvs.get(0));
            Assert.assertTrue((boolean)Bytes.equals((byte[])((KeyValue)kvs.get(0)).getQualifier(), (byte[])TestRegionObserverInterface.C));
        }
        this.hadPrePut = true;
    }

    public void postPut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, boolean writeToWAL) throws IOException {
        Map familyMap = put.getFamilyMap();
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull((Object)familyMap);
        List kvs = (List)familyMap.get(TestRegionObserverInterface.A);
        if (Arrays.equals(e.getRegion().getTableDesc().getName(), TestRegionObserverInterface.TEST_TABLE)) {
            Assert.assertNotNull((Object)kvs);
            Assert.assertNotNull(kvs.get(0));
            Assert.assertTrue((boolean)Bytes.equals((byte[])((KeyValue)kvs.get(0)).getQualifier(), (byte[])TestRegionObserverInterface.A));
            kvs = (List)familyMap.get(TestRegionObserverInterface.B);
            Assert.assertNotNull((Object)kvs);
            Assert.assertNotNull(kvs.get(0));
            Assert.assertTrue((boolean)Bytes.equals((byte[])((KeyValue)kvs.get(0)).getQualifier(), (byte[])TestRegionObserverInterface.B));
            kvs = (List)familyMap.get(TestRegionObserverInterface.C);
            Assert.assertNotNull((Object)kvs);
            Assert.assertNotNull(kvs.get(0));
            Assert.assertTrue((boolean)Bytes.equals((byte[])((KeyValue)kvs.get(0)).getQualifier(), (byte[])TestRegionObserverInterface.C));
        }
        this.hadPostPut = true;
    }

    public void preDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, boolean writeToWAL) throws IOException {
        Map familyMap = delete.getFamilyMap();
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull((Object)familyMap);
        if (this.beforeDelete) {
            this.hadPreDeleted = true;
        }
    }

    public void postDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, boolean writeToWAL) throws IOException {
        Map familyMap = delete.getFamilyMap();
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull((Object)familyMap);
        this.beforeDelete = false;
        this.hadPostDeleted = true;
    }

    public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Pair<Mutation, Integer>> miniBatchOp) throws IOException {
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull(miniBatchOp);
        this.hadPreBatchMutate = true;
    }

    public void postBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Pair<Mutation, Integer>> miniBatchOp) throws IOException {
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull(miniBatchOp);
        this.hadPostBatchMutate = true;
    }

    public void preGetClosestRowBefore(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, Result result) throws IOException {
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull((Object)row);
        Assert.assertNotNull((Object)result);
        if (this.beforeDelete) {
            this.hadPreGetClosestRowBefore = true;
        }
    }

    public void postGetClosestRowBefore(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, Result result) throws IOException {
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull((Object)row);
        Assert.assertNotNull((Object)result);
        this.hadPostGetClosestRowBefore = true;
    }

    public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
        this.hadPreIncrement = true;
        return null;
    }

    public Result postIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment, Result result) throws IOException {
        this.hadPostIncrement = true;
        return result;
    }

    public void preBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> familyPaths) throws IOException {
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)ctx.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        if (Arrays.equals(e.getRegion().getTableDesc().getName(), TestRegionObserverInterface.TEST_TABLE)) {
            Assert.assertNotNull(familyPaths);
            Assert.assertEquals((long)1L, (long)familyPaths.size());
            Assert.assertArrayEquals((byte[])((byte[])familyPaths.get(0).getFirst()), (byte[])TestRegionObserverInterface.A);
            String familyPath = (String)familyPaths.get(0).getSecond();
            String familyName = Bytes.toString((byte[])TestRegionObserverInterface.A);
            Assert.assertEquals((Object)familyPath.substring(familyPath.length() - familyName.length() - 1), (Object)("/" + familyName));
        }
        this.hadPreBulkLoadHFile = true;
    }

    public boolean postBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> familyPaths, boolean hasLoaded) throws IOException {
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)ctx.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        if (Arrays.equals(e.getRegion().getTableDesc().getName(), TestRegionObserverInterface.TEST_TABLE)) {
            Assert.assertNotNull(familyPaths);
            Assert.assertEquals((long)1L, (long)familyPaths.size());
            Assert.assertArrayEquals((byte[])((byte[])familyPaths.get(0).getFirst()), (byte[])TestRegionObserverInterface.A);
            String familyPath = (String)familyPaths.get(0).getSecond();
            String familyName = Bytes.toString((byte[])TestRegionObserverInterface.A);
            Assert.assertEquals((Object)familyPath.substring(familyPath.length() - familyName.length() - 1), (Object)("/" + familyName));
        }
        this.hadPostBulkLoadHFile = true;
        return hasLoaded;
    }

    public boolean hadPreGet() {
        return this.hadPreGet;
    }

    public boolean hadPostGet() {
        return this.hadPostGet;
    }

    public boolean hadPrePut() {
        return this.hadPrePut;
    }

    public boolean hadPostPut() {
        return this.hadPostPut;
    }

    public boolean hadPreBatchMutate() {
        return this.hadPreBatchMutate;
    }

    public boolean hadPostBatchMutate() {
        return this.hadPostBatchMutate;
    }

    public boolean hadDelete() {
        return !this.beforeDelete;
    }

    public boolean hadPreIncrement() {
        return this.hadPreIncrement;
    }

    public boolean hadPostIncrement() {
        return this.hadPostIncrement;
    }

    public boolean hadPreWALRestored() {
        return this.hadPreWALRestored;
    }

    public boolean hadPostWALRestored() {
        return this.hadPostWALRestored;
    }

    public boolean wasScannerNextCalled() {
        return this.hadPreScannerNext && this.hadPostScannerNext;
    }

    public boolean wasScannerCloseCalled() {
        return this.hadPreScannerClose && this.hadPostScannerClose;
    }

    public boolean wasScannerOpenCalled() {
        return this.hadPreScannerOpen && this.hadPostScannerOpen;
    }

    public boolean hadDeleted() {
        return this.hadPreDeleted && this.hadPostDeleted;
    }

    public boolean hadPostBulkLoadHFile() {
        return this.hadPostBulkLoadHFile;
    }

    public boolean hadPreBulkLoadHFile() {
        return this.hadPreBulkLoadHFile;
    }
}

