/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.SplitTransaction;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.junit.Rule;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestCoprocessorInterface
extends HBaseTestCase {
    static final Log LOG = LogFactory.getLog(TestCoprocessorInterface.class);
    static final String DIR = "test/build/data/TestCoprocessorInterface/";
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    public void testSharedData() throws IOException {
        int i;
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[][] families = new byte[][]{fam1, fam2, fam3};
        Configuration hc = this.initSplit();
        HRegion region = this.initHRegion(tableName, this.getName(), hc, new Class[0], families);
        for (int i2 = 0; i2 < 3; ++i2) {
            TestCoprocessorInterface.addContent(region, fam3);
            region.flushcache();
        }
        region.compactStores();
        byte[] splitRow = region.checkSplit();
        TestCoprocessorInterface.assertNotNull((Object)splitRow);
        HRegion[] regions = this.split(region, splitRow);
        for (int i3 = 0; i3 < regions.length; ++i3) {
            regions[i3] = this.reopenRegion(regions[i3], CoprocessorImpl.class, CoprocessorII.class);
        }
        Coprocessor c = regions[0].getCoprocessorHost().findCoprocessor(CoprocessorImpl.class.getName());
        Coprocessor c2 = regions[0].getCoprocessorHost().findCoprocessor(CoprocessorII.class.getName());
        Object o = ((CoprocessorImpl)c).getSharedData().get("test1");
        Object o2 = ((CoprocessorII)c2).getSharedData().get("test2");
        TestCoprocessorInterface.assertNotNull((Object)o);
        TestCoprocessorInterface.assertNotNull((Object)o2);
        TestCoprocessorInterface.assertFalse((((CoprocessorImpl)c).getSharedData() == ((CoprocessorII)c2).getSharedData() ? 1 : 0) != 0);
        for (i = 1; i < regions.length; ++i) {
            c = regions[i].getCoprocessorHost().findCoprocessor(CoprocessorImpl.class.getName());
            c2 = regions[i].getCoprocessorHost().findCoprocessor(CoprocessorII.class.getName());
            TestCoprocessorInterface.assertTrue((((CoprocessorImpl)c).getSharedData().get("test1") == o ? 1 : 0) != 0);
            TestCoprocessorInterface.assertTrue((((CoprocessorII)c2).getSharedData().get("test2") == o2 ? 1 : 0) != 0);
        }
        for (i = 0; i < regions.length; ++i) {
            try {
                Get g = new Get(regions[i].getStartKey());
                regions[i].get(g, null);
                TestCoprocessorInterface.fail();
            }
            catch (DoNotRetryIOException xc) {
                // empty catch block
            }
            TestCoprocessorInterface.assertNull((Object)regions[i].getCoprocessorHost().findCoprocessor(CoprocessorII.class.getName()));
        }
        c = regions[0].getCoprocessorHost().findCoprocessor(CoprocessorImpl.class.getName());
        TestCoprocessorInterface.assertTrue((((CoprocessorImpl)c).getSharedData().get("test1") == o ? 1 : 0) != 0);
        c2 = null;
        c = null;
        System.gc();
        region = this.reopenRegion(regions[0], CoprocessorImpl.class, CoprocessorII.class);
        c = region.getCoprocessorHost().findCoprocessor(CoprocessorImpl.class.getName());
        TestCoprocessorInterface.assertTrue((((CoprocessorImpl)c).getSharedData().get("test1") == o ? 1 : 0) != 0);
        c2 = region.getCoprocessorHost().findCoprocessor(CoprocessorII.class.getName());
        TestCoprocessorInterface.assertFalse((((CoprocessorII)c2).getSharedData().get("test2") == o2 ? 1 : 0) != 0);
    }

    public void testCoprocessorInterface() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[][] families = new byte[][]{fam1, fam2, fam3};
        Configuration hc = this.initSplit();
        HRegion region = this.initHRegion(tableName, this.getName(), hc, new Class[]{CoprocessorImpl.class}, families);
        for (int i = 0; i < 3; ++i) {
            TestCoprocessorInterface.addContent(region, fam3);
            region.flushcache();
        }
        region.compactStores();
        byte[] splitRow = region.checkSplit();
        TestCoprocessorInterface.assertNotNull((Object)splitRow);
        HRegion[] regions = this.split(region, splitRow);
        for (int i = 0; i < regions.length; ++i) {
            regions[i] = this.reopenRegion(regions[i], CoprocessorImpl.class);
        }
        region.close();
        region.getLog().closeAndDelete();
        Coprocessor c = region.getCoprocessorHost().findCoprocessor(CoprocessorImpl.class.getName());
        Scan s = new Scan();
        RegionScanner scanner = regions[0].getCoprocessorHost().postScannerOpen(s, regions[0].getScanner(s));
        TestCoprocessorInterface.assertTrue((boolean)(scanner instanceof CustomScanner));
        scanner.next(new ArrayList());
        TestCoprocessorInterface.assertTrue((String)"Coprocessor not started", (boolean)((CoprocessorImpl)c).wasStarted());
        TestCoprocessorInterface.assertTrue((String)"Coprocessor not stopped", (boolean)((CoprocessorImpl)c).wasStopped());
        TestCoprocessorInterface.assertTrue((boolean)((CoprocessorImpl)c).wasOpened());
        TestCoprocessorInterface.assertTrue((boolean)((CoprocessorImpl)c).wasClosed());
        TestCoprocessorInterface.assertTrue((boolean)((CoprocessorImpl)c).wasFlushed());
        TestCoprocessorInterface.assertTrue((boolean)((CoprocessorImpl)c).wasCompacted());
        TestCoprocessorInterface.assertTrue((boolean)((CoprocessorImpl)c).wasSplit());
        for (int i = 0; i < regions.length; ++i) {
            regions[i].close();
            regions[i].getLog().closeAndDelete();
            c = region.getCoprocessorHost().findCoprocessor(CoprocessorImpl.class.getName());
            TestCoprocessorInterface.assertTrue((String)"Coprocessor not started", (boolean)((CoprocessorImpl)c).wasStarted());
            TestCoprocessorInterface.assertTrue((String)"Coprocessor not stopped", (boolean)((CoprocessorImpl)c).wasStopped());
            TestCoprocessorInterface.assertTrue((boolean)((CoprocessorImpl)c).wasOpened());
            TestCoprocessorInterface.assertTrue((boolean)((CoprocessorImpl)c).wasClosed());
            TestCoprocessorInterface.assertTrue((boolean)((CoprocessorImpl)c).wasCompacted());
        }
    }

    HRegion reopenRegion(HRegion closedRegion, Class<?> ... implClasses) throws IOException {
        HRegion r = new HRegion(closedRegion.getTableDir(), closedRegion.getLog(), closedRegion.getFilesystem(), closedRegion.getConf(), closedRegion.getRegionInfo(), closedRegion.getTableDesc(), null);
        r.initialize();
        RegionCoprocessorHost host = new RegionCoprocessorHost(r, null, this.conf);
        r.setCoprocessorHost(host);
        for (Class<?> implClass : implClasses) {
            host.load(implClass, 0x3FFFFFFF, this.conf);
        }
        host.preOpen();
        host.postOpen();
        return r;
    }

    HRegion initHRegion(byte[] tableName, String callingMethod, Configuration conf, Class<?>[] implClasses, byte[][] families) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            htd.addFamily(new HColumnDescriptor(family));
        }
        HRegionInfo info = new HRegionInfo(tableName, null, null, false);
        Path path = new Path(DIR + callingMethod);
        HRegion r = HRegion.createHRegion((HRegionInfo)info, (Path)path, (Configuration)conf, (HTableDescriptor)htd);
        RegionCoprocessorHost host = new RegionCoprocessorHost(r, null, conf);
        r.setCoprocessorHost(host);
        for (Class<?> implClass : implClasses) {
            host.load(implClass, 0x3FFFFFFF, conf);
            Coprocessor c = host.findCoprocessor(implClass.getName());
            TestCoprocessorInterface.assertNotNull((Object)c);
        }
        host.preOpen();
        host.postOpen();
        return r;
    }

    Configuration initSplit() {
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compactionThreshold", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.master.lease.thread.wakefrequency", 5000);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.lease.period", 10000);
        TEST_UTIL.getConfiguration().setLong("hbase.client.pause", 15000L);
        TEST_UTIL.getConfiguration().setLong("hbase.hregion.max.filesize", 131072L);
        TEST_UTIL.getConfiguration().setBoolean("hbase.testing.nocluster", true);
        return TEST_UTIL.getConfiguration();
    }

    private HRegion[] split(HRegion r, byte[] splitRow) throws IOException {
        HRegion[] regions = new HRegion[2];
        SplitTransaction st = new SplitTransaction(r, splitRow);
        int i = 0;
        if (!st.prepare()) {
            TestCoprocessorInterface.assertTrue((boolean)false);
        }
        try {
            Server mockServer = (Server)Mockito.mock(Server.class);
            Mockito.when((Object)mockServer.getConfiguration()).thenReturn((Object)TEST_UTIL.getConfiguration());
            PairOfSameType daughters = st.execute(mockServer, null);
            Iterator i$ = daughters.iterator();
            while (i$.hasNext()) {
                HRegion each_daughter;
                regions[i] = each_daughter = (HRegion)i$.next();
                ++i;
            }
        }
        catch (IOException ioe) {
            LOG.info((Object)("Split transaction of " + r.getRegionNameAsString() + " failed:" + ioe.getMessage()));
            TestCoprocessorInterface.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            LOG.info((Object)("Failed rollback of failed split of " + r.getRegionNameAsString() + e.getMessage()));
        }
        TestCoprocessorInterface.assertTrue((i == 2 ? 1 : 0) != 0);
        return regions;
    }

    public static class CoprocessorII
    extends BaseRegionObserver {
        private ConcurrentMap<String, Object> sharedData;

        public void start(CoprocessorEnvironment e) {
            this.sharedData = ((RegionCoprocessorEnvironment)e).getSharedData();
            this.sharedData.putIfAbsent("test2", new Object());
        }

        public void stop(CoprocessorEnvironment e) {
            this.sharedData = null;
        }

        public void preGet(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<KeyValue> results) throws IOException {
            if (1 / 0 == 1) {
                e.complete();
            }
        }

        Map<String, Object> getSharedData() {
            return this.sharedData;
        }
    }

    public static class CoprocessorImpl
    extends BaseRegionObserver {
        private boolean startCalled;
        private boolean stopCalled;
        private boolean preOpenCalled;
        private boolean postOpenCalled;
        private boolean preCloseCalled;
        private boolean postCloseCalled;
        private boolean preCompactCalled;
        private boolean postCompactCalled;
        private boolean preFlushCalled;
        private boolean postFlushCalled;
        private boolean preSplitCalled;
        private boolean postSplitCalled;
        private ConcurrentMap<String, Object> sharedData;

        public void start(CoprocessorEnvironment e) {
            this.sharedData = ((RegionCoprocessorEnvironment)e).getSharedData();
            this.sharedData.putIfAbsent("test1", new Object());
            this.startCalled = true;
        }

        public void stop(CoprocessorEnvironment e) {
            this.sharedData = null;
            this.stopCalled = true;
        }

        public void preOpen(ObserverContext<RegionCoprocessorEnvironment> e) {
            this.preOpenCalled = true;
        }

        public void postOpen(ObserverContext<RegionCoprocessorEnvironment> e) {
            this.postOpenCalled = true;
        }

        public void preClose(ObserverContext<RegionCoprocessorEnvironment> e, boolean abortRequested) {
            this.preCloseCalled = true;
        }

        public void postClose(ObserverContext<RegionCoprocessorEnvironment> e, boolean abortRequested) {
            this.postCloseCalled = true;
        }

        public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, InternalScanner scanner) {
            this.preCompactCalled = true;
            return scanner;
        }

        public void postCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, StoreFile resultFile) {
            this.postCompactCalled = true;
        }

        public void preFlush(ObserverContext<RegionCoprocessorEnvironment> e) {
            this.preFlushCalled = true;
        }

        public void postFlush(ObserverContext<RegionCoprocessorEnvironment> e) {
            this.postFlushCalled = true;
        }

        public void preSplit(ObserverContext<RegionCoprocessorEnvironment> e) {
            this.preSplitCalled = true;
        }

        public void postSplit(ObserverContext<RegionCoprocessorEnvironment> e, HRegion l, HRegion r) {
            this.postSplitCalled = true;
        }

        public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan, RegionScanner s) throws IOException {
            return new CustomScanner(s);
        }

        boolean wasStarted() {
            return this.startCalled;
        }

        boolean wasStopped() {
            return this.stopCalled;
        }

        boolean wasOpened() {
            return this.preOpenCalled && this.postOpenCalled;
        }

        boolean wasClosed() {
            return this.preCloseCalled && this.postCloseCalled;
        }

        boolean wasFlushed() {
            return this.preFlushCalled && this.postFlushCalled;
        }

        boolean wasCompacted() {
            return this.preCompactCalled && this.postCompactCalled;
        }

        boolean wasSplit() {
            return this.preSplitCalled && this.postSplitCalled;
        }

        Map<String, Object> getSharedData() {
            return this.sharedData;
        }
    }

    private static class CustomScanner
    implements RegionScanner {
        private RegionScanner delegate;

        public CustomScanner(RegionScanner delegate) {
            this.delegate = delegate;
        }

        public boolean next(List<KeyValue> results) throws IOException {
            return this.delegate.next(results);
        }

        public boolean next(List<KeyValue> results, String metric) throws IOException {
            return this.delegate.next(results, metric);
        }

        public boolean next(List<KeyValue> result, int limit) throws IOException {
            return this.delegate.next(result, limit);
        }

        public boolean next(List<KeyValue> result, int limit, String metric) throws IOException {
            return this.delegate.next(result, limit, metric);
        }

        public boolean nextRaw(List<KeyValue> result, int limit, String metric) throws IOException {
            return this.delegate.nextRaw(result, limit, metric);
        }

        public boolean nextRaw(List<KeyValue> result, String metric) throws IOException {
            return this.delegate.nextRaw(result, metric);
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public HRegionInfo getRegionInfo() {
            return this.delegate.getRegionInfo();
        }

        public boolean isFilterDone() {
            return this.delegate.isFilterDone();
        }

        public boolean reseek(byte[] row) throws IOException {
            return false;
        }

        public long getMvccReadPoint() {
            return this.delegate.getMvccReadPoint();
        }
    }
}

