/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionObserverBypass {
    private static HBaseTestingUtility util;
    private static final byte[] tableName;
    private static final byte[] dummy;
    private static final byte[] row1;
    private static final byte[] row2;
    private static final byte[] row3;
    private static final byte[] test;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setStrings("hbase.coprocessor.user.region.classes", new String[]{TestCoprocessor.class.getName()});
        util = new HBaseTestingUtility(conf);
        util.startMiniCluster();
        util.createTable(tableName, new byte[][]{dummy, test});
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    @Test
    public void testSimple() throws Exception {
        HTable t = new HTable(util.getConfiguration(), tableName);
        Put p = new Put(row1);
        p.add(test, dummy, dummy);
        t.put(p);
        this.checkRowAndDelete(t, row1, 0);
        t.close();
    }

    @Test
    public void testMulti() throws Exception {
        HTable t = new HTable(util.getConfiguration(), tableName);
        ArrayList<Put> puts = new ArrayList<Put>();
        Put p = new Put(row1);
        p.add(dummy, dummy, dummy);
        puts.add(p);
        p = new Put(row2);
        p.add(test, dummy, dummy);
        puts.add(p);
        p = new Put(row3);
        p.add(test, dummy, dummy);
        puts.add(p);
        t.put(puts);
        this.checkRowAndDelete(t, row1, 1);
        this.checkRowAndDelete(t, row2, 0);
        this.checkRowAndDelete(t, row3, 0);
        puts.clear();
        p = new Put(row1);
        p.add(test, dummy, dummy);
        puts.add(p);
        p = new Put(row2);
        p.add(test, dummy, dummy);
        puts.add(p);
        p = new Put(row3);
        p.add(test, dummy, dummy);
        puts.add(p);
        t.put(puts);
        this.checkRowAndDelete(t, row1, 0);
        this.checkRowAndDelete(t, row2, 0);
        this.checkRowAndDelete(t, row3, 0);
        puts.clear();
        p = new Put(row1);
        p.add(test, dummy, dummy);
        puts.add(p);
        p = new Put(row2);
        p.add(test, dummy, dummy);
        puts.add(p);
        p = new Put(row3);
        p.add(dummy, dummy, dummy);
        puts.add(p);
        t.put(puts);
        this.checkRowAndDelete(t, row1, 0);
        this.checkRowAndDelete(t, row2, 0);
        this.checkRowAndDelete(t, row3, 1);
        puts.clear();
        p = new Put(row1);
        p.add(dummy, dummy, dummy);
        puts.add(p);
        p = new Put(row2);
        p.add(test, dummy, dummy);
        puts.add(p);
        p = new Put(row3);
        p.add(dummy, dummy, dummy);
        puts.add(p);
        t.put(puts);
        this.checkRowAndDelete(t, row1, 1);
        this.checkRowAndDelete(t, row2, 0);
        this.checkRowAndDelete(t, row3, 1);
        puts.clear();
        p = new Put(row1);
        p.add(test, dummy, dummy);
        puts.add(p);
        p = new Put(row2);
        p.add(dummy, dummy, dummy);
        puts.add(p);
        p = new Put(row3);
        p.add(test, dummy, dummy);
        puts.add(p);
        t.put(puts);
        this.checkRowAndDelete(t, row1, 0);
        this.checkRowAndDelete(t, row2, 1);
        this.checkRowAndDelete(t, row3, 0);
        t.close();
    }

    private void checkRowAndDelete(HTable t, byte[] row, int count) throws IOException {
        Get g = new Get(row);
        Result r = t.get(g);
        Assert.assertEquals((long)count, (long)r.size());
        Delete d = new Delete(row);
        t.delete(d);
    }

    static {
        tableName = Bytes.toBytes((String)"test");
        dummy = Bytes.toBytes((String)"dummy");
        row1 = Bytes.toBytes((String)"r1");
        row2 = Bytes.toBytes((String)"r2");
        row3 = Bytes.toBytes((String)"r3");
        test = Bytes.toBytes((String)"test");
    }

    public static class TestCoprocessor
    extends BaseRegionObserver {
        public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, boolean writeToWAL) throws IOException {
            Map familyMap = put.getFamilyMap();
            if (familyMap.containsKey(test)) {
                e.bypass();
            }
        }
    }
}

