/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestRegionObserverStacking
extends TestCase {
    static final String DIR = "test/build/data/TestRegionObserverStacking/";
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    HRegion initHRegion(byte[] tableName, String callingMethod, Configuration conf, byte[] ... families) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            htd.addFamily(new HColumnDescriptor(family));
        }
        HRegionInfo info = new HRegionInfo(htd.getName(), null, null, false);
        Path path = new Path(DIR + callingMethod);
        HRegion r = HRegion.createHRegion((HRegionInfo)info, (Path)path, (Configuration)conf, (HTableDescriptor)htd);
        RegionCoprocessorHost host = new RegionCoprocessorHost(r, null, conf);
        r.setCoprocessorHost(host);
        return r;
    }

    public void testRegionObserverStacking() throws Exception {
        byte[] ROW = Bytes.toBytes((String)"testRow");
        byte[] TABLE = Bytes.toBytes((String)((Object)((Object)this)).getClass().getName());
        byte[] A2 = Bytes.toBytes((String)"A");
        byte[][] FAMILIES = new byte[][]{A2};
        Configuration conf = HBaseConfiguration.create();
        HRegion region = this.initHRegion(TABLE, ((Object)((Object)this)).getClass().getName(), conf, FAMILIES);
        RegionCoprocessorHost h = region.getCoprocessorHost();
        h.load(ObserverA.class, 0, conf);
        h.load(ObserverB.class, 0x3FFFFFFF, conf);
        h.load(ObserverC.class, Integer.MAX_VALUE, conf);
        Put put = new Put(ROW);
        put.add(A2, A2, A2);
        int lockid = region.obtainRowLock(ROW);
        region.put(put, Integer.valueOf(lockid));
        region.releaseRowLock(Integer.valueOf(lockid));
        Coprocessor c = h.findCoprocessor(ObserverA.class.getName());
        long idA = ((ObserverA)c).id;
        c = h.findCoprocessor(ObserverB.class.getName());
        long idB = ((ObserverB)c).id;
        c = h.findCoprocessor(ObserverC.class.getName());
        long idC = ((ObserverC)c).id;
        TestRegionObserverStacking.assertTrue((idA < idB ? 1 : 0) != 0);
        TestRegionObserverStacking.assertTrue((idB < idC ? 1 : 0) != 0);
    }

    public static class ObserverC
    extends BaseRegionObserver {
        long id;

        public void postPut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, boolean writeToWAL) throws IOException {
            this.id = System.currentTimeMillis();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
    }

    public static class ObserverB
    extends BaseRegionObserver {
        long id;

        public void postPut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, boolean writeToWAL) throws IOException {
            this.id = System.currentTimeMillis();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
    }

    public static class ObserverA
    extends BaseRegionObserver {
        long id;

        public void postPut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, boolean writeToWAL) throws IOException {
            this.id = System.currentTimeMillis();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
    }
}

