/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.errorhandling;

import com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestForeignExceptionSerialization {
    private static final String srcName = "someNode";

    @Test
    public void testSimpleException() throws InvalidProtocolBufferException {
        String data = "some bytes";
        ForeignException in = new ForeignException("SRC", (Throwable)new IllegalArgumentException(data));
        ForeignException e = ForeignException.deserialize((byte[])ForeignException.serialize((String)srcName, (Throwable)in));
        Assert.assertNotNull((Object)((Object)e));
        StackTraceElement elem = new StackTraceElement(this.getClass().toString(), "method", "file", 1);
        in.setStackTrace(new StackTraceElement[]{elem});
        e = ForeignException.deserialize((byte[])ForeignException.serialize((String)srcName, (Throwable)in));
        Assert.assertNotNull((Object)((Object)e));
        Assert.assertEquals((String)"Stack trace got corrupted", (Object)elem, (Object)e.getCause().getStackTrace()[0]);
        Assert.assertEquals((String)"Got an unexpectedly long stack trace", (long)1L, (long)e.getCause().getStackTrace().length);
    }

    @Test
    public void testRemoteFromLocal() throws InvalidProtocolBufferException {
        String errorMsg = "some message";
        Exception generic = new Exception(errorMsg);
        generic.printStackTrace();
        Assert.assertTrue((boolean)generic.getMessage().contains(errorMsg));
        ForeignException e = ForeignException.deserialize((byte[])ForeignException.serialize((String)srcName, (Throwable)generic));
        Assert.assertArrayEquals((String)"Local stack trace got corrupted", (Object[])generic.getStackTrace(), (Object[])e.getCause().getStackTrace());
        e.printStackTrace();
        Assert.assertTrue((e.getCause().getCause() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)e.getCause().getMessage().contains(errorMsg));
    }
}

