/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.filter.ColumnPaginationFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestColumnPaginationFilter
extends TestCase {
    private static final byte[] ROW = Bytes.toBytes((String)"row_1_test");
    private static final byte[] COLUMN_FAMILY = Bytes.toBytes((String)"test");
    private static final byte[] VAL_1 = Bytes.toBytes((String)"a");
    private static final byte[] COLUMN_QUALIFIER = Bytes.toBytes((String)"foo");
    private Filter columnPaginationFilter;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    protected void setUp() throws Exception {
        super.setUp();
        this.columnPaginationFilter = this.getColumnPaginationFilter();
    }

    private Filter getColumnPaginationFilter() {
        return new ColumnPaginationFilter(1, 0);
    }

    private Filter serializationTest(Filter filter) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(stream);
        filter.write((DataOutput)out);
        out.close();
        byte[] buffer = stream.toByteArray();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buffer));
        ColumnPaginationFilter newFilter = new ColumnPaginationFilter();
        newFilter.readFields((DataInput)in);
        return newFilter;
    }

    private void basicFilterTests(ColumnPaginationFilter filter) throws Exception {
        KeyValue kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, VAL_1);
        TestColumnPaginationFilter.assertTrue((String)"basicFilter1", (filter.filterKeyValue(kv) == Filter.ReturnCode.INCLUDE_AND_NEXT_COL ? 1 : 0) != 0);
    }

    public void testSerialization() throws Exception {
        Filter newFilter = this.serializationTest(this.columnPaginationFilter);
        this.basicFilterTests((ColumnPaginationFilter)newFilter);
    }
}

