/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.filter.FuzzyRowFilter;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestFuzzyRowFilter {
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Test
    public void testSatisfies() {
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfies((byte[])new byte[]{1, -128, 0, 0, 1}, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.YES, (Object)FuzzyRowFilter.satisfies((byte[])new byte[]{1, -128, 1, 0, 1}, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfies((byte[])new byte[]{1, -128, 2, 0, 1}, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NO_NEXT, (Object)FuzzyRowFilter.satisfies((byte[])new byte[]{2, 3, 1, 1, 1}, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.YES, (Object)FuzzyRowFilter.satisfies((byte[])new byte[]{1, 2, 1, 3, 3}, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{0, 0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfies((byte[])new byte[]{1, 1, 1, 3, 0}, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{0, 0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfies((byte[])new byte[]{1, 1, 1, 3, 0}, (byte[])new byte[]{1, -11, 0, 3}, (byte[])new byte[]{0, 0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NO_NEXT, (Object)FuzzyRowFilter.satisfies((byte[])new byte[]{1, -11, 1, 3, 0}, (byte[])new byte[]{1, 1, 0, 3}, (byte[])new byte[]{0, 0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NO_NEXT, (Object)FuzzyRowFilter.satisfies((byte[])new byte[]{1, 3, 1, 3, 0}, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{0, 0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NO_NEXT, (Object)FuzzyRowFilter.satisfies((byte[])new byte[]{2, 1, 1, 1, 0}, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{0, 0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfies((byte[])new byte[]{1, 2, 1, 0, 1}, (byte[])new byte[]{0, 1, 2}, (byte[])new byte[]{1, 0, 0}));
    }

    @Test
    public void testGetNextForFuzzyRule() {
        this.assertNext(new byte[]{0, 1, 2}, new byte[]{1, 0, 0}, new byte[]{1, 2, 1, 0, 1}, new byte[]{2, 1, 2, 0, 0});
        this.assertNext(new byte[]{0, 1, 2}, new byte[]{1, 0, 0}, new byte[]{1, 1, 2, 0, 1}, new byte[]{1, 1, 2, 0, 2});
        this.assertNext(new byte[]{0, 1, 0, 2, 0}, new byte[]{1, 0, 1, 0, 1}, new byte[]{1, 0, 2, 0, 1}, new byte[]{1, 1, 0, 2, 0});
        this.assertNext(new byte[]{1, 0, 1}, new byte[]{0, 1, 0}, new byte[]{1, -128, 2, 0, 1}, new byte[]{1, -127, 1, 0, 0});
        this.assertNext(new byte[]{0, 1, 0, 1}, new byte[]{1, 0, 1, 0}, new byte[]{5, 1, 0, 1}, new byte[]{5, 1, 1, 1});
        this.assertNext(new byte[]{0, 1, 0, 1}, new byte[]{1, 0, 1, 0}, new byte[]{5, 1, 0, 1, 1}, new byte[]{5, 1, 0, 1, 2});
        this.assertNext(new byte[]{0, 1, 0, 0}, new byte[]{1, 0, 1, 1}, new byte[]{5, 1, -1, 1}, new byte[]{5, 1, -1, 2});
        this.assertNext(new byte[]{0, 1, 0, 1}, new byte[]{1, 0, 1, 0}, new byte[]{5, 1, -1, 1}, new byte[]{6, 1, 0, 1});
        this.assertNext(new byte[]{0, 1, 0, 1}, new byte[]{1, 0, 1, 0}, new byte[]{5, 1, -1, 0}, new byte[]{5, 1, -1, 1});
        this.assertNext(new byte[]{5, 1, 1, 0}, new byte[]{0, 0, 1, 1}, new byte[]{5, 1, -1, 1}, new byte[]{5, 1, -1, 2});
        this.assertNext(new byte[]{1, 1, 1, 1}, new byte[]{0, 0, 1, 1}, new byte[]{1, 1, 2, 2}, new byte[]{1, 1, 2, 3});
        this.assertNext(new byte[]{1, 1, 1, 1}, new byte[]{0, 0, 1, 1}, new byte[]{1, 1, 3, 2}, new byte[]{1, 1, 3, 3});
        this.assertNext(new byte[]{1, 1, 1, 1}, new byte[]{1, 1, 1, 1}, new byte[]{1, 1, 2, 3}, new byte[]{1, 1, 2, 4});
        this.assertNext(new byte[]{1, 1, 1, 1}, new byte[]{1, 1, 1, 1}, new byte[]{1, 1, 3, 2}, new byte[]{1, 1, 3, 3});
        this.assertNext(new byte[]{1, 1, 0, 0}, new byte[]{0, 0, 1, 1}, new byte[]{0, 1, 3, 2}, new byte[]{1, 1, 0, 0});
        Assert.assertNull((Object)FuzzyRowFilter.getNextForFuzzyRule((byte[])new byte[]{2, 3, 1, 1, 1}, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{0, 1, 0}));
        Assert.assertNull((Object)FuzzyRowFilter.getNextForFuzzyRule((byte[])new byte[]{1, -11, 1, 3, 0}, (byte[])new byte[]{1, 1, 0, 3}, (byte[])new byte[]{0, 0, 1, 0}));
        Assert.assertNull((Object)FuzzyRowFilter.getNextForFuzzyRule((byte[])new byte[]{1, 3, 1, 3, 0}, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{0, 0, 1, 0}));
        Assert.assertNull((Object)FuzzyRowFilter.getNextForFuzzyRule((byte[])new byte[]{2, 1, 1, 1, 0}, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{0, 0, 1, 0}));
    }

    private void assertNext(byte[] fuzzyRow, byte[] mask, byte[] current, byte[] expected) {
        byte[] nextForFuzzyRule = FuzzyRowFilter.getNextForFuzzyRule((byte[])current, (byte[])fuzzyRow, (byte[])mask);
        Assert.assertArrayEquals((byte[])expected, (byte[])nextForFuzzyRule);
    }
}

