/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.filter.RandomRowFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestRandomRowFilter
extends TestCase {
    protected RandomRowFilter quarterChanceFilter;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    protected void setUp() throws Exception {
        super.setUp();
        this.quarterChanceFilter = new RandomRowFilter(0.25f);
    }

    public void testBasics() throws Exception {
        int included = 0;
        int max = 1000000;
        for (int i = 0; i < max; ++i) {
            if (this.quarterChanceFilter.filterRowKey(Bytes.toBytes((String)"row"), 0, Bytes.toBytes((String)"row").length)) continue;
            ++included;
        }
        int epsilon = max / 100;
        TestRandomRowFilter.assertTrue((String)"Roughly 25% should pass the filter", (Math.abs(included - max / 4) < epsilon ? 1 : 0) != 0);
    }

    public void testSerialization() throws Exception {
        RandomRowFilter newFilter = this.serializationTest(this.quarterChanceFilter);
        TestRandomRowFilter.assertTrue((String)"float should be equal", (Math.abs(newFilter.getChance() - this.quarterChanceFilter.getChance()) < 1.0E-6f ? 1 : 0) != 0);
    }

    private RandomRowFilter serializationTest(RandomRowFilter filter) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(stream);
        filter.write((DataOutput)out);
        out.close();
        byte[] buffer = stream.toByteArray();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buffer));
        RandomRowFilter newFilter = new RandomRowFilter();
        newFilter.readFields((DataInput)in);
        return newFilter;
    }
}

