/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSingleColumnValueFilter
extends TestCase {
    private static final byte[] ROW = Bytes.toBytes((String)"test");
    private static final byte[] COLUMN_FAMILY = Bytes.toBytes((String)"test");
    private static final byte[] COLUMN_QUALIFIER = Bytes.toBytes((String)"foo");
    private static final byte[] VAL_1 = Bytes.toBytes((String)"a");
    private static final byte[] VAL_2 = Bytes.toBytes((String)"ab");
    private static final byte[] VAL_3 = Bytes.toBytes((String)"abc");
    private static final byte[] VAL_4 = Bytes.toBytes((String)"abcd");
    private static final byte[] FULLSTRING_1 = Bytes.toBytes((String)"The quick brown fox jumps over the lazy dog.");
    private static final byte[] FULLSTRING_2 = Bytes.toBytes((String)"The slow grey fox trips over the lazy dog.");
    private static final String QUICK_SUBSTR = "quick";
    private static final String QUICK_REGEX = ".+quick.+";
    Filter basicFilter;
    Filter substrFilter;
    Filter regexFilter;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    protected void setUp() throws Exception {
        super.setUp();
        this.basicFilter = this.basicFilterNew();
        this.substrFilter = this.substrFilterNew();
        this.regexFilter = this.regexFilterNew();
    }

    private Filter basicFilterNew() {
        return new SingleColumnValueFilter(COLUMN_FAMILY, COLUMN_QUALIFIER, CompareFilter.CompareOp.GREATER_OR_EQUAL, VAL_2);
    }

    private Filter substrFilterNew() {
        return new SingleColumnValueFilter(COLUMN_FAMILY, COLUMN_QUALIFIER, CompareFilter.CompareOp.EQUAL, (WritableByteArrayComparable)new SubstringComparator(QUICK_SUBSTR));
    }

    private Filter regexFilterNew() {
        return new SingleColumnValueFilter(COLUMN_FAMILY, COLUMN_QUALIFIER, CompareFilter.CompareOp.EQUAL, (WritableByteArrayComparable)new RegexStringComparator(QUICK_REGEX));
    }

    private void basicFilterTests(SingleColumnValueFilter filter) throws Exception {
        KeyValue kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, VAL_2);
        TestSingleColumnValueFilter.assertTrue((String)"basicFilter1", (filter.filterKeyValue(kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, VAL_3);
        TestSingleColumnValueFilter.assertTrue((String)"basicFilter2", (filter.filterKeyValue(kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, VAL_4);
        TestSingleColumnValueFilter.assertTrue((String)"basicFilter3", (filter.filterKeyValue(kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        TestSingleColumnValueFilter.assertFalse((String)"basicFilterNotNull", (boolean)filter.filterRow());
        filter.reset();
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, VAL_1);
        TestSingleColumnValueFilter.assertTrue((String)"basicFilter4", (filter.filterKeyValue(kv) == Filter.ReturnCode.NEXT_ROW ? 1 : 0) != 0);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, VAL_2);
        TestSingleColumnValueFilter.assertTrue((String)"basicFilter4", (filter.filterKeyValue(kv) == Filter.ReturnCode.NEXT_ROW ? 1 : 0) != 0);
        TestSingleColumnValueFilter.assertFalse((String)"basicFilterAllRemaining", (boolean)filter.filterAllRemaining());
        TestSingleColumnValueFilter.assertTrue((String)"basicFilterNotNull", (boolean)filter.filterRow());
        filter.reset();
        filter.setLatestVersionOnly(false);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, VAL_1);
        TestSingleColumnValueFilter.assertTrue((String)"basicFilter5", (filter.filterKeyValue(kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, VAL_2);
        TestSingleColumnValueFilter.assertTrue((String)"basicFilter5", (filter.filterKeyValue(kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        TestSingleColumnValueFilter.assertFalse((String)"basicFilterNotNull", (boolean)filter.filterRow());
    }

    private void substrFilterTests(Filter filter) throws Exception {
        KeyValue kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, FULLSTRING_1);
        TestSingleColumnValueFilter.assertTrue((String)"substrTrue", (filter.filterKeyValue(kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, FULLSTRING_2);
        TestSingleColumnValueFilter.assertTrue((String)"substrFalse", (filter.filterKeyValue(kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        TestSingleColumnValueFilter.assertFalse((String)"substrFilterAllRemaining", (boolean)filter.filterAllRemaining());
        TestSingleColumnValueFilter.assertFalse((String)"substrFilterNotNull", (boolean)filter.filterRow());
    }

    private void regexFilterTests(Filter filter) throws Exception {
        KeyValue kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, FULLSTRING_1);
        TestSingleColumnValueFilter.assertTrue((String)"regexTrue", (filter.filterKeyValue(kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, FULLSTRING_2);
        TestSingleColumnValueFilter.assertTrue((String)"regexFalse", (filter.filterKeyValue(kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        TestSingleColumnValueFilter.assertFalse((String)"regexFilterAllRemaining", (boolean)filter.filterAllRemaining());
        TestSingleColumnValueFilter.assertFalse((String)"regexFilterNotNull", (boolean)filter.filterRow());
    }

    private Filter serializationTest(Filter filter) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(stream);
        filter.write((DataOutput)out);
        out.close();
        byte[] buffer = stream.toByteArray();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buffer));
        SingleColumnValueFilter newFilter = new SingleColumnValueFilter();
        newFilter.readFields((DataInput)in);
        return newFilter;
    }

    public void testStop() throws Exception {
        this.basicFilterTests((SingleColumnValueFilter)this.basicFilter);
        this.substrFilterTests(this.substrFilter);
        this.regexFilterTests(this.regexFilter);
    }

    public void testSerialization() throws Exception {
        Filter newFilter = this.serializationTest(this.basicFilter);
        this.basicFilterTests((SingleColumnValueFilter)newFilter);
        newFilter = this.serializationTest(this.substrFilter);
        this.substrFilterTests(newFilter);
        newFilter = this.serializationTest(this.regexFilter);
        this.regexFilterTests(newFilter);
    }
}

