/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.io.WritableUtils;

public class RedundantKVGenerator {
    static int DEFAULT_NUMBER_OF_ROW_PREFIXES = 10;
    static int DEFAULT_AVERAGE_PREFIX_LENGTH = 6;
    static int DEFAULT_PREFIX_LENGTH_VARIANCE = 3;
    static int DEFAULT_AVERAGE_SUFFIX_LENGTH = 3;
    static int DEFAULT_SUFFIX_LENGTH_VARIANCE = 3;
    static int DEFAULT_NUMBER_OF_ROW = 500;
    static float DEFAULT_CHANCE_FOR_SAME_QUALIFIER = 0.5f;
    static float DEFAULT_CHANCE_FOR_SIMILIAR_QUALIFIER = 0.4f;
    static int DEFAULT_AVERAGE_QUALIFIER_LENGTH = 9;
    static int DEFAULT_QUALIFIER_LENGTH_VARIANCE = 3;
    static int DEFAULT_COLUMN_FAMILY_LENGTH = 9;
    static int DEFAULT_VALUE_LENGTH = 8;
    static float DEFAULT_CHANCE_FOR_ZERO_VALUE = 0.5f;
    static int DEFAULT_BASE_TIMESTAMP_DIVIDE = 1000000;
    static int DEFAULT_TIMESTAMP_DIFF_SIZE = 100000000;
    private Random randomizer;
    private int numberOfRowPrefixes;
    private int averagePrefixLength = 6;
    private int prefixLengthVariance = 3;
    private int averageSuffixLength = 3;
    private int suffixLengthVariance = 3;
    private int numberOfRows = 500;
    private float chanceForSameQualifier = 0.5f;
    private float chanceForSimiliarQualifier = 0.4f;
    private int averageQualifierLength = 9;
    private int qualifierLengthVariance = 3;
    private int columnFamilyLength = 9;
    private int valueLength = 8;
    private float chanceForZeroValue = 0.5f;
    private int baseTimestampDivide = 1000000;
    private int timestampDiffSize = 100000000;

    public RedundantKVGenerator() {
        this(new Random(42L), DEFAULT_NUMBER_OF_ROW_PREFIXES, DEFAULT_AVERAGE_PREFIX_LENGTH, DEFAULT_PREFIX_LENGTH_VARIANCE, DEFAULT_AVERAGE_SUFFIX_LENGTH, DEFAULT_SUFFIX_LENGTH_VARIANCE, DEFAULT_NUMBER_OF_ROW, DEFAULT_CHANCE_FOR_SAME_QUALIFIER, DEFAULT_CHANCE_FOR_SIMILIAR_QUALIFIER, DEFAULT_AVERAGE_QUALIFIER_LENGTH, DEFAULT_QUALIFIER_LENGTH_VARIANCE, DEFAULT_COLUMN_FAMILY_LENGTH, DEFAULT_VALUE_LENGTH, DEFAULT_CHANCE_FOR_ZERO_VALUE, DEFAULT_BASE_TIMESTAMP_DIVIDE, DEFAULT_TIMESTAMP_DIFF_SIZE);
    }

    public RedundantKVGenerator(Random randomizer, int numberOfRowPrefixes, int averagePrefixLength, int prefixLengthVariance, int averageSuffixLength, int suffixLengthVariance, int numberOfRows, float chanceForSameQualifier, float chanceForSimiliarQualifier, int averageQualifierLength, int qualifierLengthVariance, int columnFamilyLength, int valueLength, float chanceForZeroValue, int baseTimestampDivide, int timestampDiffSize) {
        this.randomizer = randomizer;
        this.numberOfRowPrefixes = numberOfRowPrefixes;
        this.averagePrefixLength = averagePrefixLength;
        this.prefixLengthVariance = prefixLengthVariance;
        this.averageSuffixLength = averageSuffixLength;
        this.suffixLengthVariance = suffixLengthVariance;
        this.numberOfRows = numberOfRows;
        this.chanceForSameQualifier = chanceForSameQualifier;
        this.chanceForSimiliarQualifier = chanceForSimiliarQualifier;
        this.averageQualifierLength = averageQualifierLength;
        this.qualifierLengthVariance = qualifierLengthVariance;
        this.columnFamilyLength = columnFamilyLength;
        this.valueLength = valueLength;
        this.chanceForZeroValue = chanceForZeroValue;
        this.baseTimestampDivide = baseTimestampDivide;
        this.timestampDiffSize = timestampDiffSize;
    }

    private List<byte[]> generateRows() {
        ArrayList<byte[]> prefixes = new ArrayList<byte[]>();
        prefixes.add(new byte[0]);
        for (int i = 1; i < this.numberOfRowPrefixes; ++i) {
            int prefixLength = this.averagePrefixLength;
            byte[] newPrefix = new byte[prefixLength += this.randomizer.nextInt(2 * this.prefixLengthVariance + 1) - this.prefixLengthVariance];
            this.randomizer.nextBytes(newPrefix);
            prefixes.add(newPrefix);
        }
        ArrayList<byte[]> rows = new ArrayList<byte[]>();
        for (int i = 0; i < this.numberOfRows; ++i) {
            int suffixLength = this.averageSuffixLength;
            int randomPrefix = this.randomizer.nextInt(prefixes.size());
            byte[] row = new byte[((byte[])prefixes.get(randomPrefix)).length + (suffixLength += this.randomizer.nextInt(2 * this.suffixLengthVariance + 1) - this.suffixLengthVariance)];
            rows.add(row);
        }
        return rows;
    }

    public List<KeyValue> generateTestKeyValues(int howMany) {
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        List<byte[]> rows = this.generateRows();
        HashMap rowsToQualifier = new HashMap();
        byte[] family = new byte[this.columnFamilyLength];
        this.randomizer.nextBytes(family);
        long baseTimestamp = Math.abs(this.randomizer.nextLong()) / (long)this.baseTimestampDivide;
        byte[] value = new byte[this.valueLength];
        for (int i = 0; i < howMany; ++i) {
            byte[] qualifier;
            long timestamp = baseTimestamp + (long)this.randomizer.nextInt(this.timestampDiffSize);
            Integer rowId = this.randomizer.nextInt(rows.size());
            byte[] row = rows.get(rowId);
            float qualifierChance = this.randomizer.nextFloat();
            if (!rowsToQualifier.containsKey(rowId) || qualifierChance > this.chanceForSameQualifier + this.chanceForSimiliarQualifier) {
                int qualifierLength = this.averageQualifierLength;
                qualifier = new byte[qualifierLength += this.randomizer.nextInt(2 * this.qualifierLengthVariance + 1) - this.qualifierLengthVariance];
                this.randomizer.nextBytes(qualifier);
                if (!rowsToQualifier.containsKey(rowId)) {
                    rowsToQualifier.put(rowId, new ArrayList());
                }
                ((List)rowsToQualifier.get(rowId)).add(qualifier);
            } else if (qualifierChance > this.chanceForSameQualifier) {
                List previousQualifiers = (List)rowsToQualifier.get(rowId);
                byte[] originalQualifier = (byte[])previousQualifiers.get(this.randomizer.nextInt(previousQualifiers.size()));
                qualifier = new byte[originalQualifier.length];
                int commonPrefix = this.randomizer.nextInt(qualifier.length);
                System.arraycopy(originalQualifier, 0, qualifier, 0, commonPrefix);
                for (int j = commonPrefix; j < qualifier.length; ++j) {
                    qualifier[j] = (byte)(this.randomizer.nextInt() & 0xFF);
                }
                ((List)rowsToQualifier.get(rowId)).add(qualifier);
            } else {
                List previousQualifiers = (List)rowsToQualifier.get(rowId);
                qualifier = (byte[])previousQualifiers.get(this.randomizer.nextInt(previousQualifiers.size()));
            }
            if (this.randomizer.nextFloat() < this.chanceForZeroValue) {
                for (int j = 0; j < value.length; ++j) {
                    value[j] = 0;
                }
            } else {
                this.randomizer.nextBytes(value);
            }
            result.add(new KeyValue(row, family, qualifier, timestamp, value));
        }
        Collections.sort(result, KeyValue.COMPARATOR);
        return result;
    }

    public static ByteBuffer convertKvToByteBuffer(List<KeyValue> keyValues, boolean includesMemstoreTS) {
        int totalSize = 0;
        for (KeyValue kv : keyValues) {
            totalSize += kv.getLength();
            if (!includesMemstoreTS) continue;
            totalSize += WritableUtils.getVIntSize((long)kv.getMemstoreTS());
        }
        ByteBuffer result = ByteBuffer.allocate(totalSize);
        for (KeyValue kv : keyValues) {
            result.put(kv.getBuffer(), kv.getOffset(), kv.getLength());
            if (!includesMemstoreTS) continue;
            ByteBufferUtils.writeVLong((ByteBuffer)result, (long)kv.getMemstoreTS());
        }
        return result;
    }
}

