/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.ipc.Delayable;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.HBaseServer;
import org.apache.hadoop.hbase.ipc.ProtocolSignature;
import org.apache.hadoop.hbase.ipc.RpcCallContext;
import org.apache.hadoop.hbase.ipc.RpcEngine;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.VersionedProtocol;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestDelayedRpc {
    public static RpcServer rpcServer;
    public static final int UNDELAYED = 0;
    public static final int DELAYED = 1;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Test
    public void testDelayedRpcImmediateReturnValue() throws Exception {
        this.testDelayedRpc(false);
    }

    @Test
    public void testDelayedRpcDelayedReturnValue() throws Exception {
        this.testDelayedRpc(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDelayedRpc(boolean delayReturnValue) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        InetSocketAddress isa = new InetSocketAddress("localhost", 0);
        rpcServer = HBaseRPC.getServer((Object)new TestRpcImpl(delayReturnValue), (Class[])new Class[]{TestRpcImpl.class}, (String)isa.getHostName(), (int)isa.getPort(), (int)1, (int)0, (boolean)true, (Configuration)conf, (int)0);
        RpcEngine rpcEngine = null;
        try {
            rpcServer.start();
            rpcEngine = HBaseRPC.getProtocolEngine((Configuration)conf);
            TestRpc client = (TestRpc)rpcEngine.getProxy(TestRpc.class, 0L, rpcServer.getListenerAddress(), conf, 1000);
            ArrayList<Integer> results = new ArrayList<Integer>();
            TestThread th1 = new TestThread(client, true, results);
            TestThread th2 = new TestThread(client, false, results);
            TestThread th3 = new TestThread(client, false, results);
            th1.start();
            Thread.sleep(100L);
            th2.start();
            Thread.sleep(200L);
            th3.start();
            th1.join();
            th2.join();
            th3.join();
            Assert.assertEquals((long)0L, (long)((Integer)results.get(0)).intValue());
            Assert.assertEquals((long)0L, (long)((Integer)results.get(1)).intValue());
            Assert.assertEquals((long)((Integer)results.get(2)).intValue(), (long)(delayReturnValue ? 1L : -559038737L));
        }
        finally {
            if (rpcEngine != null) {
                rpcEngine.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTooManyDelayedRpcs() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int MAX_DELAYED_RPC = 10;
        conf.setInt("hbase.ipc.warn.delayedrpc.number", 10);
        ListAppender listAppender = new ListAppender();
        Logger log = Logger.getLogger((String)"org.apache.hadoop.ipc.HBaseServer");
        log.addAppender((Appender)listAppender);
        log.setLevel(Level.WARN);
        InetSocketAddress isa = new InetSocketAddress("localhost", 0);
        rpcServer = HBaseRPC.getServer((Object)new TestRpcImpl(true), (Class[])new Class[]{TestRpcImpl.class}, (String)isa.getHostName(), (int)isa.getPort(), (int)1, (int)0, (boolean)true, (Configuration)conf, (int)0);
        RpcEngine rpcEngine = null;
        try {
            int i;
            rpcServer.start();
            rpcEngine = HBaseRPC.getProtocolEngine((Configuration)conf);
            TestRpc client = (TestRpc)rpcEngine.getProxy(TestRpc.class, 0L, rpcServer.getListenerAddress(), conf, 1000);
            Thread[] threads = new Thread[11];
            for (i = 0; i < 10; ++i) {
                threads[i] = new TestThread(client, true, null);
                threads[i].start();
            }
            Assert.assertTrue((boolean)listAppender.getMessages().isEmpty());
            threads[10] = new TestThread(client, true, null);
            threads[10].start();
            for (i = 0; i < 10; ++i) {
                threads[i].join();
            }
            Assert.assertFalse((boolean)listAppender.getMessages().isEmpty());
            Assert.assertTrue((boolean)listAppender.getMessages().get(0).startsWith("Too many delayed calls"));
            log.removeAppender((Appender)listAppender);
        }
        finally {
            if (rpcEngine != null) {
                rpcEngine.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEndDelayThrowing() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        InetSocketAddress isa = new InetSocketAddress("localhost", 0);
        rpcServer = HBaseRPC.getServer((Object)new FaultyTestRpc(), (Class[])new Class[]{TestRpcImpl.class}, (String)isa.getHostName(), (int)isa.getPort(), (int)1, (int)0, (boolean)true, (Configuration)conf, (int)0);
        RpcEngine rpcEngine = null;
        try {
            boolean caughtException;
            block8: {
                rpcServer.start();
                rpcEngine = HBaseRPC.getProtocolEngine((Configuration)conf);
                TestRpc client = (TestRpc)rpcEngine.getProxy(TestRpc.class, 0L, rpcServer.getListenerAddress(), conf, 1000);
                int result = -559038737;
                try {
                    result = client.test(false);
                }
                catch (Exception e) {
                    Assert.fail((String)"No exception should have been thrown.");
                }
                Assert.assertEquals((long)result, (long)0L);
                caughtException = false;
                try {
                    result = client.test(true);
                }
                catch (Exception e) {
                    if (!e.getCause().getMessage().startsWith("java.lang.Exception: Something went wrong")) break block8;
                    caughtException = true;
                }
            }
            Assert.assertTrue((boolean)caughtException);
        }
        finally {
            if (rpcEngine != null) {
                rpcEngine.close();
            }
        }
    }

    private static class FaultyTestRpc
    implements TestRpc {
        private FaultyTestRpc() {
        }

        @Override
        public int test(boolean delay) {
            if (!delay) {
                return 0;
            }
            RpcCallContext call = HBaseServer.getCurrentCall();
            call.startDelay(true);
            try {
                call.endDelayThrowing((Throwable)new Exception("Something went wrong"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return 1;
        }

        public long getProtocolVersion(String arg0, long arg1) throws IOException {
            return 0L;
        }

        public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
            return new ProtocolSignature(clientVersion, new int[0]);
        }
    }

    private static class TestThread
    extends Thread {
        private TestRpc server;
        private boolean delay;
        private List<Integer> results;

        public TestThread(TestRpc server, boolean delay, List<Integer> results) {
            this.server = server;
            this.delay = delay;
            this.results = results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block5: {
                try {
                    Integer result = new Integer(this.server.test(this.delay));
                    if (this.results == null) break block5;
                    List<Integer> list = this.results;
                    synchronized (list) {
                        this.results.add(result);
                    }
                }
                catch (Exception e) {
                    Assert.fail((String)("Unexpected exception: " + e.getMessage()));
                }
            }
        }
    }

    private static class TestRpcImpl
    implements TestRpc {
        private boolean delayReturnValue;

        public TestRpcImpl(boolean delayReturnValue) {
            this.delayReturnValue = delayReturnValue;
        }

        @Override
        public int test(boolean delay) {
            if (!delay) {
                return 0;
            }
            RpcCallContext call = HBaseServer.getCurrentCall();
            call.startDelay(this.delayReturnValue);
            new Thread((Delayable)call){
                final /* synthetic */ Delayable val$call;
                {
                    this.val$call = delayable;
                }

                @Override
                public void run() {
                    try {
                        Thread.sleep(500L);
                        this.val$call.endDelay((Object)(TestRpcImpl.this.delayReturnValue ? Integer.valueOf(1) : null));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
            return -559038737;
        }

        public long getProtocolVersion(String arg0, long arg1) throws IOException {
            return 0L;
        }

        public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
            Method[] methods = this.getClass().getMethods();
            int[] hashes = new int[methods.length];
            for (int i = 0; i < methods.length; ++i) {
                hashes[i] = methods[i].hashCode();
            }
            return new ProtocolSignature(clientVersion, hashes);
        }
    }

    public static interface TestRpc
    extends VersionedProtocol {
        public static final long VERSION = 1L;

        public int test(boolean var1);
    }

    private static class ListAppender
    extends AppenderSkeleton {
        private List<String> messages = new ArrayList<String>();

        private ListAppender() {
        }

        protected void append(LoggingEvent event) {
            this.messages.add(event.getMessage().toString());
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }

        public List<String> getMessages() {
            return this.messages;
        }
    }
}

