/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.DescriptorProtos;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.ProtocolSignature;
import org.apache.hadoop.hbase.ipc.RpcEngine;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.VersionedProtocol;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestPBOnWritableRpc {
    private static Configuration conf = new Configuration();

    @Test(timeout=10000L)
    public void testCalls() throws Exception {
        this.testCallsInternal(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCallsInternal(Configuration conf) throws Exception {
        RpcServer rpcServer = HBaseRPC.getServer((Object)new TestImpl(), (Class[])new Class[]{TestProtocol.class}, (String)"localhost", (int)0, (int)2, (int)0, (boolean)conf.getBoolean("hbase.rpc.verbose", false), (Configuration)conf, (int)0);
        RpcEngine rpcEngine = null;
        try {
            rpcServer.start();
            rpcEngine = HBaseRPC.getProtocolEngine((Configuration)conf);
            InetSocketAddress isa = rpcServer.getListenerAddress();
            TestProtocol proxy = (TestProtocol)HBaseRPC.waitForProxy((RpcEngine)rpcEngine, TestProtocol.class, (long)1L, (InetSocketAddress)isa, (Configuration)conf, (int)-1, (int)8000, (long)8000L);
            String stringResult = proxy.echo("foo");
            Assert.assertEquals((Object)stringResult, (Object)"foo");
            stringResult = proxy.echo((String)null);
            Assert.assertEquals((Object)stringResult, null);
            Text utf8Result = (Text)proxy.echo((Writable)new Text("hello world"));
            Assert.assertEquals((Object)utf8Result, (Object)new Text("hello world"));
            utf8Result = (Text)proxy.echo((Writable)((Text)null));
            Assert.assertEquals((Object)utf8Result, null);
            DescriptorProtos.EnumDescriptorProto sendProto = DescriptorProtos.EnumDescriptorProto.newBuilder().setName("test").build();
            DescriptorProtos.EnumDescriptorProto retProto = proxy.exchangeProto(sendProto);
            Assert.assertEquals((Object)sendProto, (Object)retProto);
            Assert.assertNotSame((Object)sendProto, (Object)retProto);
        }
        finally {
            rpcServer.stop();
            if (rpcEngine != null) {
                rpcEngine.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new TestPBOnWritableRpc().testCallsInternal(conf);
    }

    public static class TestImpl
    implements TestProtocol {
        public long getProtocolVersion(String protocol, long clientVersion) {
            return 1L;
        }

        public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int hashcode) {
            return new ProtocolSignature(1L, null);
        }

        @Override
        public String echo(String value) throws IOException {
            return value;
        }

        @Override
        public Writable echo(Writable writable) {
            return writable;
        }

        @Override
        public DescriptorProtos.EnumDescriptorProto exchangeProto(DescriptorProtos.EnumDescriptorProto arg) {
            return arg;
        }
    }

    public static interface TestProtocol
    extends VersionedProtocol {
        public static final long VERSION = 1L;

        public String echo(String var1) throws IOException;

        public Writable echo(Writable var1) throws IOException;

        public DescriptorProtos.EnumDescriptorProto exchangeProto(DescriptorProtos.EnumDescriptorProto var1);
    }
}

