/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;

public abstract class MapreduceTestingShim {
    private static MapreduceTestingShim instance;

    public abstract JobContext newJobContext(Configuration var1) throws IOException;

    public static JobContext createJobContext(Configuration jobConf) throws IOException {
        return instance.newJobContext(jobConf);
    }

    static {
        try {
            Class<?> c = Class.forName("org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl");
            instance = new MapreduceV2Shim();
        }
        catch (Exception e) {
            instance = new MapreduceV1Shim();
        }
    }

    private static class MapreduceV2Shim
    extends MapreduceTestingShim {
        private MapreduceV2Shim() {
        }

        @Override
        public JobContext newJobContext(Configuration jobConf) {
            try {
                Method m = Job.class.getMethod("getInstance", Configuration.class);
                return (JobContext)m.invoke(null, jobConf);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException("Failed to return from Job.getInstance(jobConf)");
            }
        }
    }

    private static class MapreduceV1Shim
    extends MapreduceTestingShim {
        private MapreduceV1Shim() {
        }

        @Override
        public JobContext newJobContext(Configuration jobConf) throws IOException {
            JobID jobId = new JobID();
            try {
                Constructor c = JobContext.class.getConstructor(Configuration.class, JobID.class);
                return (JobContext)c.newInstance(jobConf, jobId);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to instantiate new JobContext(jobConf, new JobID())", e);
            }
        }
    }
}

