/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.mapreduce.HLogInputFormat;
import org.apache.hadoop.hbase.mapreduce.MapreduceTestingShim;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestHLogRecordReader {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf;
    private static FileSystem fs;
    private static Path hbaseDir;
    private static final byte[] tableName;
    private static final byte[] rowName;
    private static final HRegionInfo info;
    private static final byte[] family;
    private static final byte[] value;
    private static HTableDescriptor htd;
    private static Path logDir;
    private static Path oldLogDir;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    private static String getName() {
        return "TestHLogRecordReader";
    }

    @Before
    public void setUp() throws Exception {
        FileStatus[] entries;
        for (FileStatus dir : entries = fs.listStatus(hbaseDir)) {
            fs.delete(dir.getPath(), true);
        }
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setInt("dfs.blocksize", 0x100000);
        conf.setInt("dfs.replication", 1);
        TEST_UTIL.startMiniDFSCluster(1);
        conf = TEST_UTIL.getConfiguration();
        fs = TEST_UTIL.getDFSCluster().getFileSystem();
        hbaseDir = TEST_UTIL.createRootDir();
        logDir = new Path(hbaseDir, ".logs");
        oldLogDir = new Path(hbaseDir, ".oldlogs");
        htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(family));
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testPartialRead() throws Exception {
        HLog log = new HLog(fs, logDir, oldLogDir, conf);
        long ts = System.currentTimeMillis();
        WALEdit edit = new WALEdit();
        edit.add(new KeyValue(rowName, family, Bytes.toBytes((String)"1"), ts, value));
        log.append(info, tableName, edit, ts, htd);
        edit = new WALEdit();
        edit.add(new KeyValue(rowName, family, Bytes.toBytes((String)"2"), ts + 1L, value));
        log.append(info, tableName, edit, ts + 1L, htd);
        log.rollWriter();
        Thread.sleep(1L);
        long ts1 = System.currentTimeMillis();
        edit = new WALEdit();
        edit.add(new KeyValue(rowName, family, Bytes.toBytes((String)"3"), ts1 + 1L, value));
        log.append(info, tableName, edit, ts1 + 1L, htd);
        edit = new WALEdit();
        edit.add(new KeyValue(rowName, family, Bytes.toBytes((String)"4"), ts1 + 2L, value));
        log.append(info, tableName, edit, ts1 + 2L, htd);
        log.close();
        HLogInputFormat input = new HLogInputFormat();
        Configuration jobConf = new Configuration(conf);
        jobConf.set("mapred.input.dir", logDir.toString());
        jobConf.setLong(HLogInputFormat.END_TIME_KEY, ts);
        List splits = input.getSplits(MapreduceTestingShim.createJobContext(jobConf));
        Assert.assertEquals((long)1L, (long)splits.size());
        this.testSplit((InputSplit)splits.get(0), new byte[][]{Bytes.toBytes((String)"1")});
        jobConf.setLong(HLogInputFormat.START_TIME_KEY, ts + 1L);
        jobConf.setLong(HLogInputFormat.END_TIME_KEY, ts1 + 1L);
        splits = input.getSplits(MapreduceTestingShim.createJobContext(jobConf));
        Assert.assertEquals((long)2L, (long)splits.size());
        this.testSplit((InputSplit)splits.get(0), new byte[][]{Bytes.toBytes((String)"2")});
        this.testSplit((InputSplit)splits.get(1), new byte[][]{Bytes.toBytes((String)"3")});
    }

    @Test
    public void testHLogRecordReader() throws Exception {
        HLog log = new HLog(fs, logDir, oldLogDir, conf);
        byte[] value = Bytes.toBytes((String)"value");
        WALEdit edit = new WALEdit();
        edit.add(new KeyValue(rowName, family, Bytes.toBytes((String)"1"), System.currentTimeMillis(), value));
        log.append(info, tableName, edit, System.currentTimeMillis(), htd);
        Thread.sleep(1L);
        long secondTs = System.currentTimeMillis();
        log.rollWriter();
        edit = new WALEdit();
        edit.add(new KeyValue(rowName, family, Bytes.toBytes((String)"2"), System.currentTimeMillis(), value));
        log.append(info, tableName, edit, System.currentTimeMillis(), htd);
        log.close();
        long thirdTs = System.currentTimeMillis();
        HLogInputFormat input = new HLogInputFormat();
        Configuration jobConf = new Configuration(conf);
        jobConf.set("mapred.input.dir", logDir.toString());
        List splits = input.getSplits(MapreduceTestingShim.createJobContext(jobConf));
        Assert.assertEquals((long)2L, (long)splits.size());
        this.testSplit((InputSplit)splits.get(0), new byte[][]{Bytes.toBytes((String)"1")});
        this.testSplit((InputSplit)splits.get(1), new byte[][]{Bytes.toBytes((String)"2")});
        jobConf.setLong(HLogInputFormat.END_TIME_KEY, secondTs - 1L);
        splits = input.getSplits(MapreduceTestingShim.createJobContext(jobConf));
        Assert.assertEquals((long)1L, (long)splits.size());
        this.testSplit((InputSplit)splits.get(0), new byte[][]{Bytes.toBytes((String)"1")});
        jobConf.setLong(HLogInputFormat.END_TIME_KEY, Long.MAX_VALUE);
        jobConf.setLong(HLogInputFormat.START_TIME_KEY, thirdTs);
        splits = input.getSplits(MapreduceTestingShim.createJobContext(jobConf));
        Assert.assertEquals((long)2L, (long)splits.size());
        this.testSplit((InputSplit)splits.get(0), new byte[0][]);
        this.testSplit((InputSplit)splits.get(1), new byte[0][]);
    }

    private void testSplit(InputSplit split, byte[] ... columns) throws Exception {
        HLogInputFormat.HLogRecordReader reader = new HLogInputFormat.HLogRecordReader();
        reader.initialize(split, MapReduceTestUtil.createDummyMapTaskAttemptContext((Configuration)conf));
        for (byte[] column : columns) {
            Assert.assertTrue((boolean)reader.nextKeyValue());
            Assert.assertTrue((boolean)Bytes.equals((byte[])column, (byte[])((KeyValue)reader.getCurrentValue().getKeyValues().get(0)).getQualifier()));
        }
        Assert.assertFalse((boolean)reader.nextKeyValue());
        reader.close();
    }

    static {
        tableName = Bytes.toBytes((String)TestHLogRecordReader.getName());
        rowName = tableName;
        info = new HRegionInfo(tableName, Bytes.toBytes((String)""), Bytes.toBytes((String)""), false);
        family = Bytes.toBytes((String)"column");
        value = Bytes.toBytes((String)"value");
    }
}

