/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.mapreduce.Export;
import org.apache.hadoop.hbase.mapreduce.Import;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.GenericOptionsParser;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestImportExport {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final byte[] ROW1 = Bytes.toBytes((String)"row1");
    private static final byte[] ROW2 = Bytes.toBytes((String)"row2");
    private static final String FAMILYA_STRING = "a";
    private static final String FAMILYB_STRING = "b";
    private static final byte[] FAMILYA = Bytes.toBytes((String)"a");
    private static final byte[] FAMILYB = Bytes.toBytes((String)"b");
    private static final byte[] QUAL = Bytes.toBytes((String)"q");
    private static final String OUTPUT_DIR = "outputdir";
    private static MiniHBaseCluster cluster;
    private static long now;

    @BeforeClass
    public static void beforeClass() throws Exception {
        cluster = UTIL.startMiniCluster();
        UTIL.startMiniMapReduceCluster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniMapReduceCluster();
        UTIL.shutdownMiniCluster();
    }

    @Before
    @After
    public void cleanup() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        fs.delete(new Path(OUTPUT_DIR), true);
    }

    @Test
    public void testSimpleCase() throws Exception {
        String EXPORT_TABLE = "exportSimpleCase";
        HTable t = UTIL.createTable(Bytes.toBytes((String)EXPORT_TABLE), FAMILYA);
        Put p = new Put(ROW1);
        p.add(FAMILYA, QUAL, now, QUAL);
        p.add(FAMILYA, QUAL, now + 1L, QUAL);
        p.add(FAMILYA, QUAL, now + 2L, QUAL);
        t.put(p);
        p = new Put(ROW2);
        p.add(FAMILYA, QUAL, now, QUAL);
        p.add(FAMILYA, QUAL, now + 1L, QUAL);
        p.add(FAMILYA, QUAL, now + 2L, QUAL);
        t.put(p);
        String[] args = new String[]{EXPORT_TABLE, OUTPUT_DIR, "1000"};
        GenericOptionsParser opts = new GenericOptionsParser(new Configuration(cluster.getConfiguration()), args);
        Configuration conf = opts.getConfiguration();
        args = opts.getRemainingArgs();
        Job job = Export.createSubmittableJob((Configuration)conf, (String[])args);
        job.getConfiguration().set("mapreduce.framework.name", "yarn");
        job.waitForCompletion(false);
        Assert.assertTrue((boolean)job.isSuccessful());
        String IMPORT_TABLE = "importTableSimpleCase";
        t = UTIL.createTable(Bytes.toBytes((String)IMPORT_TABLE), FAMILYB);
        args = new String[]{"-DHBASE_IMPORTER_RENAME_CFS=a:b", IMPORT_TABLE, OUTPUT_DIR};
        opts = new GenericOptionsParser(new Configuration(cluster.getConfiguration()), args);
        conf = opts.getConfiguration();
        args = opts.getRemainingArgs();
        job = Import.createSubmittableJob((Configuration)conf, (String[])args);
        job.getConfiguration().set("mapreduce.framework.name", "yarn");
        job.waitForCompletion(false);
        Assert.assertTrue((boolean)job.isSuccessful());
        Get g = new Get(ROW1);
        g.setMaxVersions();
        Result r = t.get(g);
        Assert.assertEquals((long)3L, (long)r.size());
        g = new Get(ROW2);
        g.setMaxVersions();
        r = t.get(g);
        Assert.assertEquals((long)3L, (long)r.size());
    }

    @Test
    public void testMetaExport() throws Exception {
        String EXPORT_TABLE = ".META.";
        String[] args = new String[]{EXPORT_TABLE, OUTPUT_DIR, "1", "0", "0"};
        GenericOptionsParser opts = new GenericOptionsParser(new Configuration(cluster.getConfiguration()), args);
        Configuration conf = opts.getConfiguration();
        args = opts.getRemainingArgs();
        Job job = Export.createSubmittableJob((Configuration)conf, (String[])args);
        job.getConfiguration().set("mapreduce.framework.name", "yarn");
        job.waitForCompletion(false);
        Assert.assertTrue((boolean)job.isSuccessful());
    }

    @Test
    public void testWithDeletes() throws Exception {
        String EXPORT_TABLE = "exportWithDeletes";
        HTableDescriptor desc = new HTableDescriptor(EXPORT_TABLE);
        desc.addFamily(new HColumnDescriptor(FAMILYA).setMaxVersions(5).setKeepDeletedCells(true));
        UTIL.getHBaseAdmin().createTable(desc);
        HTable t = new HTable(UTIL.getConfiguration(), EXPORT_TABLE);
        Put p = new Put(ROW1);
        p.add(FAMILYA, QUAL, now, QUAL);
        p.add(FAMILYA, QUAL, now + 1L, QUAL);
        p.add(FAMILYA, QUAL, now + 2L, QUAL);
        p.add(FAMILYA, QUAL, now + 3L, QUAL);
        p.add(FAMILYA, QUAL, now + 4L, QUAL);
        t.put(p);
        Delete d = new Delete(ROW1, now + 3L, null);
        t.delete(d);
        d = new Delete(ROW1);
        d.deleteColumns(FAMILYA, QUAL, now + 2L);
        t.delete(d);
        String[] args = new String[]{"-Dhbase.mapreduce.include.deleted.rows=true", EXPORT_TABLE, OUTPUT_DIR, "1000"};
        GenericOptionsParser opts = new GenericOptionsParser(new Configuration(cluster.getConfiguration()), args);
        Configuration conf = opts.getConfiguration();
        args = opts.getRemainingArgs();
        Job job = Export.createSubmittableJob((Configuration)conf, (String[])args);
        job.getConfiguration().set("mapreduce.framework.name", "yarn");
        job.waitForCompletion(false);
        Assert.assertTrue((boolean)job.isSuccessful());
        String IMPORT_TABLE = "importWithDeletes";
        desc = new HTableDescriptor(IMPORT_TABLE);
        desc.addFamily(new HColumnDescriptor(FAMILYA).setMaxVersions(5).setKeepDeletedCells(true));
        UTIL.getHBaseAdmin().createTable(desc);
        t.close();
        t = new HTable(UTIL.getConfiguration(), IMPORT_TABLE);
        args = new String[]{IMPORT_TABLE, OUTPUT_DIR};
        opts = new GenericOptionsParser(new Configuration(cluster.getConfiguration()), args);
        conf = opts.getConfiguration();
        args = opts.getRemainingArgs();
        job = Import.createSubmittableJob((Configuration)conf, (String[])args);
        job.getConfiguration().set("mapreduce.framework.name", "yarn");
        job.waitForCompletion(false);
        Assert.assertTrue((boolean)job.isSuccessful());
        Scan s = new Scan();
        s.setMaxVersions();
        s.setRaw(true);
        ResultScanner scanner = t.getScanner(s);
        Result r = scanner.next();
        KeyValue[] res = r.raw();
        Assert.assertTrue((boolean)res[0].isDeleteFamily());
        Assert.assertEquals((long)(now + 4L), (long)res[1].getTimestamp());
        Assert.assertEquals((long)(now + 3L), (long)res[2].getTimestamp());
        Assert.assertTrue((boolean)res[3].isDelete());
        Assert.assertEquals((long)(now + 2L), (long)res[4].getTimestamp());
        Assert.assertEquals((long)(now + 1L), (long)res[5].getTimestamp());
        Assert.assertEquals((long)now, (long)res[6].getTimestamp());
        t.close();
    }

    @Test
    public void testWithFilter() throws Exception {
        String EXPORT_TABLE = "exportSimpleCase_ImportWithFilter";
        HTableDescriptor desc = new HTableDescriptor(EXPORT_TABLE);
        desc.addFamily(new HColumnDescriptor(FAMILYA).setMaxVersions(5));
        UTIL.getHBaseAdmin().createTable(desc);
        HTable exportTable = new HTable(UTIL.getConfiguration(), EXPORT_TABLE);
        Put p = new Put(ROW1);
        p.add(FAMILYA, QUAL, now, QUAL);
        p.add(FAMILYA, QUAL, now + 1L, QUAL);
        p.add(FAMILYA, QUAL, now + 2L, QUAL);
        p.add(FAMILYA, QUAL, now + 3L, QUAL);
        p.add(FAMILYA, QUAL, now + 4L, QUAL);
        exportTable.put(p);
        String[] args = new String[]{EXPORT_TABLE, OUTPUT_DIR, "1000"};
        GenericOptionsParser opts = new GenericOptionsParser(new Configuration(cluster.getConfiguration()), args);
        Configuration conf = opts.getConfiguration();
        args = opts.getRemainingArgs();
        Job job = Export.createSubmittableJob((Configuration)conf, (String[])args);
        job.getConfiguration().set("mapreduce.framework.name", "yarn");
        job.waitForCompletion(false);
        Assert.assertTrue((boolean)job.isSuccessful());
        String IMPORT_TABLE = "importWithFilter";
        desc = new HTableDescriptor(IMPORT_TABLE);
        desc.addFamily(new HColumnDescriptor(FAMILYA).setMaxVersions(5));
        UTIL.getHBaseAdmin().createTable(desc);
        HTable importTable = new HTable(UTIL.getConfiguration(), IMPORT_TABLE);
        args = new String[]{"-Dimport.filter.class=" + PrefixFilter.class.getName(), "-Dimport.filter.args=" + Bytes.toString((byte[])ROW1), IMPORT_TABLE, OUTPUT_DIR, "1000"};
        opts = new GenericOptionsParser(new Configuration(cluster.getConfiguration()), args);
        conf = opts.getConfiguration();
        args = opts.getRemainingArgs();
        job = Import.createSubmittableJob((Configuration)conf, (String[])args);
        job.getConfiguration().set("mapreduce.framework.name", "yarn");
        job.waitForCompletion(false);
        Assert.assertTrue((boolean)job.isSuccessful());
        PrefixFilter filter = new PrefixFilter(ROW1);
        int count = this.getCount(exportTable, (Filter)filter);
        Assert.assertEquals((String)"Unexpected row count between export and import tables", (long)count, (long)this.getCount(importTable, null));
        args = new String[]{"-Dimport.filter.class=" + Filter.class.getName(), "-Dimport.filter.args=" + Bytes.toString((byte[])ROW1) + "", EXPORT_TABLE, OUTPUT_DIR, "1000"};
        opts = new GenericOptionsParser(new Configuration(cluster.getConfiguration()), args);
        conf = opts.getConfiguration();
        args = opts.getRemainingArgs();
        job = Import.createSubmittableJob((Configuration)conf, (String[])args);
        job.getConfiguration().set("mapreduce.framework.name", "yarn");
        job.waitForCompletion(false);
        Assert.assertFalse((String)"Job succeeedd, but it had a non-instantiable filter!", (boolean)job.isSuccessful());
        exportTable.close();
        importTable.close();
    }

    private int getCount(HTable table, Filter filter) throws IOException {
        Scan scan = new Scan();
        scan.setFilter(filter);
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            count += res.size();
        }
        results.close();
        return count;
    }

    static {
        now = System.currentTimeMillis();
    }
}

