/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestTimeRangeMapRed {
    private static final Log log = LogFactory.getLog(TestTimeRangeMapRed.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private HBaseAdmin admin;
    private static final byte[] KEY = Bytes.toBytes((String)"row1");
    private static final NavigableMap<Long, Boolean> TIMESTAMP = new TreeMap<Long, Boolean>();
    static final long MINSTAMP = 1245620005L;
    static final long MAXSTAMP = 1245620101L;
    static final byte[] TABLE_NAME;
    static final byte[] FAMILY_NAME;
    static final byte[] COLUMN_NAME;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void before() throws MasterNotRunningException, ZooKeeperConnectionException {
        this.admin = new HBaseAdmin(UTIL.getConfiguration());
    }

    @After
    public void after() throws IOException {
        this.admin.close();
    }

    @Test
    public void testTimeRangeMapRed() throws IOException, InterruptedException, ClassNotFoundException {
        HTableDescriptor desc = new HTableDescriptor(TABLE_NAME);
        HColumnDescriptor col = new HColumnDescriptor(FAMILY_NAME);
        col.setMaxVersions(Integer.MAX_VALUE);
        desc.addFamily(col);
        this.admin.createTable(desc);
        HTable table = new HTable(UTIL.getConfiguration(), desc.getName());
        this.prepareTest(table);
        this.runTestOnTable();
        this.verify(table);
    }

    private void prepareTest(HTable table) throws IOException {
        for (Map.Entry entry : TIMESTAMP.entrySet()) {
            Put put = new Put(KEY);
            put.setWriteToWAL(false);
            put.add(FAMILY_NAME, COLUMN_NAME, ((Long)entry.getKey()).longValue(), Bytes.toBytes((boolean)false));
            table.put(put);
        }
        table.flushCommits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestOnTable() throws IOException, InterruptedException, ClassNotFoundException {
        UTIL.startMiniMapReduceCluster(1);
        Job job = null;
        try {
            job = new Job(UTIL.getConfiguration(), "test123");
            job.setOutputFormatClass(NullOutputFormat.class);
            job.setNumReduceTasks(0);
            Scan scan = new Scan();
            scan.addColumn(FAMILY_NAME, COLUMN_NAME);
            scan.setTimeRange(1245620005L, 1245620101L);
            scan.setMaxVersions();
            TableMapReduceUtil.initTableMapperJob((String)Bytes.toString((byte[])TABLE_NAME), (Scan)scan, ProcessTimeRangeMapper.class, Text.class, Text.class, (Job)job);
            job.waitForCompletion(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            UTIL.shutdownMiniMapReduceCluster();
            if (job != null) {
                FileUtil.fullyDelete((File)new File(job.getConfiguration().get("hadoop.tmp.dir")));
            }
        }
    }

    private void verify(HTable table) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(FAMILY_NAME, COLUMN_NAME);
        scan.setMaxVersions(1);
        ResultScanner scanner = table.getScanner(scan);
        for (Result r : scanner) {
            for (KeyValue kv : r.list()) {
                log.debug((Object)(Bytes.toString((byte[])r.getRow()) + "\t" + Bytes.toString((byte[])kv.getFamily()) + "\t" + Bytes.toString((byte[])kv.getQualifier()) + "\t" + kv.getTimestamp() + "\t" + Bytes.toBoolean((byte[])kv.getValue())));
                Assert.assertEquals(TIMESTAMP.get(kv.getTimestamp()), (Object)Bytes.toBoolean((byte[])kv.getValue()));
            }
        }
        scanner.close();
    }

    static {
        TIMESTAMP.put(1245620000L, false);
        TIMESTAMP.put(1245620005L, true);
        TIMESTAMP.put(1245620010L, true);
        TIMESTAMP.put(1245620055L, true);
        TIMESTAMP.put(1245620100L, true);
        TIMESTAMP.put(1245620150L, false);
        TIMESTAMP.put(1245620250L, false);
        TABLE_NAME = Bytes.toBytes((String)"table123");
        FAMILY_NAME = Bytes.toBytes((String)"text");
        COLUMN_NAME = Bytes.toBytes((String)"input");
    }

    private static class ProcessTimeRangeMapper
    extends TableMapper<ImmutableBytesWritable, MapWritable>
    implements Configurable {
        private Configuration conf = null;
        private HTable table = null;

        private ProcessTimeRangeMapper() {
        }

        public void map(ImmutableBytesWritable key, Result result, Mapper.Context context) throws IOException {
            ArrayList<Long> tsList = new ArrayList<Long>();
            for (KeyValue kv : result.list()) {
                tsList.add(kv.getTimestamp());
            }
            for (Long ts : tsList) {
                Put put = new Put(key.get());
                put.setWriteToWAL(false);
                put.add(FAMILY_NAME, COLUMN_NAME, ts.longValue(), Bytes.toBytes((boolean)true));
                this.table.put(put);
            }
            this.table.flushCommits();
        }

        public Configuration getConf() {
            return this.conf;
        }

        public void setConf(Configuration configuration) {
            this.conf = configuration;
            try {
                this.table = new HTable(HBaseConfiguration.create((Configuration)this.conf), TABLE_NAME);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

