/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.mapreduce.WALPlayer;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestWALPlayer {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static MiniHBaseCluster cluster;

    @BeforeClass
    public static void beforeClass() throws Exception {
        cluster = TEST_UTIL.startMiniCluster();
        TEST_UTIL.startMiniMapReduceCluster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniMapReduceCluster();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testWALPlayer() throws Exception {
        byte[] TABLENAME1 = Bytes.toBytes((String)"testWALPlayer1");
        byte[] TABLENAME2 = Bytes.toBytes((String)"testWALPlayer2");
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[] COLUMN1 = Bytes.toBytes((String)"c1");
        byte[] COLUMN2 = Bytes.toBytes((String)"c2");
        byte[] ROW = Bytes.toBytes((String)"row");
        HTable t1 = TEST_UTIL.createTable(TABLENAME1, FAMILY);
        HTable t2 = TEST_UTIL.createTable(TABLENAME2, FAMILY);
        Put p = new Put(ROW);
        p.add(FAMILY, COLUMN1, COLUMN1);
        p.add(FAMILY, COLUMN2, COLUMN2);
        t1.put(p);
        Delete d = new Delete(ROW);
        d.deleteColumns(FAMILY, COLUMN1);
        t1.delete(d);
        HLog log = cluster.getRegionServer(0).getWAL();
        log.rollWriter();
        String walInputDir = new Path(cluster.getMaster().getMasterFileSystem().getRootDir(), ".logs").toString();
        WALPlayer player = new WALPlayer(TEST_UTIL.getConfiguration());
        Assert.assertEquals((long)0L, (long)player.run(new String[]{walInputDir, Bytes.toString((byte[])TABLENAME1), Bytes.toString((byte[])TABLENAME2)}));
        Get g = new Get(ROW);
        Result r = t2.get(g);
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertTrue((boolean)Bytes.equals((byte[])COLUMN2, (byte[])r.raw()[0].getQualifier()));
    }
}

