/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerLoad;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.executor.RegionTransitionData;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.DeadServer;
import org.apache.hadoop.hbase.master.DefaultLoadBalancer;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.LoadBalancerFactory;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.Mocking;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.handler.ServerShutdownHandler;
import org.apache.hadoop.hbase.regionserver.RegionOpeningState;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKTable;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.Writable;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;

@Category(value={MediumTests.class})
public class TestAssignmentManager {
    private static final HBaseTestingUtility HTU = new HBaseTestingUtility();
    private static final ServerName SERVERNAME_A = new ServerName("example.org", 1234, 5678L);
    private static final ServerName SERVERNAME_B = new ServerName("example.org", 0, 5678L);
    private static final HRegionInfo REGIONINFO = new HRegionInfo(Bytes.toBytes((String)"t"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_START_ROW);
    private static final HRegionInfo REGIONINFO_2 = new HRegionInfo(Bytes.toBytes((String)"t"), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"));
    private static int assignmentCount;
    private static boolean enabling;
    private Server server;
    private ServerManager serverManager;
    private ZooKeeperWatcher watcher;
    private LoadBalancer balancer;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void beforeClass() throws Exception {
        HTU.startMiniZKCluster();
    }

    @AfterClass
    public static void afterClass() throws IOException {
        HTU.shutdownMiniZKCluster();
    }

    @Before
    public void before() throws ZooKeeperConnectionException, IOException {
        this.server = (Server)Mockito.mock(Server.class);
        Mockito.when((Object)this.server.getConfiguration()).thenReturn((Object)HTU.getConfiguration());
        this.watcher = new ZooKeeperWatcher(HTU.getConfiguration(), "mockedServer", (Abortable)this.server, true);
        Mockito.when((Object)this.server.getZooKeeper()).thenReturn((Object)this.watcher);
        ((Server)Mockito.doThrow((Throwable)new RuntimeException("Aborted")).when((Object)this.server)).abort(Mockito.anyString(), (Throwable)Mockito.anyObject());
        this.serverManager = (ServerManager)Mockito.mock(ServerManager.class);
        Mockito.when((Object)this.serverManager.isServerOnline(SERVERNAME_A)).thenReturn((Object)true);
        Mockito.when((Object)this.serverManager.isServerOnline(SERVERNAME_B)).thenReturn((Object)true);
        HashMap<ServerName, HServerLoad> onlineServers = new HashMap<ServerName, HServerLoad>();
        onlineServers.put(SERVERNAME_B, new HServerLoad());
        onlineServers.put(SERVERNAME_A, new HServerLoad());
        Mockito.when((Object)this.serverManager.getOnlineServersList()).thenReturn(new ArrayList(onlineServers.keySet()));
        Mockito.when((Object)this.serverManager.getOnlineServers()).thenReturn(onlineServers);
        Mockito.when((Object)this.serverManager.sendRegionClose(SERVERNAME_A, REGIONINFO, -1)).thenReturn((Object)true);
        Mockito.when((Object)this.serverManager.sendRegionClose(SERVERNAME_B, REGIONINFO, -1)).thenReturn((Object)true);
        Mockito.when((Object)this.serverManager.sendRegionOpen(SERVERNAME_A, REGIONINFO, -1)).thenReturn((Object)RegionOpeningState.OPENED);
        Mockito.when((Object)this.serverManager.sendRegionOpen(SERVERNAME_B, REGIONINFO, -1)).thenReturn((Object)RegionOpeningState.OPENED);
    }

    @After
    public void after() throws KeeperException {
        if (this.watcher != null) {
            ZKAssign.deleteAllNodes((ZooKeeperWatcher)this.watcher);
            this.watcher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testBalanceOnMasterFailoverScenarioWithOpenedNode() throws IOException, KeeperException, InterruptedException {
        AssignmentManagerWithExtrasForTesting am = this.setUpMockedAssignmentManager(this.server, this.serverManager);
        try {
            int vid;
            this.createRegionPlanAndBalance(am, SERVERNAME_A, SERVERNAME_B, REGIONINFO);
            this.startFakeFailedOverMasterAssignmentManager(am, this.watcher);
            while (!am.processRITInvoked) {
                Thread.sleep(1L);
            }
            int versionid = ZKAssign.transitionNodeClosed((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_A, (int)-1);
            Assert.assertNotSame((Object)versionid, (Object)-1);
            Mocking.waitForRegionOfflineInRIT(am, REGIONINFO.getEncodedName());
            while ((vid = ZKAssign.getVersion((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO)) == versionid) {
            }
            versionid = vid;
            Assert.assertNotSame((Object)-1, (Object)versionid);
            versionid = ZKAssign.transitionNode((ZooKeeperWatcher)this.server.getZooKeeper(), (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_A, (EventHandler.EventType)EventHandler.EventType.M_ZK_REGION_OFFLINE, (EventHandler.EventType)EventHandler.EventType.RS_ZK_REGION_OPENING, (int)versionid);
            Assert.assertNotSame((Object)-1, (Object)versionid);
            versionid = ZKAssign.transitionNodeOpened((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_B, (int)versionid);
            Assert.assertNotSame((Object)-1, (Object)versionid);
            am.gate.set(false);
            ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)this.watcher);
        }
        finally {
            am.getExecutorService().shutdown();
            am.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testBalanceOnMasterFailoverScenarioWithClosedNode() throws IOException, KeeperException, InterruptedException {
        AssignmentManagerWithExtrasForTesting am = this.setUpMockedAssignmentManager(this.server, this.serverManager);
        try {
            int vid;
            this.createRegionPlanAndBalance(am, SERVERNAME_A, SERVERNAME_B, REGIONINFO);
            this.startFakeFailedOverMasterAssignmentManager(am, this.watcher);
            while (!am.processRITInvoked) {
                Thread.sleep(1L);
            }
            int versionid = ZKAssign.transitionNodeClosed((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_A, (int)-1);
            Assert.assertNotSame((Object)versionid, (Object)-1);
            am.gate.set(false);
            Mocking.waitForRegionOfflineInRIT(am, REGIONINFO.getEncodedName());
            while ((vid = ZKAssign.getVersion((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO)) == versionid) {
            }
            versionid = vid;
            Assert.assertNotSame((Object)-1, (Object)versionid);
            versionid = ZKAssign.transitionNode((ZooKeeperWatcher)this.server.getZooKeeper(), (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_A, (EventHandler.EventType)EventHandler.EventType.M_ZK_REGION_OFFLINE, (EventHandler.EventType)EventHandler.EventType.RS_ZK_REGION_OPENING, (int)versionid);
            Assert.assertNotSame((Object)-1, (Object)versionid);
            versionid = ZKAssign.transitionNodeOpened((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_B, (int)versionid);
            Assert.assertNotSame((Object)-1, (Object)versionid);
            ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)this.watcher);
        }
        finally {
            am.getExecutorService().shutdown();
            am.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testBalanceOnMasterFailoverScenarioWithOfflineNode() throws IOException, KeeperException, InterruptedException {
        AssignmentManagerWithExtrasForTesting am = this.setUpMockedAssignmentManager(this.server, this.serverManager);
        try {
            int vid;
            this.createRegionPlanAndBalance(am, SERVERNAME_A, SERVERNAME_B, REGIONINFO);
            this.startFakeFailedOverMasterAssignmentManager(am, this.watcher);
            while (!am.processRITInvoked) {
                Thread.sleep(1L);
            }
            int versionid = ZKAssign.transitionNodeClosed((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_A, (int)-1);
            Assert.assertNotSame((Object)versionid, (Object)-1);
            Mocking.waitForRegionOfflineInRIT(am, REGIONINFO.getEncodedName());
            am.gate.set(false);
            while ((vid = ZKAssign.getVersion((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO)) == versionid) {
            }
            versionid = vid;
            Assert.assertNotSame((Object)-1, (Object)versionid);
            versionid = ZKAssign.transitionNode((ZooKeeperWatcher)this.server.getZooKeeper(), (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_A, (EventHandler.EventType)EventHandler.EventType.M_ZK_REGION_OFFLINE, (EventHandler.EventType)EventHandler.EventType.RS_ZK_REGION_OPENING, (int)versionid);
            Assert.assertNotSame((Object)-1, (Object)versionid);
            versionid = ZKAssign.transitionNodeOpened((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_B, (int)versionid);
            Assert.assertNotSame((Object)-1, (Object)versionid);
            ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)this.watcher);
        }
        finally {
            am.getExecutorService().shutdown();
            am.shutdown();
        }
    }

    private void createRegionPlanAndBalance(AssignmentManager am, ServerName from, ServerName to, HRegionInfo hri) {
        am.regionOnline(hri, from);
        am.balance(new RegionPlan(hri, from, to));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testBalance() throws IOException, KeeperException, InterruptedException {
        ExecutorService executor = this.startupMasterExecutor("testBalanceExecutor");
        CatalogTracker ct = (CatalogTracker)Mockito.mock(CatalogTracker.class);
        LoadBalancer balancer = LoadBalancerFactory.getLoadBalancer((Configuration)this.server.getConfiguration());
        AssignmentManager am = new AssignmentManager(this.server, this.serverManager, ct, balancer, executor);
        try {
            int vid;
            this.watcher.registerListenerFirst((ZooKeeperListener)am);
            am.regionOnline(REGIONINFO, SERVERNAME_A);
            RegionPlan plan = new RegionPlan(REGIONINFO, SERVERNAME_A, SERVERNAME_B);
            am.balance(plan);
            int versionid = ZKAssign.transitionNodeClosed((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_A, (int)-1);
            Assert.assertNotSame((Object)versionid, (Object)-1);
            Mocking.waitForRegionOfflineInRIT(am, REGIONINFO.getEncodedName());
            while ((vid = ZKAssign.getVersion((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO)) == versionid) {
            }
            versionid = vid;
            Assert.assertNotSame((Object)-1, (Object)versionid);
            versionid = ZKAssign.transitionNode((ZooKeeperWatcher)this.server.getZooKeeper(), (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_A, (EventHandler.EventType)EventHandler.EventType.M_ZK_REGION_OFFLINE, (EventHandler.EventType)EventHandler.EventType.RS_ZK_REGION_OPENING, (int)versionid);
            Assert.assertNotSame((Object)-1, (Object)versionid);
            versionid = ZKAssign.transitionNodeOpened((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_B, (int)versionid);
            Assert.assertNotSame((Object)-1, (Object)versionid);
            while (am.isRegionInTransition(REGIONINFO) != null) {
                Threads.sleep((long)1L);
            }
        }
        finally {
            executor.shutdown();
            am.shutdown();
            ZKAssign.deleteAllNodes((ZooKeeperWatcher)this.watcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShutdownHandler() throws KeeperException, IOException {
        ExecutorService executor = this.startupMasterExecutor("testShutdownHandler");
        CatalogTracker ct = (CatalogTracker)Mockito.mock(CatalogTracker.class);
        LoadBalancer balancer = LoadBalancerFactory.getLoadBalancer((Configuration)this.server.getConfiguration());
        AssignmentManager am = new AssignmentManager(this.server, this.serverManager, ct, balancer, executor);
        try {
            this.processServerShutdownHandler(ct, am, false, null);
        }
        finally {
            executor.shutdown();
            am.shutdown();
            ZKAssign.deleteAllNodes((ZooKeeperWatcher)this.watcher);
        }
    }

    @Test
    public void testSSHWhenDisableTableInProgress() throws KeeperException, IOException {
        this.testCaseWithPartiallyDisabledState(ZKTable.TableState.DISABLING);
        this.testCaseWithPartiallyDisabledState(ZKTable.TableState.DISABLED);
    }

    @Test
    public void testSSHWhenSplitRegionInProgress() throws KeeperException, IOException, Exception {
        this.testCaseWithSplitRegionPartial(true);
        this.testCaseWithSplitRegionPartial(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCaseWithSplitRegionPartial(boolean regionSplitDone) throws KeeperException, IOException, KeeperException.NodeExistsException, InterruptedException {
        ExecutorService executor = this.startupMasterExecutor("testSSHWhenSplitRegionInProgress");
        CatalogTracker ct = (CatalogTracker)Mockito.mock(CatalogTracker.class);
        AssignmentManagerWithExtrasForTesting am = this.setUpMockedAssignmentManager(this.server, this.serverManager);
        am.regionOnline(REGIONINFO, SERVERNAME_A);
        am.regionsInTransition.put(REGIONINFO.getEncodedName(), new AssignmentManager.RegionState(REGIONINFO, AssignmentManager.RegionState.State.SPLITTING, System.currentTimeMillis(), SERVERNAME_A));
        am.getZKTable().setEnabledTable(REGIONINFO.getTableNameAsString());
        RegionTransitionData data = new RegionTransitionData(EventHandler.EventType.RS_ZK_REGION_SPLITTING, REGIONINFO.getRegionName(), SERVERNAME_A);
        String node = ZKAssign.getNodeName((ZooKeeperWatcher)this.watcher, (String)REGIONINFO.getEncodedName());
        ZKUtil.createAndWatch((ZooKeeperWatcher)this.watcher, (String)node, (byte[])data.getBytes());
        try {
            this.processServerShutdownHandler(ct, am, regionSplitDone, null);
            if (regionSplitDone) {
                Assert.assertTrue((String)"Region state of region in SPLITTING should be removed from rit.", (boolean)am.regionsInTransition.isEmpty());
            } else {
                while (!am.assignInvoked) {
                    Thread.sleep(1L);
                }
                Assert.assertTrue((String)"Assign should be invoked.", (boolean)am.assignInvoked);
            }
        }
        finally {
            REGIONINFO.setOffline(false);
            REGIONINFO.setSplit(false);
            executor.shutdown();
            am.shutdown();
            ZKAssign.deleteAllNodes((ZooKeeperWatcher)this.watcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCaseWithPartiallyDisabledState(ZKTable.TableState state) throws KeeperException, IOException, KeeperException.NodeExistsException {
        ExecutorService executor = this.startupMasterExecutor("testSSHWhenDisableTableInProgress");
        CatalogTracker ct = (CatalogTracker)Mockito.mock(CatalogTracker.class);
        LoadBalancer balancer = LoadBalancerFactory.getLoadBalancer((Configuration)this.server.getConfiguration());
        AssignmentManager am = new AssignmentManager(this.server, this.serverManager, ct, balancer, executor);
        am.regionOnline(REGIONINFO, SERVERNAME_A);
        am.regionsInTransition.put(REGIONINFO.getEncodedName(), new AssignmentManager.RegionState(REGIONINFO, AssignmentManager.RegionState.State.PENDING_CLOSE, System.currentTimeMillis(), SERVERNAME_A));
        if (state == ZKTable.TableState.DISABLING) {
            am.getZKTable().setDisablingTable(REGIONINFO.getTableNameAsString());
        } else {
            am.getZKTable().setDisabledTable(REGIONINFO.getTableNameAsString());
        }
        RegionTransitionData data = new RegionTransitionData(EventHandler.EventType.M_ZK_REGION_CLOSING, REGIONINFO.getRegionName(), SERVERNAME_A);
        String node = ZKAssign.getNodeName((ZooKeeperWatcher)this.watcher, (String)REGIONINFO.getEncodedName());
        ZKUtil.createAndWatch((ZooKeeperWatcher)this.watcher, (String)node, (byte[])data.getBytes());
        try {
            this.processServerShutdownHandler(ct, am, false, null);
            Assert.assertTrue((String)"The znode should be deleted.", (ZKUtil.checkExists((ZooKeeperWatcher)this.watcher, (String)node) == -1 ? 1 : 0) != 0);
            if (state == ZKTable.TableState.DISABLED) {
                Assert.assertTrue((String)"Region state of region in pending close should be removed from rit.", (boolean)am.regionsInTransition.isEmpty());
            }
        }
        finally {
            executor.shutdown();
            am.shutdown();
            ZKAssign.deleteAllNodes((ZooKeeperWatcher)this.watcher);
        }
    }

    private void processServerShutdownHandler(CatalogTracker ct, AssignmentManager am, boolean splitRegion, ServerName sn) throws IOException {
        this.watcher.registerListenerFirst((ZooKeeperListener)am);
        HRegionInterface implementation = (HRegionInterface)Mockito.mock(HRegionInterface.class);
        Result r = null;
        if (sn == null) {
            r = splitRegion ? this.getMetaTableRowResultAsSplitRegion(REGIONINFO, SERVERNAME_A) : this.getMetaTableRowResult(REGIONINFO, SERVERNAME_A);
        } else if (sn.equals((Object)SERVERNAME_A)) {
            r = this.getMetaTableRowResult(REGIONINFO, SERVERNAME_A);
        } else if (sn.equals((Object)SERVERNAME_B)) {
            r = new Result(new KeyValue[0]);
        }
        Mockito.when((Object)implementation.openScanner((byte[])Mockito.any(), (Scan)Mockito.any())).thenReturn((Object)System.currentTimeMillis());
        Mockito.when((Object)implementation.next(Mockito.anyLong(), Mockito.anyInt())).thenReturn((Object)new Result[]{r}, (Object[])new Result[][]{null});
        HConnection connection = HConnectionTestingUtility.getMockedConnectionAndDecorate(HTU.getConfiguration(), implementation, SERVERNAME_B, REGIONINFO);
        Mockito.when((Object)ct.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)this.server.getCatalogTracker()).thenReturn((Object)ct);
        DeadServer deadServers = new DeadServer();
        deadServers.add(SERVERNAME_A);
        MasterServices services = (MasterServices)Mockito.mock(MasterServices.class);
        Mockito.when((Object)services.getAssignmentManager()).thenReturn((Object)am);
        Mockito.when((Object)services.getZooKeeper()).thenReturn((Object)this.watcher);
        ServerShutdownHandler handler = null;
        handler = sn != null ? new ServerShutdownHandler(this.server, services, deadServers, sn, false) : new ServerShutdownHandler(this.server, services, deadServers, SERVERNAME_A, false);
        handler.process();
    }

    private Result getMetaTableRowResult(HRegionInfo hri, ServerName sn) throws IOException {
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(new KeyValue(HConstants.EMPTY_BYTE_ARRAY, HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)hri)));
        kvs.add(new KeyValue(HConstants.EMPTY_BYTE_ARRAY, HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes((String)sn.getHostAndPort())));
        kvs.add(new KeyValue(HConstants.EMPTY_BYTE_ARRAY, HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER, Bytes.toBytes((long)sn.getStartcode())));
        return new Result(kvs);
    }

    private Result getMetaTableRowResultAsSplitRegion(HRegionInfo hri, ServerName sn) throws IOException {
        hri.setOffline(true);
        hri.setSplit(true);
        return this.getMetaTableRowResult(hri, sn);
    }

    private ExecutorService startupMasterExecutor(String name) {
        ExecutorService executor = new ExecutorService(name);
        executor.startExecutorService(ExecutorService.ExecutorType.MASTER_OPEN_REGION, 3);
        executor.startExecutorService(ExecutorService.ExecutorType.MASTER_CLOSE_REGION, 3);
        executor.startExecutorService(ExecutorService.ExecutorType.MASTER_SERVER_OPERATIONS, 3);
        executor.startExecutorService(ExecutorService.ExecutorType.MASTER_META_SERVER_OPERATIONS, 3);
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnassignWithSplitAtSameTime() throws KeeperException, IOException {
        HRegionInfo hri = HRegionInfo.FIRST_META_REGIONINFO;
        Mockito.when((Object)this.serverManager.sendRegionClose(SERVERNAME_A, hri, -1)).thenReturn((Object)true);
        CatalogTracker ct = (CatalogTracker)Mockito.mock(CatalogTracker.class);
        LoadBalancer balancer = LoadBalancerFactory.getLoadBalancer((Configuration)this.server.getConfiguration());
        AssignmentManager am = new AssignmentManager(this.server, this.serverManager, ct, balancer, null);
        try {
            this.unassign(am, SERVERNAME_A, hri);
            ZKAssign.deleteClosingNode((ZooKeeperWatcher)this.watcher, (HRegionInfo)hri);
            int version = TestAssignmentManager.createNodeSplitting(this.watcher, hri, SERVERNAME_A);
            this.unassign(am, SERVERNAME_A, hri);
            ZKAssign.transitionNode((ZooKeeperWatcher)this.watcher, (HRegionInfo)hri, (ServerName)SERVERNAME_A, (EventHandler.EventType)EventHandler.EventType.RS_ZK_REGION_SPLITTING, (EventHandler.EventType)EventHandler.EventType.RS_ZK_REGION_SPLITTING, (int)version);
            Assert.assertTrue((am.isRegionInTransition(hri) == null ? 1 : 0) != 0);
        }
        finally {
            am.shutdown();
        }
    }

    @Test(timeout=5000L)
    public void testProcessDeadServersAndRegionsInTransitionShouldNotFailWithNPE() throws IOException, KeeperException, InterruptedException, ServiceException {
        final RecoverableZooKeeper recoverableZk = (RecoverableZooKeeper)Mockito.mock(RecoverableZooKeeper.class);
        AssignmentManagerWithExtrasForTesting am = this.setUpMockedAssignmentManager(this.server, this.serverManager);
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(HBaseConfiguration.create(), "unittest", null){

            public RecoverableZooKeeper getRecoverableZooKeeper() {
                return recoverableZk;
            }
        };
        ((ZooKeeperWatcher)zkw).registerListener((ZooKeeperListener)am);
        ((RecoverableZooKeeper)Mockito.doThrow((Throwable)new InterruptedException()).when((Object)recoverableZk)).getChildren("/hbase/unassigned", (Watcher)zkw);
        am.setWatcher(zkw);
        try {
            am.processDeadServersAndRegionsInTransition();
            Assert.fail((String)"Expected to abort");
        }
        catch (NullPointerException e) {
            Assert.fail((String)"Should not throw NPE");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Aborted", (Object)e.getLocalizedMessage());
        }
    }

    private static int createNodeSplitting(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName) throws KeeperException, IOException {
        RegionTransitionData data = new RegionTransitionData(EventHandler.EventType.RS_ZK_REGION_SPLITTING, region.getRegionName(), serverName);
        String node = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)region.getEncodedName());
        if (!ZKUtil.createEphemeralNodeAndWatch((ZooKeeperWatcher)zkw, (String)node, (byte[])data.getBytes())) {
            throw new IOException("Failed create of ephemeral " + node);
        }
        return TestAssignmentManager.transitionNodeSplitting(zkw, region, serverName, -1);
    }

    private static int transitionNodeSplitting(ZooKeeperWatcher zkw, HRegionInfo parent, ServerName serverName, int version) throws KeeperException, IOException {
        return ZKAssign.transitionNode((ZooKeeperWatcher)zkw, (HRegionInfo)parent, (ServerName)serverName, (EventHandler.EventType)EventHandler.EventType.RS_ZK_REGION_SPLITTING, (EventHandler.EventType)EventHandler.EventType.RS_ZK_REGION_SPLITTING, (int)version);
    }

    private void unassign(AssignmentManager am, ServerName sn, HRegionInfo hri) {
        am.regionOnline(hri, sn);
        am.unassign(hri);
    }

    private AssignmentManagerWithExtrasForTesting setUpMockedAssignmentManager(Server server, ServerManager manager) throws IOException, KeeperException {
        CatalogTracker ct = (CatalogTracker)Mockito.mock(CatalogTracker.class);
        HRegionInterface ri = (HRegionInterface)Mockito.mock(HRegionInterface.class);
        Result[] result = null;
        if (enabling) {
            result = new Result[]{this.getMetaTableRowResult(REGIONINFO, SERVERNAME_A), this.getMetaTableRowResult(REGIONINFO_2, SERVERNAME_A)};
        }
        Result r = this.getMetaTableRowResult(REGIONINFO, SERVERNAME_A);
        Mockito.when((Object)ri.openScanner((byte[])Mockito.any(), (Scan)Mockito.any())).thenReturn((Object)System.currentTimeMillis());
        if (enabling) {
            Mockito.when((Object)ri.next(Mockito.anyLong(), Mockito.anyInt())).thenReturn((Object)result, (Object[])new Result[][]{result, result, null});
            Mockito.when((Object)ri.get((byte[])Mockito.any(), (Get)Mockito.any())).thenReturn((Object)this.getMetaTableRowResult(REGIONINFO_2, SERVERNAME_A));
        } else {
            Mockito.when((Object)ri.next(Mockito.anyLong(), Mockito.anyInt())).thenReturn((Object)new Result[]{r});
            Mockito.when((Object)ri.get((byte[])Mockito.any(), (Get)Mockito.any())).thenReturn((Object)r);
        }
        HConnection connection = HConnectionTestingUtility.getMockedConnectionAndDecorate(HTU.getConfiguration(), ri, SERVERNAME_B, REGIONINFO);
        Mockito.when((Object)ct.getConnection()).thenReturn((Object)connection);
        ExecutorService executor = this.startupMasterExecutor("mockedAMExecutor");
        this.balancer = LoadBalancerFactory.getLoadBalancer((Configuration)server.getConfiguration());
        AssignmentManagerWithExtrasForTesting am = new AssignmentManagerWithExtrasForTesting(server, manager, ct, this.balancer, executor);
        return am;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionPlanIsUpdatedWhenRegionFailsToOpen() throws IOException, KeeperException, ServiceException, InterruptedException {
        this.server.getConfiguration().setClass("hbase.master.loadbalancer.class", MockedLoadBalancer.class, LoadBalancer.class);
        AssignmentManagerWithExtrasForTesting am = this.setUpMockedAssignmentManager(this.server, this.serverManager);
        try {
            AtomicBoolean gate = new AtomicBoolean(false);
            if (this.balancer instanceof MockedLoadBalancer) {
                ((MockedLoadBalancer)this.balancer).setGateVariable(gate);
            }
            ZKAssign.createNodeOffline((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_A);
            int v = ZKAssign.getVersion((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO);
            ZKAssign.transitionNode((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO, (ServerName)SERVERNAME_A, (EventHandler.EventType)EventHandler.EventType.M_ZK_REGION_OFFLINE, (EventHandler.EventType)EventHandler.EventType.RS_ZK_REGION_FAILED_OPEN, (int)v);
            String path = ZKAssign.getNodeName((ZooKeeperWatcher)this.watcher, (String)REGIONINFO.getEncodedName());
            AssignmentManager.RegionState state = new AssignmentManager.RegionState(REGIONINFO, AssignmentManager.RegionState.State.OPENING, System.currentTimeMillis(), SERVERNAME_A);
            am.regionsInTransition.put(REGIONINFO.getEncodedName(), state);
            am.regionPlans.put(REGIONINFO.getEncodedName(), new RegionPlan(REGIONINFO, null, SERVERNAME_A));
            RegionPlan regionPlan = (RegionPlan)am.regionPlans.get(REGIONINFO.getEncodedName());
            ArrayList<ServerName> serverList = new ArrayList<ServerName>(2);
            serverList.add(SERVERNAME_B);
            Mockito.when((Object)this.serverManager.getOnlineServersList()).thenReturn(serverList);
            am.nodeDataChanged(path);
            while (!gate.get()) {
                Thread.sleep(10L);
            }
            RegionPlan newRegionPlan = (RegionPlan)am.regionPlans.get(REGIONINFO.getEncodedName());
            while (newRegionPlan == null) {
                Thread.sleep(10L);
                newRegionPlan = (RegionPlan)am.regionPlans.get(REGIONINFO.getEncodedName());
            }
            Assert.assertNotSame((String)"Same region plan should not come", (Object)regionPlan, (Object)newRegionPlan);
            Assert.assertTrue((String)"Destnation servers should be different.", (!regionPlan.getDestination().equals((Object)newRegionPlan.getDestination()) ? 1 : 0) != 0);
            Mocking.waitForRegionOfflineInRIT(am, REGIONINFO.getEncodedName());
        }
        finally {
            this.server.getConfiguration().setClass("hbase.master.loadbalancer.class", DefaultLoadBalancer.class, LoadBalancer.class);
            am.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisablingTableRegionsAssignmentDuringCleanClusterStartup() throws KeeperException, IOException, Exception {
        this.server.getConfiguration().setClass("hbase.master.loadbalancer.class", MockedLoadBalancer.class, LoadBalancer.class);
        Mockito.when((Object)this.serverManager.getOnlineServers()).thenReturn(new HashMap(0));
        ArrayList<ServerName> destServers = new ArrayList<ServerName>(1);
        destServers.add(SERVERNAME_A);
        Mockito.when((Object)this.serverManager.getDrainingServersList()).thenReturn(destServers);
        AssignmentManagerWithExtrasForTesting am = this.setUpMockedAssignmentManager(this.server, this.serverManager);
        AtomicBoolean gate = new AtomicBoolean(false);
        if (this.balancer instanceof MockedLoadBalancer) {
            ((MockedLoadBalancer)this.balancer).setGateVariable(gate);
        }
        try {
            am.getZKTable().setDisablingTable(REGIONINFO.getTableNameAsString());
            am.joinCluster();
            Assert.assertFalse((String)"Assign should not be invoked for disabling table regions during clean cluster startup.", (boolean)gate.get());
            Assert.assertTrue((String)"Table should be disabled.", (boolean)am.getZKTable().isDisabledTable(REGIONINFO.getTableNameAsString()));
        }
        finally {
            this.server.getConfiguration().setClass("hbase.master.loadbalancer.class", DefaultLoadBalancer.class, LoadBalancer.class);
            am.getZKTable().setEnabledTable(REGIONINFO.getTableNameAsString());
            am.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterRestartWhenTableInEnabling() throws KeeperException, IOException, Exception {
        enabling = true;
        this.server.getConfiguration().setClass("hbase.master.loadbalancer.class", DefaultLoadBalancer.class, LoadBalancer.class);
        HashMap<ServerName, Object> serverAndLoad = new HashMap<ServerName, Object>();
        serverAndLoad.put(SERVERNAME_A, null);
        Mockito.when((Object)this.serverManager.getOnlineServers()).thenReturn(serverAndLoad);
        Mockito.when((Object)this.serverManager.isServerOnline(SERVERNAME_B)).thenReturn((Object)false);
        Mockito.when((Object)this.serverManager.isServerOnline(SERVERNAME_A)).thenReturn((Object)true);
        HTU.getConfiguration().setInt("hbase.master.port", 0);
        HMaster server = new HMaster(HTU.getConfiguration());
        Whitebox.setInternalState((Object)server, (String)"serverManager", (Object)this.serverManager);
        assignmentCount = 0;
        AssignmentManagerWithExtrasForTesting am = this.setUpMockedAssignmentManager((Server)server, this.serverManager);
        am.regionOnline(new HRegionInfo("t1".getBytes(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW), SERVERNAME_A);
        am.gate.set(false);
        try {
            am.getZKTable().setEnablingTable(REGIONINFO.getTableNameAsString());
            ZKAssign.createNodeOffline((ZooKeeperWatcher)this.watcher, (HRegionInfo)REGIONINFO_2, (ServerName)SERVERNAME_B);
            am.joinCluster();
            while (!am.getZKTable().isEnabledTable(REGIONINFO.getTableNameAsString())) {
                Thread.sleep(10L);
            }
            Assert.assertEquals((String)"Number of assignments should be equal.", (long)2L, (long)assignmentCount);
            Assert.assertTrue((String)"Table should be enabled.", (boolean)am.getZKTable().isEnabledTable(REGIONINFO.getTableNameAsString()));
        }
        finally {
            enabling = false;
            am.getZKTable().setEnabledTable(REGIONINFO.getTableNameAsString());
            am.shutdown();
            ZKAssign.deleteAllNodes((ZooKeeperWatcher)this.watcher);
            assignmentCount = 0;
        }
    }

    @Test
    public void testSSHWhenSourceRSandDestRSInRegionPlanGoneDown() throws KeeperException, IOException, ServiceException {
        this.testSSHWhenSourceRSandDestRSInRegionPlanGoneDown(true);
        this.testSSHWhenSourceRSandDestRSInRegionPlanGoneDown(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSSHWhenSourceRSandDestRSInRegionPlanGoneDown(boolean regionInOffline) throws IOException, KeeperException, ServiceException {
        CatalogTracker ct = (CatalogTracker)Mockito.mock(CatalogTracker.class);
        AssignmentManagerWithExtrasForTesting am = this.setUpMockedAssignmentManager(this.server, this.serverManager);
        if (regionInOffline) {
            ServerName MASTER_SERVERNAME = new ServerName("example.org", 1111, 1111L);
            am.regionsInTransition.put(REGIONINFO.getEncodedName(), new AssignmentManager.RegionState(REGIONINFO, AssignmentManager.RegionState.State.OFFLINE, System.currentTimeMillis(), MASTER_SERVERNAME));
        } else {
            am.regionsInTransition.put(REGIONINFO.getEncodedName(), new AssignmentManager.RegionState(REGIONINFO, AssignmentManager.RegionState.State.OPENING, System.currentTimeMillis(), SERVERNAME_B));
        }
        am.regionPlans.put(REGIONINFO.getEncodedName(), new RegionPlan(REGIONINFO, SERVERNAME_A, SERVERNAME_B));
        am.getZKTable().setEnabledTable(REGIONINFO.getTableNameAsString());
        try {
            this.processServerShutdownHandler(ct, am, false, SERVERNAME_A);
            this.processServerShutdownHandler(ct, am, false, SERVERNAME_B);
            if (regionInOffline) {
                Assert.assertFalse((String)"Assign should not be invoked.", (boolean)am.assignInvoked);
            } else {
                Assert.assertTrue((String)"Assign should be invoked.", (boolean)am.assignInvoked);
            }
        }
        finally {
            am.regionsInTransition.remove(REGIONINFO.getEncodedName());
            am.regionPlans.remove(REGIONINFO.getEncodedName());
        }
    }

    private void startFakeFailedOverMasterAssignmentManager(final AssignmentManager am, ZooKeeperWatcher watcher) {
        watcher.registerListenerFirst((ZooKeeperListener)am);
        Thread t = new Thread("RunAmJoinCluster"){

            @Override
            public void run() {
                am.regionsInTransition.clear();
                am.regionPlans.clear();
                try {
                    am.joinCluster();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (KeeperException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        t.start();
        while (!t.isAlive()) {
            Threads.sleep((long)1L);
        }
    }

    static {
        enabling = false;
    }

    class AssignmentManagerWithExtrasForTesting
    extends AssignmentManager {
        private final ExecutorService es;
        private final CatalogTracker ct;
        boolean processRITInvoked;
        boolean assignInvoked;
        AtomicBoolean gate;

        public AssignmentManagerWithExtrasForTesting(Server master, ServerManager serverManager, CatalogTracker catalogTracker, LoadBalancer balancer, ExecutorService service) throws KeeperException, IOException {
            super(master, serverManager, catalogTracker, balancer, service);
            this.processRITInvoked = false;
            this.assignInvoked = false;
            this.gate = new AtomicBoolean(true);
            this.es = service;
            this.ct = catalogTracker;
        }

        boolean processRegionInTransition(String encodedRegionName, HRegionInfo regionInfo, Map<ServerName, List<Pair<HRegionInfo, Result>>> deadServers) throws KeeperException, IOException {
            this.processRITInvoked = true;
            return super.processRegionInTransition(encodedRegionName, regionInfo, deadServers);
        }

        void processRegionsInTransition(RegionTransitionData data, HRegionInfo regionInfo, Map<ServerName, List<Pair<HRegionInfo, Result>>> deadServers, int expectedVersion) throws KeeperException {
            while (this.gate.get()) {
                Threads.sleep((long)1L);
            }
            super.processRegionsInTransition(data, regionInfo, deadServers, expectedVersion);
        }

        public void assign(HRegionInfo region, boolean setOfflineInZK, boolean forceNewPlan, boolean hijack) {
            if (enabling) {
                assignmentCount++;
                this.regionOnline(region, SERVERNAME_A);
            } else {
                this.assignInvoked = true;
                super.assign(region, setOfflineInZK, forceNewPlan, hijack);
            }
        }

        public ServerName getRegionServerOfRegion(HRegionInfo hri) {
            return SERVERNAME_A;
        }

        void setWatcher(ZooKeeperWatcher watcher) {
            this.watcher = watcher;
        }

        ExecutorService getExecutorService() {
            return this.es;
        }

        CatalogTracker getCatalogTracker() {
            return this.ct;
        }
    }

    public static class MockedLoadBalancer
    extends DefaultLoadBalancer {
        private AtomicBoolean gate;

        public void setGateVariable(AtomicBoolean gate) {
            this.gate = gate;
        }

        public ServerName randomAssignment(List<ServerName> servers) {
            ServerName randomServerName = super.randomAssignment(servers);
            this.gate.set(true);
            return randomServerName;
        }

        public Map<ServerName, List<HRegionInfo>> retainAssignment(Map<HRegionInfo, ServerName> regions, List<ServerName> servers) {
            this.gate.set(true);
            return super.retainAssignment(regions, servers);
        }
    }
}

