/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.DefaultLoadBalancer;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.ServerAndLoad;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestDefaultLoadBalancer {
    private static final Log LOG = LogFactory.getLog(TestDefaultLoadBalancer.class);
    private static LoadBalancer loadBalancer;
    private static Random rand;
    int[][] clusterStateMocks = new int[][]{{0}, {1}, {10}, {0, 0}, {2, 0}, {2, 1}, {2, 2}, {2, 3}, {2, 4}, {1, 1}, {0, 1}, {10, 1}, {14, 1432}, {47, 53}, {0, 1, 2}, {1, 2, 3}, {0, 2, 2}, {0, 3, 0}, {0, 4, 0}, {20, 20, 0}, {0, 1, 2, 3}, {4, 0, 0, 0}, {5, 0, 0, 0}, {6, 6, 0, 0}, {6, 2, 0, 0}, {6, 1, 0, 0}, {6, 0, 0, 0}, {4, 4, 4, 7}, {4, 4, 4, 8}, {0, 0, 0, 7}, {1, 1, 1, 1, 4}, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 10}, {6, 6, 5, 6, 6, 6, 6, 6, 6, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 54}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 55}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 56}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 16}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 8}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 9}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 10}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 123}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 155}, {0, 0, 144, 1, 1, 1, 1, 1123, 133, 138, 12, 1444}, {0, 0, 144, 1, 0, 4, 1, 1123, 133, 138, 12, 1444}, {1538, 1392, 1561, 1557, 1535, 1553, 1385, 1542, 1619}};
    int[][] regionsAndServersMocks = new int[][]{{0, 0}, {0, 1}, {1, 1}, {2, 1}, {10, 1}, {1, 2}, {2, 2}, {3, 2}, {1, 3}, {2, 3}, {3, 3}, {25, 3}, {2, 10}, {2, 100}, {12, 10}, {12, 100}};
    private Queue<HRegionInfo> regionQueue = new LinkedList<HRegionInfo>();
    static int regionId;
    private Queue<ServerName> serverQueue = new LinkedList<ServerName>();
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.regions.slop", "0");
        loadBalancer = new DefaultLoadBalancer();
        loadBalancer.setConf(conf);
        rand = new Random();
    }

    @Test
    public void testBalanceCluster() throws Exception {
        for (int[] mockCluster : this.clusterStateMocks) {
            Map<ServerName, List<HRegionInfo>> servers = this.mockClusterServers(mockCluster);
            List<ServerAndLoad> list = this.convertToList(servers);
            LOG.info((Object)("Mock Cluster : " + this.printMock(list) + " " + this.printStats(list)));
            List plans = loadBalancer.balanceCluster(servers);
            List<ServerAndLoad> balancedCluster = this.reconcile(list, plans);
            LOG.info((Object)("Mock Balance : " + this.printMock(balancedCluster)));
            this.assertClusterAsBalanced(balancedCluster);
            for (Map.Entry<ServerName, List<HRegionInfo>> entry : servers.entrySet()) {
                this.returnRegions(entry.getValue());
                this.returnServer(entry.getKey());
            }
        }
    }

    public void assertClusterAsBalanced(List<ServerAndLoad> servers) {
        int numServers = servers.size();
        int numRegions = 0;
        int maxRegions = 0;
        int minRegions = Integer.MAX_VALUE;
        for (ServerAndLoad server : servers) {
            int nr = server.getLoad();
            if (nr > maxRegions) {
                maxRegions = nr;
            }
            if (nr < minRegions) {
                minRegions = nr;
            }
            numRegions += nr;
        }
        if (maxRegions - minRegions < 2) {
            return;
        }
        int min = numRegions / numServers;
        int max = numRegions % numServers == 0 ? min : min + 1;
        for (ServerAndLoad server : servers) {
            Assert.assertTrue((server.getLoad() <= max ? 1 : 0) != 0);
            Assert.assertTrue((server.getLoad() >= min ? 1 : 0) != 0);
        }
    }

    @Test
    public void testImmediateAssignment() throws Exception {
        for (int[] mock : this.regionsAndServersMocks) {
            LOG.debug((Object)("testImmediateAssignment with " + mock[0] + " regions and " + mock[1] + " servers"));
            List<HRegionInfo> regions = this.randomRegions(mock[0]);
            List<ServerAndLoad> servers = this.randomServers(mock[1], 0);
            List<ServerName> list = this.getListOfServerNames(servers);
            Map assignments = loadBalancer.immediateAssignment(regions, list);
            this.assertImmediateAssignment(regions, list, assignments);
            this.returnRegions(regions);
            this.returnServers(list);
        }
    }

    private void assertImmediateAssignment(List<HRegionInfo> regions, List<ServerName> servers, Map<HRegionInfo, ServerName> assignments) {
        for (HRegionInfo region : regions) {
            Assert.assertTrue((boolean)assignments.containsKey(region));
        }
    }

    @Test
    public void testBulkAssignment() throws Exception {
        for (int[] mock : this.regionsAndServersMocks) {
            LOG.debug((Object)("testBulkAssignment with " + mock[0] + " regions and " + mock[1] + " servers"));
            List<HRegionInfo> regions = this.randomRegions(mock[0]);
            List<ServerAndLoad> servers = this.randomServers(mock[1], 0);
            List<ServerName> list = this.getListOfServerNames(servers);
            Map assignments = loadBalancer.roundRobinAssignment(regions, list);
            float average = (float)regions.size() / (float)servers.size();
            int min = (int)Math.floor(average);
            int max = (int)Math.ceil(average);
            if (assignments != null && !assignments.isEmpty()) {
                for (List regionList : assignments.values()) {
                    Assert.assertTrue((regionList.size() == min || regionList.size() == max ? 1 : 0) != 0);
                }
            }
            this.returnRegions(regions);
            this.returnServers(list);
        }
    }

    @Test
    public void testRetainAssignment() throws Exception {
        List<ServerAndLoad> servers = this.randomServers(10, 10);
        List<HRegionInfo> regions = this.randomRegions(100);
        TreeMap<HRegionInfo, ServerName> existing = new TreeMap<HRegionInfo, ServerName>();
        for (int i = 0; i < regions.size(); ++i) {
            ServerName sn = servers.get(i % servers.size()).getServerName();
            ServerName snWithOldStartCode = new ServerName(sn.getHostname(), sn.getPort(), sn.getStartcode() - 10L);
            existing.put(regions.get(i), snWithOldStartCode);
        }
        List<ServerName> listOfServerNames = this.getListOfServerNames(servers);
        Map assignment = loadBalancer.retainAssignment(existing, listOfServerNames);
        this.assertRetainedAssignment(existing, listOfServerNames, assignment);
        ArrayList<ServerAndLoad> servers2 = new ArrayList<ServerAndLoad>(servers);
        servers2.add(this.randomServer(10));
        servers2.add(this.randomServer(10));
        listOfServerNames = this.getListOfServerNames(servers2);
        assignment = loadBalancer.retainAssignment(existing, listOfServerNames);
        this.assertRetainedAssignment(existing, listOfServerNames, assignment);
        ArrayList<ServerAndLoad> servers3 = new ArrayList<ServerAndLoad>(servers);
        servers3.remove(0);
        servers3.remove(0);
        listOfServerNames = this.getListOfServerNames(servers3);
        assignment = loadBalancer.retainAssignment(existing, listOfServerNames);
        this.assertRetainedAssignment(existing, listOfServerNames, assignment);
    }

    private List<ServerName> getListOfServerNames(List<ServerAndLoad> sals) {
        ArrayList<ServerName> list = new ArrayList<ServerName>();
        for (ServerAndLoad e : sals) {
            list.add(e.getServerName());
        }
        return list;
    }

    private void assertRetainedAssignment(Map<HRegionInfo, ServerName> existing, List<ServerName> servers, Map<ServerName, List<HRegionInfo>> assignment) {
        TreeSet<ServerName> onlineServerSet = new TreeSet<ServerName>(servers);
        TreeSet<HRegionInfo> assignedRegions = new TreeSet<HRegionInfo>();
        for (Map.Entry<ServerName, List<HRegionInfo>> a : assignment.entrySet()) {
            Assert.assertTrue((String)"Region assigned to server that was not listed as online", (boolean)onlineServerSet.contains(a.getKey()));
            for (HRegionInfo r : a.getValue()) {
                assignedRegions.add(r);
            }
        }
        Assert.assertEquals((long)existing.size(), (long)assignedRegions.size());
        TreeSet<String> onlineHostNames = new TreeSet<String>();
        for (ServerName serverName : servers) {
            onlineHostNames.add(serverName.getHostname());
        }
        for (Map.Entry entry : assignment.entrySet()) {
            ServerName assignedTo = (ServerName)entry.getKey();
            for (HRegionInfo r : (List)entry.getValue()) {
                ServerName address = existing.get(r);
                if (address == null || !onlineHostNames.contains(address.getHostname())) continue;
                Assert.assertEquals((Object)address.getHostname(), (Object)assignedTo.getHostname());
            }
        }
    }

    private String printStats(List<ServerAndLoad> servers) {
        int numServers = servers.size();
        int totalRegions = 0;
        for (ServerAndLoad server : servers) {
            totalRegions += server.getLoad();
        }
        float average = (float)totalRegions / (float)numServers;
        int max = (int)Math.ceil(average);
        int min = (int)Math.floor(average);
        return "[srvr=" + numServers + " rgns=" + totalRegions + " avg=" + average + " max=" + max + " min=" + min + "]";
    }

    private List<ServerAndLoad> convertToList(Map<ServerName, List<HRegionInfo>> servers) {
        ArrayList<ServerAndLoad> list = new ArrayList<ServerAndLoad>(servers.size());
        for (Map.Entry<ServerName, List<HRegionInfo>> e : servers.entrySet()) {
            list.add(new ServerAndLoad(e.getKey(), e.getValue().size()));
        }
        return list;
    }

    private String printMock(List<ServerAndLoad> balancedCluster) {
        TreeSet<ServerAndLoad> sorted = new TreeSet<ServerAndLoad>(balancedCluster);
        ServerAndLoad[] arr = sorted.toArray(new ServerAndLoad[sorted.size()]);
        StringBuilder sb = new StringBuilder(sorted.size() * 4 + 4);
        sb.append("{ ");
        for (int i = 0; i < arr.length; ++i) {
            if (i != 0) {
                sb.append(" , ");
            }
            sb.append(arr[i].getLoad());
        }
        sb.append(" }");
        return sb.toString();
    }

    private List<ServerAndLoad> reconcile(List<ServerAndLoad> list, List<RegionPlan> plans) {
        ArrayList<ServerAndLoad> result = new ArrayList<ServerAndLoad>(list.size());
        if (plans == null) {
            return result;
        }
        HashMap<ServerName, ServerAndLoad> map = new HashMap<ServerName, ServerAndLoad>(list.size());
        for (RegionPlan plan : plans) {
            ServerName source = plan.getSource();
            this.updateLoad(map, source, -1);
            ServerName destination = plan.getDestination();
            this.updateLoad(map, destination, 1);
        }
        result.clear();
        result.addAll(map.values());
        return result;
    }

    private void updateLoad(Map<ServerName, ServerAndLoad> map, ServerName sn, int diff) {
        ServerAndLoad sal = map.get(sn);
        if (sal == null) {
            return;
        }
        sal = new ServerAndLoad(sn, sal.getLoad() + diff);
        map.put(sn, sal);
    }

    private Map<ServerName, List<HRegionInfo>> mockClusterServers(int[] mockCluster) {
        int numServers = mockCluster.length;
        TreeMap<ServerName, List<HRegionInfo>> servers = new TreeMap<ServerName, List<HRegionInfo>>();
        for (int i = 0; i < numServers; ++i) {
            int numRegions = mockCluster[i];
            ServerAndLoad sal = this.randomServer(0);
            List<HRegionInfo> regions = this.randomRegions(numRegions);
            servers.put(sal.getServerName(), regions);
        }
        return servers;
    }

    private List<HRegionInfo> randomRegions(int numRegions) {
        ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>(numRegions);
        byte[] start = new byte[16];
        byte[] end = new byte[16];
        rand.nextBytes(start);
        rand.nextBytes(end);
        for (int i = 0; i < numRegions; ++i) {
            if (!this.regionQueue.isEmpty()) {
                regions.add(this.regionQueue.poll());
                continue;
            }
            Bytes.putInt((byte[])start, (int)0, (int)(numRegions << 1));
            Bytes.putInt((byte[])end, (int)0, (int)((numRegions << 1) + 1));
            HRegionInfo hri = new HRegionInfo(Bytes.toBytes((String)("table" + i)), start, end, false, (long)regionId++);
            regions.add(hri);
        }
        return regions;
    }

    private void returnRegions(List<HRegionInfo> regions) {
        this.regionQueue.addAll(regions);
    }

    private ServerAndLoad randomServer(int numRegionsPerServer) {
        if (!this.serverQueue.isEmpty()) {
            ServerName sn = this.serverQueue.poll();
            return new ServerAndLoad(sn, numRegionsPerServer);
        }
        String host = "server" + rand.nextInt(100000);
        int port = rand.nextInt(60000);
        long startCode = rand.nextLong();
        ServerName sn = new ServerName(host, port, startCode);
        return new ServerAndLoad(sn, numRegionsPerServer);
    }

    private List<ServerAndLoad> randomServers(int numServers, int numRegionsPerServer) {
        ArrayList<ServerAndLoad> servers = new ArrayList<ServerAndLoad>(numServers);
        for (int i = 0; i < numServers; ++i) {
            servers.add(this.randomServer(numRegionsPerServer));
        }
        return servers;
    }

    private void returnServer(ServerName server) {
        this.serverQueue.add(server);
    }

    private void returnServers(List<ServerName> servers) {
        this.serverQueue.addAll(servers);
    }

    static {
        regionId = 0;
    }
}

