/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.HMasterInterface;
import org.apache.hadoop.hbase.ipc.RpcEngine;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.ipc.RemoteException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestHMasterRPCException {
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRPCException() throws Exception {
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.startMiniZKCluster();
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.master.port", "0");
        HMaster hm = new HMaster(conf);
        ServerName sm = hm.getServerName();
        InetSocketAddress isa = new InetSocketAddress(sm.getHostname(), sm.getPort());
        RpcEngine rpcEngine = null;
        try {
            rpcEngine = HBaseRPC.getProtocolEngine((Configuration)conf);
            HMasterInterface inf = (HMasterInterface)rpcEngine.getProxy(HMasterInterface.class, 29L, isa, conf, 1000);
            inf.isMasterRunning();
            Assert.fail();
        }
        catch (RemoteException ex) {
            Assert.assertTrue((boolean)ex.getMessage().startsWith("org.apache.hadoop.hbase.ipc.ServerNotRunningYetException: Server is not running yet"));
        }
        catch (Throwable t) {
            Assert.fail((String)("Unexpected throwable: " + t));
        }
        finally {
            if (rpcEngine != null) {
                rpcEngine.close();
            }
        }
    }
}

