/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.master.DefaultLoadBalancer;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMasterZKSessionRecovery {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRegionAssignmentAfterMasterRecoveryDueToZKExpiry() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        cluster.startRegionServer();
        HMaster m = cluster.getMaster();
        HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        byte[][] SPLIT_KEYS = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"e"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"g"), Bytes.toBytes((String)"h"), Bytes.toBytes((String)"i"), Bytes.toBytes((String)"j")};
        String tableName = "testRegionAssignmentAfterMasterRecoveryDueToZKExpiry";
        admin.createTable(new HTableDescriptor(tableName), (byte[][])SPLIT_KEYS);
        ZooKeeperWatcher zooKeeperWatcher = HBaseTestingUtility.getZooKeeperWatcher(TEST_UTIL);
        ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)zooKeeperWatcher);
        m.getZooKeeperWatcher().close();
        MockLoadBalancer.retainAssignCalled = false;
        m.abort("Test recovery from zk session expired", (Throwable)new KeeperException.SessionExpiredException());
        Assert.assertFalse((boolean)m.isStopped());
        Assert.assertFalse((String)"Retain assignment should not be called", (boolean)MockLoadBalancer.retainAssignCalled);
    }

    @Test(timeout=60000L)
    public void testLogSplittingAfterMasterRecoveryDueToZKExpiry() throws IOException, KeeperException, InterruptedException {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        cluster.startRegionServer();
        HMaster m = cluster.getMaster();
        HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        byte[][] SPLIT_KEYS = new byte[][]{Bytes.toBytes((String)"1"), Bytes.toBytes((String)"2"), Bytes.toBytes((String)"3"), Bytes.toBytes((String)"4"), Bytes.toBytes((String)"5")};
        String tableName = "testLogSplittingAfterMasterRecoveryDueToZKExpiry";
        HTableDescriptor htd = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor("col");
        htd.addFamily(hcd);
        admin.createTable(htd, (byte[][])SPLIT_KEYS);
        ZooKeeperWatcher zooKeeperWatcher = HBaseTestingUtility.getZooKeeperWatcher(TEST_UTIL);
        ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)zooKeeperWatcher);
        HTable table = new HTable(TEST_UTIL.getConfiguration(), tableName);
        Put p = null;
        int numberOfPuts = 0;
        for (numberOfPuts = 0; numberOfPuts < 6; ++numberOfPuts) {
            p = new Put(Bytes.toBytes((int)numberOfPuts));
            p.add(Bytes.toBytes((String)"col"), Bytes.toBytes((String)"ql"), Bytes.toBytes((String)("value" + numberOfPuts)));
            table.put(p);
        }
        m.getZooKeeperWatcher().close();
        m.abort("Test recovery from zk session expired", (Throwable)new KeeperException.SessionExpiredException());
        Assert.assertFalse((boolean)m.isStopped());
        cluster.getRegionServer(0).abort("Aborting");
        Scan scan = new Scan();
        int numberOfRows = 0;
        ResultScanner scanner = table.getScanner(scan);
        Result[] result = scanner.next(1);
        while (result != null && result.length > 0) {
            ++numberOfRows;
            result = scanner.next(1);
        }
        Assert.assertEquals((String)"Number of rows should be equal to number of puts.", (long)numberOfPuts, (long)numberOfRows);
    }

    static {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setLong("hbase.master.zksession.recover.timeout", 50000L);
        conf.setClass("hbase.master.loadbalancer.class", MockLoadBalancer.class, LoadBalancer.class);
    }

    static class MockLoadBalancer
    extends DefaultLoadBalancer {
        static boolean retainAssignCalled = false;

        MockLoadBalancer() {
        }

        public Map<ServerName, List<HRegionInfo>> retainAssignment(Map<HRegionInfo, ServerName> regions, List<ServerName> servers) {
            retainAssignCalled = true;
            return super.retainAssignment(regions, servers);
        }
    }
}

